/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.metrics;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Context;
import io.vertx.core.Deployable;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.ThreadingModel;
import io.vertx.core.Vertx;
import io.vertx.core.VertxBuilder;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.EventBusOptions;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientAgent;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.PoolOptions;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketClient;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.DatagramSocketMetrics;
import io.vertx.core.spi.metrics.EventBusMetrics;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.observability.HttpResponse;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.fakecluster.FakeClusterManager;
import io.vertx.test.http.HttpTestBase;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.junit.Ignore;
import org.junit.Test;

public class MetricsContextTest
extends VertxTestBase {
    private Function<Vertx, Context> eventLoopContextFactory = Vertx::getOrCreateContext;
    private Function<Vertx, Context> workerContextFactory = vertx -> {
        final AtomicReference ctx = new AtomicReference();
        vertx.deployVerticle((Deployable)new AbstractVerticle(){

            public void start() throws Exception {
                ctx.set(this.context);
                super.start();
            }
        }, new DeploymentOptions().setThreadingModel(ThreadingModel.WORKER));
        MetricsContextTest.assertWaitUntil(() -> ctx.get() != null);
        return (Context)ctx.get();
    };

    @Test
    public void testFactory() throws Exception {
        AtomicReference metricsThread = new AtomicReference();
        AtomicReference metricsContext = new AtomicReference();
        VertxMetricsFactory factory = options -> {
            metricsThread.set(Thread.currentThread());
            metricsContext.set(Vertx.currentContext());
            return new VertxMetrics(){};
        };
        this.vertx(() -> Vertx.builder().with(new VertxOptions().setMetricsOptions(new MetricsOptions().setEnabled(true))).withMetrics(factory).build());
        this.assertNull(metricsContext.get());
    }

    @Test
    public void testFactoryInCluster() throws Exception {
        AtomicReference metricsThread = new AtomicReference();
        AtomicReference metricsContext = new AtomicReference();
        Thread testThread = Thread.currentThread();
        VertxMetricsFactory factory = options -> {
            metricsThread.set(Thread.currentThread());
            metricsContext.set(Vertx.currentContext());
            return new VertxMetrics(){};
        };
        VertxBuilder builder = Vertx.builder().with(new VertxOptions().setMetricsOptions(new MetricsOptions().setEnabled(true)).setEventBusOptions(new EventBusOptions())).withClusterManager(this.getClusterManager()).withMetrics(factory);
        builder.withClusterManager((ClusterManager)new FakeClusterManager()).buildClustered().onComplete(this.onSuccess(vertx -> {
            this.assertSame(testThread, metricsThread.get());
            this.assertNull(metricsContext.get());
            vertx.close();
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testHttpServerRequestEventLoop() throws Exception {
        this.testHttpServerRequest(this.eventLoopContextFactory);
    }

    @Test
    public void testHttpServerRequestWorker() throws Exception {
        this.testHttpServerRequest(this.workerContextFactory);
    }

    private void testHttpServerRequest(Function<Vertx, Context> contextFactory) throws Exception {
        this.waitFor(2);
        AtomicReference expectedThread = new AtomicReference();
        AtomicReference expectedContext = new AtomicReference();
        final AtomicBoolean requestBeginCalled = new AtomicBoolean();
        final AtomicBoolean responseEndCalled = new AtomicBoolean();
        final AtomicBoolean socketConnectedCalled = new AtomicBoolean();
        final AtomicBoolean socketDisconnectedCalled = new AtomicBoolean();
        final AtomicBoolean bytesReadCalled = new AtomicBoolean();
        final AtomicBoolean bytesWrittenCalled = new AtomicBoolean();
        final AtomicBoolean closeCalled = new AtomicBoolean();
        VertxMetricsFactory factory = options -> new VertxMetrics(){

            public HttpServerMetrics createHttpServerMetrics(HttpServerOptions options, SocketAddress localAddress) {
                return new HttpServerMetrics<Void, Void, Void>(){

                    public Void requestBegin(Void socketMetric, HttpRequest request) {
                        requestBeginCalled.set(true);
                        return null;
                    }

                    public void responseEnd(Void requestMetric, HttpResponse response, long bytesWritten) {
                        responseEndCalled.set(true);
                    }

                    public Void connected(SocketAddress remoteAddress, String remoteName) {
                        socketConnectedCalled.set(true);
                        return null;
                    }

                    public void disconnected(Void socketMetric, SocketAddress remoteAddress) {
                        socketDisconnectedCalled.set(true);
                    }

                    public void bytesRead(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
                        bytesReadCalled.set(true);
                    }

                    public void bytesWritten(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
                        bytesWrittenCalled.set(true);
                    }

                    public void close() {
                        closeCalled.set(true);
                    }
                };
            }
        };
        CountDownLatch latch = new CountDownLatch(1);
        Vertx vertx = this.vertx(() -> Vertx.builder().with(new VertxOptions().setMetricsOptions(new MetricsOptions().setEnabled(true))).withMetrics(factory).build());
        Context ctx = contextFactory.apply(vertx);
        ctx.runOnContext(v1 -> {
            HttpServer server = vertx.createHttpServer().requestHandler(req -> {
                HttpServerResponse response = req.response();
                response.setStatusCode(200).setChunked(true).end("bye");
                req.connection().close();
            });
            server.listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost").onComplete(this.onSuccess(s -> {
                expectedThread.set(Thread.currentThread());
                expectedContext.set(Vertx.currentContext());
                latch.countDown();
            }));
        });
        this.awaitLatch(latch);
        HttpClientAgent client = vertx.httpClientBuilder().withConnectHandler(conn -> conn.closeHandler(v -> vertx.close().onComplete(v4 -> {
            this.assertTrue(requestBeginCalled.get());
            this.assertTrue(responseEndCalled.get());
            this.assertTrue(bytesReadCalled.get());
            this.assertTrue(bytesWrittenCalled.get());
            this.assertTrue(socketConnectedCalled.get());
            this.assertTrue(socketDisconnectedCalled.get());
            this.assertTrue(closeCalled.get());
            this.complete();
        }))).build();
        client.request(HttpMethod.PUT, HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").compose(req -> req.send(Buffer.buffer((String)"hello")).onComplete(this.onSuccess(resp -> this.complete())));
        this.await();
    }

    @Test
    public void testHttpServerRequestPipelining() throws Exception {
        this.waitFor(2);
        final AtomicInteger count = new AtomicInteger();
        VertxMetricsFactory factory = options -> new VertxMetrics(){

            public HttpServerMetrics createHttpServerMetrics(HttpServerOptions options, SocketAddress localAddress) {
                return new HttpServerMetrics<Void, Void, Void>(){

                    public Void requestBegin(Void socketMetric, HttpRequest request) {
                        switch (request.uri()) {
                            case "/1": {
                                MetricsContextTest.this.assertEquals(0L, count.get());
                                break;
                            }
                            case "/2": {
                                MetricsContextTest.this.assertEquals(1L, count.get());
                            }
                        }
                        return null;
                    }

                    public void requestEnd(Void requestMetric, HttpRequest request, long bytesRead) {
                        switch (request.uri()) {
                            case "/1": {
                                MetricsContextTest.this.assertEquals(1L, count.get());
                                break;
                            }
                            case "/2": {
                                MetricsContextTest.this.assertEquals(2L, count.get());
                            }
                        }
                    }

                    public void responseEnd(Void requestMetric, HttpResponse response, long bytesWritten) {
                    }

                    public Void connected(SocketAddress remoteAddress, String remoteName) {
                        return null;
                    }

                    public void disconnected(Void socketMetric, SocketAddress remoteAddress) {
                    }

                    public void bytesRead(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
                    }

                    public void bytesWritten(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
                    }

                    public void close() {
                    }
                };
            }
        };
        CountDownLatch latch = new CountDownLatch(1);
        Vertx vertx = this.vertx(() -> Vertx.builder().with(new VertxOptions().setMetricsOptions(new MetricsOptions().setEnabled(true))).withMetrics(factory).build());
        HttpServer server = vertx.createHttpServer().requestHandler(req -> {
            count.incrementAndGet();
            vertx.setTimer(10L, id -> {
                HttpServerResponse response = req.response();
                response.end();
            });
        });
        server.listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost").onComplete(this.onSuccess(s -> latch.countDown()));
        this.awaitLatch(latch);
        HttpClientAgent client = vertx.createHttpClient(new HttpClientOptions().setPipelining(true), new PoolOptions().setHttp1MaxSize(1));
        vertx.runOnContext(arg_0 -> this.lambda$testHttpServerRequestPipelining$21((HttpClient)client, arg_0));
        this.await();
    }

    @Test
    public void testHttpServerWebSocketEventLoop() throws Exception {
        this.testHttpServerWebSocket(this.eventLoopContextFactory);
    }

    @Ignore(value="Uncomment later after the inbound read queue merge")
    @Test
    public void testHttpServerWebSocketWorker() throws Exception {
        this.testHttpServerWebSocket(this.workerContextFactory);
    }

    private void testHttpServerWebSocket(Function<Vertx, Context> contextFactory) throws Exception {
        AtomicReference expectedThread = new AtomicReference();
        AtomicReference expectedContext = new AtomicReference();
        final AtomicBoolean webSocketConnected = new AtomicBoolean();
        final AtomicBoolean webSocketDisconnected = new AtomicBoolean();
        final AtomicBoolean socketConnectedCalled = new AtomicBoolean();
        final AtomicBoolean socketDisconnectedCalled = new AtomicBoolean();
        final AtomicBoolean bytesReadCalled = new AtomicBoolean();
        final AtomicBoolean bytesWrittenCalled = new AtomicBoolean();
        final AtomicBoolean closeCalled = new AtomicBoolean();
        final AtomicInteger httpLifecycle = new AtomicInteger();
        VertxMetricsFactory factory = options -> new VertxMetrics(){

            public HttpServerMetrics createHttpServerMetrics(HttpServerOptions options, SocketAddress localAddress) {
                return new HttpServerMetrics<Void, Void, Void>(){

                    public Void requestBegin(Void socketMetric, HttpRequest request) {
                        MetricsContextTest.this.assertEquals(0L, httpLifecycle.getAndIncrement());
                        return null;
                    }

                    public void requestEnd(Void requestMetric, HttpRequest request, long bytesRead) {
                        MetricsContextTest.this.assertEquals(1L, httpLifecycle.getAndIncrement());
                    }

                    public void responseBegin(Void requestMetric, HttpResponse response) {
                        MetricsContextTest.this.assertEquals(2L, httpLifecycle.getAndIncrement());
                    }

                    public void responseEnd(Void requestMetric, HttpResponse response, long bytesWritten) {
                        MetricsContextTest.this.assertEquals(3L, httpLifecycle.getAndIncrement());
                    }

                    public Void connected(Void socketMetric, Void requestMetric, ServerWebSocket serverWebSocket) {
                        MetricsContextTest.this.assertEquals(4L, httpLifecycle.get());
                        webSocketConnected.set(true);
                        return null;
                    }

                    public void disconnected(Void serverWebSocketMetric) {
                        MetricsContextTest.this.assertEquals(4L, httpLifecycle.get());
                        webSocketDisconnected.set(true);
                    }

                    public Void connected(SocketAddress remoteAddress, String remoteName) {
                        socketConnectedCalled.set(true);
                        return null;
                    }

                    public void disconnected(Void socketMetric, SocketAddress remoteAddress) {
                        socketDisconnectedCalled.set(true);
                    }

                    public void bytesRead(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
                        bytesReadCalled.set(true);
                    }

                    public void bytesWritten(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
                        bytesWrittenCalled.set(true);
                    }

                    public void close() {
                        closeCalled.set(true);
                    }
                };
            }
        };
        CountDownLatch latch = new CountDownLatch(1);
        Vertx vertx = this.vertx(() -> Vertx.builder().with(new VertxOptions().setMetricsOptions(new MetricsOptions().setEnabled(true))).withMetrics(factory).build());
        Context ctx = contextFactory.apply(vertx);
        ctx.runOnContext(v1 -> {
            HttpServer server = vertx.createHttpServer().webSocketHandler(ws -> ws.handler(buf -> ws.write((Object)Buffer.buffer((String)"bye"))));
            server.listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost").onComplete(this.onSuccess(s -> {
                expectedThread.set(Thread.currentThread());
                expectedContext.set(Vertx.currentContext());
                latch.countDown();
            }));
        });
        this.awaitLatch(latch);
        WebSocketClient client = vertx.createWebSocketClient();
        client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(ws -> {
            ws.handler(buf -> {
                ws.closeHandler(v -> vertx.close().onComplete(v4 -> {
                    this.assertTrue(webSocketConnected.get());
                    this.assertTrue(webSocketDisconnected.get());
                    this.assertTrue(bytesReadCalled.get());
                    this.assertTrue(bytesWrittenCalled.get());
                    this.assertTrue(socketConnectedCalled.get());
                    this.assertTrue(socketDisconnectedCalled.get());
                    this.assertTrue(closeCalled.get());
                    this.testComplete();
                }));
                ws.close();
            });
            ws.write((Object)Buffer.buffer((String)"hello"));
        }));
        this.await();
    }

    @Test
    public void testHttpClientRequestEventLoop() throws Exception {
        this.testHttpClientRequest(this.eventLoopContextFactory);
    }

    @Test
    public void testHttpClientRequestWorker() throws Exception {
        this.testHttpClientRequest(this.workerContextFactory);
    }

    private void testHttpClientRequest(Function<Vertx, Context> contextFactory) throws Exception {
        AtomicReference expectedThread = new AtomicReference();
        AtomicReference expectedContext = new AtomicReference();
        final AtomicReference requestBeginCalled = new AtomicReference();
        final AtomicBoolean responseEndCalled = new AtomicBoolean();
        final AtomicBoolean socketConnectedCalled = new AtomicBoolean();
        final AtomicBoolean socketDisconnectedCalled = new AtomicBoolean();
        final AtomicBoolean bytesReadCalled = new AtomicBoolean();
        final AtomicBoolean bytesWrittenCalled = new AtomicBoolean();
        final AtomicBoolean closeCalled = new AtomicBoolean();
        VertxMetricsFactory factory = options -> new VertxMetrics(){

            public HttpClientMetrics createHttpClientMetrics(HttpClientOptions options) {
                return new HttpClientMetrics<Void, Void, Void>(){

                    public ClientMetrics<Void, HttpRequest, HttpResponse> createEndpointMetrics(SocketAddress remoteAddress, int maxPoolSize) {
                        return new ClientMetrics<Void, HttpRequest, HttpResponse>(){

                            public Void requestBegin(String uri, HttpRequest request) {
                                requestBeginCalled.set(uri);
                                return null;
                            }

                            public void responseEnd(Void requestMetric, long bytesRead) {
                                responseEndCalled.set(true);
                            }
                        };
                    }

                    public Void connected(SocketAddress remoteAddress, String remoteName) {
                        socketConnectedCalled.set(true);
                        return null;
                    }

                    public void disconnected(Void socketMetric, SocketAddress remoteAddress) {
                        socketDisconnectedCalled.set(true);
                    }

                    public void bytesRead(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
                        bytesReadCalled.set(true);
                    }

                    public void bytesWritten(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
                        bytesWrittenCalled.set(true);
                    }

                    public void close() {
                        closeCalled.set(true);
                    }
                };
            }
        };
        Vertx vertx = this.vertx(() -> Vertx.builder().with(new VertxOptions().setMetricsOptions(new MetricsOptions().setEnabled(true))).withMetrics(factory).build());
        HttpServer server = vertx.createHttpServer();
        server.requestHandler(req -> req.endHandler(buf -> {
            HttpServerResponse resp = req.response();
            resp.setChunked(true).end(Buffer.buffer((String)"bye"));
            req.connection().close();
        }));
        this.awaitFuture(server.listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost"));
        Context ctx = contextFactory.apply(vertx);
        ctx.runOnContext(v1 -> {
            expectedThread.set(Thread.currentThread());
            expectedContext.set(Vertx.currentContext());
            HttpClientAgent client = vertx.createHttpClient();
            this.assertSame(expectedThread.get(), Thread.currentThread());
            client.request(HttpMethod.PUT, HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/the-uri").compose(arg_0 -> this.lambda$testHttpClientRequest$39((HttpClient)client, vertx, requestBeginCalled, responseEndCalled, socketConnectedCalled, socketDisconnectedCalled, bytesReadCalled, bytesWrittenCalled, closeCalled, arg_0));
        });
        this.await();
    }

    @Test
    public void testHttpClientWebSocketEventLoop() throws Exception {
        this.testHttpClientWebSocket(this.eventLoopContextFactory);
    }

    @Test
    public void testHttpClientWebSocketWorker() throws Exception {
        this.testHttpClientWebSocket(this.workerContextFactory);
    }

    private void testHttpClientWebSocket(Function<Vertx, Context> contextFactory) throws Exception {
        final AtomicBoolean webSocketConnected = new AtomicBoolean();
        final AtomicBoolean webSocketDisconnected = new AtomicBoolean();
        final AtomicBoolean socketConnectedCalled = new AtomicBoolean();
        final AtomicBoolean socketDisconnectedCalled = new AtomicBoolean();
        final AtomicBoolean bytesReadCalled = new AtomicBoolean();
        final AtomicBoolean bytesWrittenCalled = new AtomicBoolean();
        final AtomicBoolean closeCalled = new AtomicBoolean();
        VertxMetricsFactory factory = options -> new VertxMetrics(){

            public HttpClientMetrics createHttpClientMetrics(HttpClientOptions options) {
                return new HttpClientMetrics<Void, Void, Void>(){

                    public ClientMetrics<Void, HttpRequest, HttpResponse> createEndpointMetrics(SocketAddress remoteAddress, int maxPoolSize) {
                        return new ClientMetrics<Void, HttpRequest, HttpResponse>(){};
                    }

                    public Void connected(WebSocket webSocket) {
                        webSocketConnected.set(true);
                        return null;
                    }

                    public void disconnected(Void webSocketMetric) {
                        webSocketDisconnected.set(true);
                    }

                    public Void connected(SocketAddress remoteAddress, String remoteName) {
                        socketConnectedCalled.set(true);
                        return null;
                    }

                    public void disconnected(Void socketMetric, SocketAddress remoteAddress) {
                        socketDisconnectedCalled.set(true);
                    }

                    public void bytesRead(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
                        bytesReadCalled.set(true);
                    }

                    public void bytesWritten(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
                        bytesWrittenCalled.set(true);
                    }

                    public void close() {
                        closeCalled.set(true);
                    }
                };
            }
        };
        Vertx vertx = this.vertx(() -> Vertx.builder().with(new VertxOptions().setMetricsOptions(new MetricsOptions().setEnabled(true))).withMetrics(factory).build());
        HttpServer server = vertx.createHttpServer();
        server.webSocketHandler(ws -> ws.handler(buf -> ws.write((Object)Buffer.buffer((String)"bye"))));
        this.awaitFuture(server.listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost"));
        Context ctx = contextFactory.apply(vertx);
        ctx.runOnContext(v1 -> {
            WebSocketClient client = vertx.createWebSocketClient();
            client.connect(HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(ws -> {
                ws.handler(buf -> {
                    ws.closeHandler(v2 -> TestUtils.executeInVanillaVertxThread(() -> {
                        client.close();
                        vertx.close().onComplete(v3 -> {
                            this.assertTrue(webSocketConnected.get());
                            this.assertTrue(webSocketDisconnected.get());
                            this.assertTrue(socketConnectedCalled.get());
                            this.assertTrue(socketDisconnectedCalled.get());
                            this.assertTrue(bytesReadCalled.get());
                            this.assertTrue(bytesWrittenCalled.get());
                            this.assertTrue(closeCalled.get());
                            this.testComplete();
                        });
                    }));
                    ws.close();
                });
                ws.write((Object)Buffer.buffer((String)"hello"));
            }));
        });
        this.await();
    }

    @Test
    public void testNetServerEventLoop() throws Exception {
        this.testNetServer(this.eventLoopContextFactory);
    }

    @Test
    public void testNetServerWorker() throws Exception {
        this.testNetServer(this.workerContextFactory);
    }

    private void testNetServer(Function<Vertx, Context> contextFactory) throws Exception {
        AtomicReference expectedThread = new AtomicReference();
        AtomicReference expectedContext = new AtomicReference();
        final AtomicBoolean socketConnectedCalled = new AtomicBoolean();
        final AtomicBoolean socketDisconnectedCalled = new AtomicBoolean();
        final AtomicBoolean bytesReadCalled = new AtomicBoolean();
        final AtomicBoolean bytesWrittenCalled = new AtomicBoolean();
        final AtomicBoolean closeCalled = new AtomicBoolean();
        VertxMetricsFactory factory = options -> new VertxMetrics(){

            public TCPMetrics createNetServerMetrics(NetServerOptions options, SocketAddress localAddress) {
                return new TCPMetrics<Void>(){

                    public Void connected(SocketAddress remoteAddress, String remoteName) {
                        socketConnectedCalled.set(true);
                        return null;
                    }

                    public void disconnected(Void socketMetric, SocketAddress remoteAddress) {
                        socketDisconnectedCalled.set(true);
                    }

                    public void bytesRead(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
                        bytesReadCalled.set(true);
                    }

                    public void bytesWritten(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
                        bytesWrittenCalled.set(true);
                    }

                    public void close() {
                        closeCalled.set(true);
                    }
                };
            }
        };
        CountDownLatch latch = new CountDownLatch(1);
        Vertx vertx = this.vertx(() -> Vertx.builder().with(new VertxOptions().setMetricsOptions(new MetricsOptions().setEnabled(true))).withMetrics(factory).build());
        Context ctx = contextFactory.apply(vertx);
        ctx.runOnContext(v1 -> {
            NetServer server = vertx.createNetServer().connectHandler(so -> so.handler(buf -> so.write("bye")));
            server.listen(1234, "localhost").onComplete(this.onSuccess(s -> {
                expectedThread.set(Thread.currentThread());
                expectedContext.set(Vertx.currentContext());
                this.assertSame(expectedThread.get(), Thread.currentThread());
                latch.countDown();
            }));
        });
        this.awaitLatch(latch);
        NetClient client = vertx.createNetClient();
        client.connect(1234, "localhost").onComplete(this.onSuccess(so -> {
            so.handler(buf -> {
                so.closeHandler(v -> TestUtils.executeInVanillaVertxThread(() -> vertx.close().onComplete(v4 -> {
                    this.assertTrue(bytesReadCalled.get());
                    this.assertTrue(bytesWrittenCalled.get());
                    this.assertTrue(socketConnectedCalled.get());
                    this.assertTrue(socketDisconnectedCalled.get());
                    this.assertTrue(closeCalled.get());
                    this.testComplete();
                })));
                so.close();
            });
            so.write("hello");
        }));
        this.await();
    }

    @Test
    public void testNetClientEventLoop() throws Exception {
        this.testNetClient(this.eventLoopContextFactory);
    }

    @Test
    public void testNetClientWorker() throws Exception {
        this.testNetClient(this.workerContextFactory);
    }

    private void testNetClient(Function<Vertx, Context> contextFactory) throws Exception {
        AtomicReference expectedThread = new AtomicReference();
        AtomicReference expectedContext = new AtomicReference();
        final AtomicBoolean socketConnectedCalled = new AtomicBoolean();
        final AtomicBoolean socketDisconnectedCalled = new AtomicBoolean();
        final AtomicBoolean bytesReadCalled = new AtomicBoolean();
        final AtomicBoolean bytesWrittenCalled = new AtomicBoolean();
        final AtomicBoolean closeCalled = new AtomicBoolean();
        VertxMetricsFactory factory = options -> new VertxMetrics(){

            public TCPMetrics createNetClientMetrics(NetClientOptions options) {
                return new TCPMetrics<Void>(){

                    public Void connected(SocketAddress remoteAddress, String remoteName) {
                        socketConnectedCalled.set(true);
                        return null;
                    }

                    public void disconnected(Void socketMetric, SocketAddress remoteAddress) {
                        socketDisconnectedCalled.set(true);
                    }

                    public void bytesRead(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
                        bytesReadCalled.set(true);
                    }

                    public void bytesWritten(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
                        bytesWrittenCalled.set(true);
                    }

                    public void close() {
                        closeCalled.set(true);
                    }
                };
            }
        };
        Vertx vertx = this.vertx(() -> Vertx.builder().with(new VertxOptions().setMetricsOptions(new MetricsOptions().setEnabled(true))).withMetrics(factory).build());
        Context ctx = contextFactory.apply(vertx);
        NetServer server = vertx.createNetServer().connectHandler(so -> so.handler(buf -> so.write("bye")));
        this.awaitFuture(server.listen(1234, "localhost"));
        ctx.runOnContext(v1 -> {
            NetClient client = vertx.createNetClient();
            expectedThread.set(Thread.currentThread());
            expectedContext.set(Vertx.currentContext());
            client.connect(1234, "localhost").onComplete(this.onSuccess(so -> {
                so.handler(buf -> {
                    so.closeHandler(v -> {
                        this.assertTrue(bytesReadCalled.get());
                        this.assertTrue(bytesWrittenCalled.get());
                        this.assertTrue(socketConnectedCalled.get());
                        this.assertTrue(socketDisconnectedCalled.get());
                        TestUtils.executeInVanillaVertxThread(() -> {
                            client.close();
                            vertx.close().onComplete(v4 -> {
                                this.assertTrue(closeCalled.get());
                                this.testComplete();
                            });
                        });
                    });
                    so.close();
                });
                so.write("hello");
            }));
        });
        this.await();
    }

    @Test
    public void testDatagramEventLoop() throws Exception {
        this.testDatagram(this.eventLoopContextFactory);
    }

    @Test
    public void testDatagramWorker() throws Exception {
        this.testDatagram(this.workerContextFactory);
    }

    private void testDatagram(Function<Vertx, Context> contextFactory) throws Exception {
        AtomicReference expectedThread = new AtomicReference();
        AtomicReference expectedContext = new AtomicReference();
        final AtomicBoolean listening = new AtomicBoolean();
        final AtomicBoolean bytesReadCalled = new AtomicBoolean();
        final AtomicBoolean bytesWrittenCalled = new AtomicBoolean();
        final CountDownLatch closeCalled = new CountDownLatch(1);
        VertxMetricsFactory factory = options -> new VertxMetrics(){

            public DatagramSocketMetrics createDatagramSocketMetrics(DatagramSocketOptions options) {
                return new DatagramSocketMetrics(){

                    public void listening(String localName, SocketAddress localAddress) {
                        listening.set(true);
                    }

                    public void bytesRead(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
                        bytesReadCalled.set(true);
                    }

                    public void bytesWritten(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
                        bytesWrittenCalled.set(true);
                    }

                    public void close() {
                        closeCalled.countDown();
                    }
                };
            }
        };
        Vertx vertx = this.vertx(() -> Vertx.builder().with(new VertxOptions().setMetricsOptions(new MetricsOptions().setEnabled(true))).withMetrics(factory).build());
        Context ctx = contextFactory.apply(vertx);
        ctx.runOnContext(v1 -> {
            expectedThread.set(Thread.currentThread());
            expectedContext.set(Vertx.currentContext());
            DatagramSocket socket = vertx.createDatagramSocket();
            socket.listen(1234, "localhost").onComplete(this.onSuccess(v2 -> {
                socket.handler(packet -> {
                    this.assertTrue(listening.get());
                    this.assertTrue(bytesReadCalled.get());
                    this.assertTrue(bytesWrittenCalled.get());
                    TestUtils.executeInVanillaVertxThread(() -> ((DatagramSocket)socket).close());
                });
                socket.send(Buffer.buffer((String)"msg"), 1234, "localhost");
            }));
        });
        this.awaitLatch(closeCalled);
    }

    @Test
    public void testEventBusLifecycle() {
        final AtomicBoolean closeCalled = new AtomicBoolean();
        VertxMetricsFactory factory = options -> new VertxMetrics(){

            public EventBusMetrics createEventBusMetrics() {
                return new EventBusMetrics<Void>(){

                    public void close() {
                        closeCalled.set(true);
                    }
                };
            }
        };
        Vertx vertx = this.vertx(() -> Vertx.builder().with(new VertxOptions().setMetricsOptions(new MetricsOptions().setEnabled(true))).withMetrics(factory).build());
        vertx.eventBus();
        TestUtils.executeInVanillaVertxThread(() -> vertx.close().onComplete(this.onSuccess(v -> {
            this.assertTrue(closeCalled.get());
            this.testComplete();
        })));
        this.await();
    }

    @Test
    public void testMessageHandler() {
        this.testMessageHandler((vertx, handler) -> handler.handle(null));
    }

    @Test
    public void testMessageHandlerEventLoop() {
        this.testMessageHandler((vertx, handler) -> this.eventLoopContextFactory.apply((Vertx)vertx).runOnContext(handler));
    }

    private void testMessageHandler(BiConsumer<Vertx, Handler<Void>> runOnContext) {
        final AtomicReference scheduleThread = new AtomicReference();
        final AtomicReference deliveredThread = new AtomicReference();
        final AtomicBoolean registeredCalled = new AtomicBoolean();
        final AtomicBoolean unregisteredCalled = new AtomicBoolean();
        VertxMetricsFactory factory = options -> new VertxMetrics(){

            public EventBusMetrics createEventBusMetrics() {
                return new EventBusMetrics<Void>(){

                    public Void handlerRegistered(String address) {
                        registeredCalled.set(true);
                        return null;
                    }

                    public void handlerUnregistered(Void handler) {
                        unregisteredCalled.set(true);
                    }

                    public void scheduleMessage(Void handler, boolean local) {
                        scheduleThread.set(Thread.currentThread());
                    }

                    public void messageDelivered(Void handler, boolean local) {
                        deliveredThread.set(Thread.currentThread());
                    }
                };
            }
        };
        Vertx vertx = this.vertx(() -> Vertx.builder().with(new VertxOptions().setMetricsOptions(new MetricsOptions().setEnabled(true))).withMetrics(factory).build());
        EventBus eb = vertx.eventBus();
        Thread t = new Thread(() -> eb.send("the_address", (Object)"the_msg"));
        runOnContext.accept(vertx, (Handler<Void>)((Handler)v -> {
            MessageConsumer consumer = eb.consumer("the_address");
            consumer.handler(msg -> {
                Thread consumerThread = Thread.currentThread();
                TestUtils.executeInVanillaVertxThread(() -> vertx.getOrCreateContext().runOnContext(v2 -> consumer.unregister().onComplete(this.onSuccess(v3 -> {
                    this.assertTrue(registeredCalled.get());
                    this.assertSame(t, scheduleThread.get());
                    this.assertSame(consumerThread, deliveredThread.get());
                    MetricsContextTest.assertWaitUntil(() -> unregisteredCalled.get());
                    this.testComplete();
                }))));
            }).completion().onComplete(this.onSuccess(v2 -> t.start()));
        }));
        this.await();
    }

    private /* synthetic */ Future lambda$testHttpClientRequest$39(HttpClient client, Vertx vertx, AtomicReference requestBeginCalled, AtomicBoolean responseEndCalled, AtomicBoolean socketConnectedCalled, AtomicBoolean socketDisconnectedCalled, AtomicBoolean bytesReadCalled, AtomicBoolean bytesWrittenCalled, AtomicBoolean closeCalled, HttpClientRequest req) {
        return req.send(Buffer.buffer((String)"hello")).onComplete(this.onSuccess(resp -> TestUtils.executeInVanillaVertxThread(() -> {
            client.close();
            Future close = vertx.close();
            close.onComplete(v2 -> {
                this.assertEquals("/the-uri", requestBeginCalled.get());
                this.assertTrue(responseEndCalled.get());
                this.assertTrue(socketConnectedCalled.get());
                this.assertTrue(socketDisconnectedCalled.get());
                this.assertTrue(bytesReadCalled.get());
                this.assertTrue(bytesWrittenCalled.get());
                this.assertTrue(closeCalled.get());
                this.testComplete();
            });
        })));
    }

    private /* synthetic */ void lambda$testHttpServerRequestPipelining$21(HttpClient client, Void v) {
        for (int i = 0; i < 2; ++i) {
            client.request(HttpMethod.GET, HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/" + (i + 1)).onComplete(this.onSuccess(req -> req.send().compose(HttpClientResponse::body).onComplete(this.onSuccess(body -> this.complete()))));
        }
    }
}

