/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.metrics;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import io.vertx.tests.metrics.SimpleVertxMetricsFactory;
import java.util.Random;
import org.junit.Test;

public class MetricsOptionsTest
extends VertxTestBase {
    @Test
    public void testOptions() {
        MetricsOptions options = new MetricsOptions();
        this.assertFalse(options.isEnabled());
        this.assertEquals(options, options.setEnabled(true));
        this.assertTrue(options.isEnabled());
    }

    @Test
    public void testCopyOptions() {
        MetricsOptions options = new MetricsOptions();
        Random rand = new Random();
        boolean metricsEnabled = rand.nextBoolean();
        options.setEnabled(metricsEnabled);
        options = new MetricsOptions(options);
        this.assertEquals(metricsEnabled, options.isEnabled());
    }

    @Test
    public void testJsonOptions() {
        MetricsOptions options = new MetricsOptions(new JsonObject());
        this.assertFalse(options.isEnabled());
        Random rand = new Random();
        boolean metricsEnabled = rand.nextBoolean();
        String customValue = TestUtils.randomAlphaString(10);
        options = new MetricsOptions(new JsonObject().put("enabled", (Object)metricsEnabled).put("custom", (Object)customValue));
        this.assertEquals(metricsEnabled, options.isEnabled());
        this.assertEquals(metricsEnabled, options.toJson().getBoolean("enabled"));
        this.assertEquals(customValue, options.toJson().getString("custom"));
    }

    @Test
    public void testMetricsEnabledWithoutConfig() {
        this.vertx.close();
        this.vertx = Vertx.vertx((VertxOptions)new VertxOptions().setMetricsOptions(new MetricsOptions().setEnabled(true)));
        VertxMetrics metrics = ((VertxInternal)this.vertx).metrics();
        this.assertNull(metrics);
    }

    @Test
    public void testSetMetricsInstance() {
        VertxMetrics metrics = new VertxMetrics(){};
        this.vertx.close();
        this.vertx = Vertx.builder().with(new VertxOptions().setMetricsOptions(new MetricsOptions().setEnabled(true))).withMetrics(new SimpleVertxMetricsFactory<1>(metrics)).build();
        this.assertSame(metrics, ((VertxInternal)this.vertx).metrics());
    }
}

