/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.net;

import io.netty.util.NetUtil;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.SocketAddress;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.junit.Test;

public class SocketAddressTest
extends VertxTestBase {
    @Test
    public void testInetSocketAddressFromUnresolvedAddress() {
        SocketAddress addr = SocketAddress.inetSocketAddress((InetSocketAddress)InetSocketAddress.createUnresolved("localhost", 8080));
        this.assertEquals("localhost", addr.host());
        this.assertEquals("localhost", addr.hostName());
        this.assertEquals(null, addr.hostAddress());
        this.assertEquals(8080L, addr.port());
        this.assertFalse(addr.isDomainSocket());
        this.assertTrue(addr.isInetSocket());
    }

    @Test
    public void testInetSocketAddressFromResolvedAddress() {
        InetSocketAddress expected = new InetSocketAddress("localhost", 8080);
        SocketAddress addr = SocketAddress.inetSocketAddress((InetSocketAddress)expected);
        this.assertEquals("localhost", addr.host());
        this.assertEquals("localhost", addr.hostName());
        this.assertEquals(expected.getAddress().getHostAddress(), addr.hostAddress());
        this.assertEquals(8080L, addr.port());
        this.assertFalse(addr.isDomainSocket());
        this.assertTrue(addr.isInetSocket());
    }

    @Test
    public void testInetSocketAddressIpV4Address() throws Exception {
        InetAddress ip = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        SocketAddress addr = SocketAddress.inetSocketAddress((InetSocketAddress)new InetSocketAddress(ip, 8080));
        this.assertEquals("127.0.0.1", addr.host());
        this.assertNull(addr.hostName());
        this.assertEquals(ip.getHostAddress(), addr.hostAddress());
        this.assertEquals(8080L, addr.port());
        this.assertFalse(addr.isDomainSocket());
        this.assertTrue(addr.isInetSocket());
    }

    @Test
    public void testInetSocketAddressIpV6Address() {
        Inet6Address ip = NetUtil.getByName((CharSequence)"::1");
        SocketAddress addr = SocketAddress.inetSocketAddress((InetSocketAddress)new InetSocketAddress(ip, 8080));
        this.assertEquals("0:0:0:0:0:0:0:1", addr.host());
        this.assertNull(addr.hostName());
        this.assertEquals(((InetAddress)ip).getHostAddress(), addr.hostAddress());
        this.assertEquals(8080L, addr.port());
        this.assertFalse(addr.isDomainSocket());
        this.assertTrue(addr.isInetSocket());
    }

    @Test
    public void testInetSocketAddressFromHostName() {
        SocketAddress addr = SocketAddress.inetSocketAddress((int)8080, (String)"localhost");
        this.assertEquals("localhost", addr.host());
        this.assertEquals("localhost", addr.hostName());
        this.assertNull(addr.hostAddress());
        this.assertEquals(8080L, addr.port());
        this.assertFalse(addr.isDomainSocket());
        this.assertTrue(addr.isInetSocket());
    }

    @Test
    public void testInetSocketAddressFromIpV4AddressHost() {
        SocketAddress addr = SocketAddress.inetSocketAddress((int)8080, (String)"127.0.0.1");
        this.assertEquals("127.0.0.1", addr.host());
        this.assertEquals(null, addr.hostName());
        this.assertEquals("127.0.0.1", addr.hostAddress());
        this.assertEquals(8080L, addr.port());
        this.assertFalse(addr.isDomainSocket());
        this.assertTrue(addr.isInetSocket());
    }

    @Test
    public void testInetSocketAddressFromIpV6AddressHost() {
        SocketAddress addr = SocketAddress.inetSocketAddress((int)8080, (String)"::1");
        this.assertEquals("::1", addr.host());
        this.assertEquals(null, addr.hostName());
        this.assertEquals("0:0:0:0:0:0:0:1", addr.hostAddress());
        this.assertEquals(8080L, addr.port());
        this.assertFalse(addr.isDomainSocket());
        this.assertTrue(addr.isInetSocket());
    }

    @Test
    public void testDomainSocketAddress() {
        SocketAddress addr = SocketAddress.domainSocketAddress((String)"/foo");
        this.assertEquals("/foo", addr.path());
        this.assertNull(addr.host());
        this.assertNull(addr.hostAddress());
        this.assertNull(addr.hostName());
        this.assertEquals(-1L, addr.port());
        this.assertTrue(addr.isDomainSocket());
        this.assertFalse(addr.isInetSocket());
    }

    @Test
    public void testSocketAddress() throws Exception {
        TestUtils.assertNullPointerException(() -> SocketAddress.domainSocketAddress(null));
        TestUtils.assertNullPointerException(() -> SocketAddress.inetSocketAddress((int)0, null));
        TestUtils.assertIllegalArgumentException(() -> SocketAddress.inetSocketAddress((int)0, (String)""));
        TestUtils.assertIllegalArgumentException(() -> SocketAddress.inetSocketAddress((int)-1, (String)"someHost"));
        TestUtils.assertIllegalArgumentException(() -> SocketAddress.inetSocketAddress((int)65536, (String)"someHost"));
    }

    @Test
    public void testFromJson() {
        this.assertNull(SocketAddress.fromJson((JsonObject)new JsonObject()));
        this.assertNull(SocketAddress.fromJson((JsonObject)new JsonObject().put("host", (Object)"the-host")));
        SocketAddress hostAndPort = SocketAddress.fromJson((JsonObject)new JsonObject().put("host", (Object)"the-host").put("port", (Object)4));
        this.assertTrue(hostAndPort.isInetSocket());
        this.assertEquals("the-host", hostAndPort.host());
        this.assertEquals(4L, hostAndPort.port());
        hostAndPort = SocketAddress.fromJson((JsonObject)new JsonObject().put("path", (Object)"/path"));
        this.assertTrue(hostAndPort.isDomainSocket());
        this.assertEquals("/path", hostAndPort.path());
        hostAndPort = SocketAddress.fromJson((JsonObject)new JsonObject().put("host", (Object)"the-host").put("port", (Object)-4));
        this.assertEquals("the-host", hostAndPort.host());
        this.assertEquals(-4L, hostAndPort.port());
    }

    @Test
    public void testToJson() {
        this.assertEquals(new JsonObject().put("host", (Object)"the-host").put("port", (Object)4), SocketAddress.inetSocketAddress((int)4, (String)"the-host").toJson());
        this.assertEquals(new JsonObject().put("path", (Object)"/path"), SocketAddress.domainSocketAddress((String)"/path").toJson());
        this.assertEquals(new JsonObject().put("host", (Object)"the-host").put("port", (Object)-4), SocketAddress.sharedRandomPort((int)4, (String)"the-host").toJson());
    }
}

