/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.pool;

import io.vertx.core.AsyncResult;
import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.ConnectionPoolTooBusyException;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.pool.ConnectResult;
import io.vertx.core.internal.pool.ConnectionPool;
import io.vertx.core.internal.pool.Lease;
import io.vertx.core.internal.pool.PoolConnection;
import io.vertx.core.internal.pool.PoolConnector;
import io.vertx.core.internal.pool.PoolWaiter;
import io.vertx.test.core.VertxTestBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Test;

public class ConnectionPoolTest
extends VertxTestBase {
    VertxInternal vertx;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.vertx = (VertxInternal)((VertxTestBase)this).vertx;
    }

    @Test
    public void testConnect() {
        ContextInternal context = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{10}, (int)10);
        Connection expected = new Connection();
        pool.acquire(context, 0, this.onSuccess2(lease -> {
            this.assertSame(expected, lease.get());
            this.assertEquals(0L, pool.requests());
            this.testComplete();
        }));
        this.assertEquals(1L, pool.requests());
        ConnectionRequest request = mgr.assertRequest();
        this.assertSame(context.nettyEventLoop(), request.context.nettyEventLoop());
        request.connect(expected, 0);
        this.await();
    }

    @Test
    public void testAcquireRecycledConnection() throws Exception {
        ContextInternal context = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{10});
        Connection expected = new Connection();
        CountDownLatch latch = new CountDownLatch(1);
        pool.acquire(context, 0, this.onSuccess2(lease -> {
            lease.recycle();
            latch.countDown();
        }));
        ConnectionRequest request = mgr.assertRequest();
        this.assertSame(context.nettyEventLoop(), request.context.nettyEventLoop());
        request.connect(expected, 0);
        this.awaitLatch(latch);
        pool.acquire(context, 0, this.onSuccess2(lease -> {
            this.assertSame(expected, lease.get());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testRecycleRemovedConnection() throws Exception {
        ContextInternal context = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{10}, (int)10);
        Connection expected1 = new Connection();
        Future fut = Future.future(p -> pool.acquire(context, 0, (Completable)p));
        ConnectionRequest request1 = mgr.assertRequest();
        request1.connect(expected1, 0);
        CountDownLatch latch = new CountDownLatch(1);
        fut.onComplete(this.onSuccess(lease -> {
            request1.listener.onRemove();
            lease.recycle();
            latch.countDown();
        }));
        this.awaitLatch(latch);
        Connection expected2 = new Connection();
        pool.acquire(context, 0, this.onSuccess2(lease -> {
            this.assertSame(expected2, lease.get());
            this.testComplete();
        }));
        ConnectionRequest request2 = mgr.assertRequest();
        request2.connect(expected2, 0);
        this.await();
    }

    @Test
    public void testConcurrency() throws Exception {
        ContextInternal context = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{10}, (int)10);
        Connection expected = new Connection();
        CountDownLatch latch = new CountDownLatch(1);
        pool.acquire(context, 0, this.onSuccess2(conn -> latch.countDown()));
        ConnectionRequest request = mgr.assertRequest();
        request.concurrency(2).connect(expected, 0);
        this.awaitLatch(latch);
        pool.acquire(context, 0, this.onSuccess2(lease -> {
            this.assertSame(lease.get(), expected);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testIncreaseConcurrency() throws Exception {
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1});
        ContextInternal ctx = this.vertx.createEventLoopContext();
        Connection conn1 = new Connection();
        CountDownLatch l1 = new CountDownLatch(1);
        pool.acquire(ctx, 0, this.onSuccess2(lease -> l1.countDown()));
        CountDownLatch l2 = new CountDownLatch(1);
        pool.acquire(ctx, 0, this.onSuccess2(lease -> l2.countDown()));
        CountDownLatch l3 = new CountDownLatch(1);
        pool.acquire(ctx, 0, this.onSuccess2(lease -> l3.countDown()));
        ConnectionRequest request = mgr.assertRequest();
        request.connect(conn1, 0);
        this.awaitLatch(l1);
        this.assertEquals(1L, l2.getCount());
        request.listener.onConcurrencyChange(2L);
        this.awaitLatch(l2);
        request.listener.onConcurrencyChange(3L);
        this.awaitLatch(l3);
    }

    @Test
    public void testSatisfyPendingWaitersWithExtraConcurrency() throws Exception {
        ContextInternal context = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1}, (int)2);
        Connection expected = new Connection();
        AtomicInteger seq = new AtomicInteger();
        pool.acquire(context, 0, this.onSuccess2(lease -> {
            this.assertSame(lease.get(), expected);
            this.assertEquals(0L, seq.getAndIncrement());
        }));
        pool.acquire(context, 0, this.onSuccess2(lease -> {
            this.assertSame(lease.get(), expected);
            this.assertEquals(1L, seq.getAndIncrement());
            this.testComplete();
        }));
        ConnectionRequest request = mgr.assertRequest();
        request.concurrency(2).connect(expected, 0);
        this.await();
    }

    @Test
    public void testEmptyConcurrency() {
        ContextInternal context = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1}, (int)2);
        Connection expected = new Connection();
        AtomicInteger seq = new AtomicInteger();
        pool.acquire(context, 0, this.onSuccess2(lease -> {
            this.assertSame(lease.get(), expected);
            this.assertEquals(1L, seq.getAndIncrement());
        }));
        pool.acquire(context, 0, this.onSuccess2(lease -> {
            this.assertSame(lease.get(), expected);
            this.assertEquals(2L, seq.getAndIncrement());
            this.testComplete();
        }));
        ConnectionRequest request = mgr.assertRequest();
        request.concurrency(0).connect(expected, 0);
        this.assertEquals(0L, seq.getAndIncrement());
        request.concurrency(2);
        this.await();
    }

    @Test
    public void testDecreaseConcurrency() throws Exception {
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1});
        ContextInternal ctx = this.vertx.createEventLoopContext();
        Connection conn1 = new Connection();
        CountDownLatch l1 = new CountDownLatch(2);
        CountDownLatch l2 = new CountDownLatch(1);
        Lease[] leases = new Lease[3];
        pool.acquire(ctx, 0, this.onSuccess2(lease -> {
            leases[0] = lease;
            l1.countDown();
        }));
        pool.acquire(ctx, 0, this.onSuccess2(lease -> {
            leases[1] = lease;
            l1.countDown();
        }));
        pool.acquire(ctx, 0, this.onSuccess2(lease -> {
            leases[2] = lease;
            l2.countDown();
        }));
        ConnectionRequest request = mgr.assertRequest();
        request.concurrency(2).connect(conn1, 0);
        this.awaitLatch(l1);
        this.assertEquals(1L, l2.getCount());
        request.listener.onConcurrencyChange(1L);
        ctx.runOnContext(v -> {
            leases[0].recycle();
            this.assertEquals(1L, l2.getCount());
            leases[1].recycle();
            this.assertEquals(0L, l2.getCount());
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testWaiter() throws Exception {
        ContextInternal ctx1 = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1});
        Connection expected = new Connection();
        CompletableFuture latch = new CompletableFuture();
        pool.acquire(ctx1, 0, this.onSuccess2(latch::complete));
        ConnectionRequest request = mgr.assertRequest();
        request.connect(expected, 0);
        Lease lease1 = (Lease)latch.get(10L, TimeUnit.SECONDS);
        AtomicBoolean recycled = new AtomicBoolean();
        ContextInternal ctx2 = this.vertx.createEventLoopContext();
        pool.acquire(ctx2, 0, this.onSuccess2(lease2 -> {
            this.assertSame(ctx1.nettyEventLoop(), ((ContextInternal)Vertx.currentContext()).nettyEventLoop());
            this.assertTrue(recycled.get());
            this.testComplete();
        }));
        this.assertEquals(1L, pool.waiters());
        recycled.set(true);
        lease1.recycle();
        this.await();
    }

    @Test
    public void testRemoveSingleConnection() throws Exception {
        ContextInternal ctx1 = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1}, (int)1);
        Connection conn = new Connection();
        CompletableFuture latch = new CompletableFuture();
        pool.acquire(ctx1, 0, this.onSuccess2(latch::complete));
        ConnectionRequest request = mgr.assertRequest();
        request.connect(conn, 0);
        latch.get(10L, TimeUnit.SECONDS);
        request.listener.onRemove();
        this.assertEquals(0L, pool.size());
        this.assertEquals(0L, pool.capacity());
    }

    @Test
    public void testRemoveFirstConnection() throws Exception {
        ContextInternal ctx = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{2}, (int)2);
        Connection conn1 = new Connection();
        CompletableFuture latch1 = new CompletableFuture();
        pool.acquire(ctx, 0, this.onSuccess2(latch1::complete));
        Connection conn2 = new Connection();
        CompletableFuture latch2 = new CompletableFuture();
        pool.acquire(ctx, 0, this.onSuccess2(latch2::complete));
        ConnectionRequest request1 = mgr.assertRequest();
        request1.connect(conn1, 0);
        ConnectionRequest request2 = mgr.assertRequest();
        request2.connect(conn2, 0);
        latch1.get(10L, TimeUnit.SECONDS);
        request1.listener.onRemove();
        this.assertEquals(1L, pool.size());
        this.assertEquals(1L, pool.capacity());
    }

    @Test
    public void testRemoveSingleConnectionWithWaiter() throws Exception {
        ContextInternal ctx1 = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1});
        Connection connection1 = new Connection();
        CompletableFuture latch = new CompletableFuture();
        pool.acquire(ctx1, 0, this.onSuccess2(latch::complete));
        ConnectionRequest request1 = mgr.assertRequest();
        request1.connect(connection1, 0);
        Lease lease1 = (Lease)latch.get(10L, TimeUnit.SECONDS);
        this.assertSame(connection1, lease1.get());
        AtomicBoolean evicted = new AtomicBoolean();
        Connection conn2 = new Connection();
        ContextInternal ctx2 = this.vertx.createEventLoopContext();
        pool.acquire(ctx2, 0, this.onSuccess2(lease2 -> {
            this.assertSame(ctx2.nettyEventLoop(), ((ContextInternal)Vertx.currentContext()).nettyEventLoop());
            this.assertTrue(evicted.get());
            this.assertSame(conn2, lease2.get());
            this.testComplete();
        }));
        this.assertEquals(1L, pool.waiters());
        evicted.set(true);
        request1.listener.onRemove();
        ConnectionRequest request2 = mgr.assertRequest();
        request2.connect(conn2, 0);
        this.await();
    }

    @Test
    public void testConnectFailureWithPendingWaiter() throws Exception {
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1, 2}, (int)2);
        Throwable failure = new Throwable();
        Connection expected = new Connection();
        CountDownLatch latch = new CountDownLatch(1);
        ContextInternal ctx1 = this.vertx.createEventLoopContext();
        pool.acquire(ctx1, 0, this.onFailure2(cause -> {
            this.assertSame(failure, cause);
            this.assertEquals(1L, pool.requests());
            latch.countDown();
        }));
        ContextInternal ctx2 = this.vertx.createEventLoopContext();
        pool.acquire(ctx2, 1, this.onSuccess2(lease -> {
            this.assertSame(expected, lease.get());
            this.testComplete();
        }));
        ConnectionRequest request1 = mgr.assertRequest();
        this.assertEquals(2L, pool.capacity());
        request1.fail(failure);
        this.awaitLatch(latch);
        this.assertEquals(1L, pool.capacity());
        ConnectionRequest request2 = mgr.assertRequest();
        request2.connect(expected, 0);
        this.await();
    }

    @Test
    public void testExpireFirst() throws Exception {
        this.assertEquals(Arrays.asList(0), this.testExpire(1, 10, 0));
        this.assertEquals(Arrays.asList(0), this.testExpire(2, 10, 0));
        this.assertEquals(Arrays.asList(0), this.testExpire(3, 10, 0));
    }

    @Test
    public void testExpireLast() throws Exception {
        this.assertEquals(Arrays.asList(0), this.testExpire(1, 10, 0));
        this.assertEquals(Arrays.asList(1), this.testExpire(2, 10, 1));
        this.assertEquals(Arrays.asList(2), this.testExpire(3, 10, 2));
    }

    @Test
    public void testExpireMiddle() throws Exception {
        this.assertEquals(Arrays.asList(1), this.testExpire(3, 10, 1));
    }

    @Test
    public void testExpireSome() throws Exception {
        this.assertEquals(Arrays.asList(2, 1), this.testExpire(3, 10, 1, 2));
        this.assertEquals(Arrays.asList(2, 1, 0), this.testExpire(3, 10, 0, 1, 2));
        this.assertEquals(Arrays.asList(1, 0), this.testExpire(3, 10, 0, 1));
    }

    private List<Integer> testExpire(int num, int max, int ... recycled) throws Exception {
        int i;
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{max}, (int)max);
        CountDownLatch latch = new CountDownLatch(num);
        ArrayList leases = new ArrayList();
        ContextInternal ctx = this.vertx.createEventLoopContext();
        for (i = 0; i < num; ++i) {
            Connection expected = new Connection();
            pool.acquire(ctx, 0, this.onSuccess2(lease -> {
                this.assertSame(expected, lease.get());
                leases.add(lease);
                latch.countDown();
            }));
            mgr.assertRequest().connect(expected, 0);
        }
        this.awaitLatch(latch);
        for (i = 0; i < recycled.length; ++i) {
            ((Lease)leases.get(recycled[i])).recycle();
        }
        CompletableFuture cf = new CompletableFuture();
        pool.evict(c -> true, (res, err) -> {
            if (err == null) {
                ArrayList lst = new ArrayList();
                List all = leases.stream().map(Lease::get).collect(Collectors.toList());
                res.forEach(c -> lst.add(all.indexOf(c)));
                cf.complete(lst);
            } else {
                cf.completeExceptionally(err);
            }
        });
        return (List)cf.get();
    }

    @Test
    public void testRemoveEvicted() throws Exception {
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1}, (int)1);
        ContextInternal ctx = this.vertx.createEventLoopContext();
        CountDownLatch latch1 = new CountDownLatch(1);
        pool.acquire(ctx, 0, this.onSuccess2(lease -> {
            lease.recycle();
            latch1.countDown();
        }));
        ConnectionRequest request = mgr.assertRequest();
        Connection conn = new Connection();
        request.connect(conn, 0);
        this.awaitLatch(latch1);
        CountDownLatch latch2 = new CountDownLatch(1);
        pool.evict(c -> c == conn, this.onSuccess2(l -> latch2.countDown()));
        this.awaitLatch(latch2);
        request.listener.onRemove();
        this.assertEquals(0L, pool.size());
    }

    @Test
    public void testSynchronousEviction() throws Exception {
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1}, (int)1);
        ContextInternal ctx = this.vertx.createEventLoopContext();
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        CountDownLatch latch3 = new CountDownLatch(1);
        pool.acquire(ctx, 0, this.onSuccess2(lease -> {
            lease.recycle();
            latch1.countDown();
        }));
        ConnectionRequest request = mgr.assertRequest();
        Connection conn1 = new Connection();
        request.connect(conn1, 0);
        this.awaitLatch(latch1);
        Connection conn2 = new Connection();
        pool.evict(candidate -> {
            this.assertSame(candidate, conn1);
            pool.acquire(ctx, 0, this.onSuccess2(lease -> {
                Connection c2 = (Connection)lease.get();
                this.assertSame(conn2, c2);
                latch3.countDown();
            }));
            return true;
        }, this.onSuccess2(list -> latch2.countDown()));
        this.awaitLatch(latch2);
        request = mgr.assertRequest();
        request.connect(conn2, 0);
        this.awaitLatch(latch3);
    }

    @Test
    public void testConnectionInProgressShouldNotBeEvicted() {
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1}, (int)5);
        ContextInternal ctx = this.vertx.createEventLoopContext();
        pool.acquire(ctx, 0, (res, err) -> {});
        mgr.assertRequest();
        pool.evict(c -> {
            this.fail();
            return false;
        }, this.onSuccess2(v -> this.testComplete()));
        this.await();
    }

    @Test
    public void testRecycleRemoveConnection() throws Exception {
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1}, (int)1);
        Connection expected = new Connection();
        CompletableFuture latch = new CompletableFuture();
        ContextInternal ctx1 = this.vertx.createEventLoopContext();
        pool.acquire(ctx1, 0, this.onSuccess2(latch::complete));
        ConnectionRequest request = mgr.assertRequest();
        request.connect(expected, 0);
        Lease lease = (Lease)latch.get();
        request.listener.onRemove();
        this.assertEquals(0L, pool.size());
        lease.recycle();
        this.assertEquals(0L, pool.size());
    }

    @Test
    public void testRecycleMultiple() throws Exception {
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1}, (int)1);
        Connection expected = new Connection();
        CompletableFuture latch = new CompletableFuture();
        ContextInternal ctx1 = this.vertx.createEventLoopContext();
        pool.acquire(ctx1, 0, this.onSuccess2(latch::complete));
        ConnectionRequest request = mgr.assertRequest();
        request.connect(expected, 0);
        Lease lease = (Lease)latch.get();
        lease.recycle();
        try {
            lease.recycle();
            this.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testMaxWaiters() {
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1}, (int)5);
        ContextInternal ctx = this.vertx.createEventLoopContext();
        for (int i = 0; i < 5; ++i) {
            pool.acquire(ctx, 0, (res, err) -> this.fail());
        }
        pool.acquire(ctx, 0, this.onFailure2(err -> {
            this.assertTrue(err instanceof ConnectionPoolTooBusyException);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testHeterogeneousSizes() throws Exception {
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{5, 2});
        ContextInternal ctx = this.vertx.createEventLoopContext();
        CountDownLatch latch = new CountDownLatch(5);
        for (int i = 0; i < 5; ++i) {
            pool.acquire(ctx, 0, this.onSuccess2(lease -> latch.countDown()));
            Connection conn = new Connection();
            mgr.assertRequest().connect(conn, 0);
        }
        this.awaitLatch(latch);
        this.assertEquals(10L, pool.capacity());
        pool.acquire(ctx, 1, this.onSuccess2(lease -> {}));
        this.assertEquals(1L, pool.waiters());
    }

    @Test
    public void testClose() throws Exception {
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{2}, (int)2);
        ContextInternal ctx = this.vertx.createEventLoopContext();
        Connection conn1 = new Connection();
        pool.acquire(ctx, 0, this.onSuccess2(lease -> {}));
        this.waitFor(3);
        pool.acquire(ctx, 0, this.onFailure2(err -> this.complete()));
        pool.acquire(ctx, 0, this.onFailure2(err -> this.complete()));
        mgr.assertRequest().connect(conn1, 0);
        mgr.assertRequest();
        pool.close(this.onSuccess2(lst -> {
            this.assertEquals(2L, lst.size());
            this.assertEquals(0L, pool.size());
            this.complete();
        }));
        this.await();
    }

    @Test
    public void testCloseTwice() throws Exception {
        AtomicBoolean isReentrant = new AtomicBoolean();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{2}, (int)2);
        CountDownLatch latch = new CountDownLatch(1);
        pool.close(this.onSuccess2(lst -> {
            AtomicBoolean inCallback = new AtomicBoolean();
            pool.close(this.onFailure2(err -> {
                isReentrant.set(inCallback.get());
                latch.countDown();
            }));
        }));
        this.awaitLatch(latch);
        this.assertFalse(isReentrant.get());
    }

    @Test
    public void testUseAfterClose() throws Exception {
        this.waitFor(3);
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1});
        ContextInternal ctx = this.vertx.createEventLoopContext();
        final CompletableFuture waiterFut = new CompletableFuture();
        pool.acquire(ctx, (PoolWaiter.Listener)new PoolWaiter.Listener<Connection>(){

            public void onConnect(PoolWaiter<Connection> waiter) {
                waiterFut.complete(waiter);
            }
        }, 0, (res, err) -> {});
        PoolWaiter waiter = (PoolWaiter)waiterFut.get(20L, TimeUnit.SECONDS);
        ConnectionRequest request = mgr.assertRequest();
        CountDownLatch latch = new CountDownLatch(1);
        pool.close(this.onSuccess2(lst -> latch.countDown()));
        this.awaitLatch(latch);
        pool.evict(c -> true, this.onFailure2(err -> this.complete()));
        pool.acquire(ctx, 0, this.onFailure2(err -> this.complete()));
        pool.cancel(waiter, this.onFailure2(err -> this.complete()));
        request.connect(new Connection(), 0);
        this.await();
    }

    @Test
    public void testAcquireClosedConnection() throws Exception {
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1});
        ContextInternal context = this.vertx.createEventLoopContext();
        pool.acquire(context, 0, this.onSuccess2(Lease::recycle));
        Connection expected = new Connection();
        ConnectionRequest request = mgr.assertRequest();
        request.connect(expected, 0);
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        context.runOnContext(v -> pool.evict(conn -> {
            latch1.countDown();
            try {
                latch2.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return false;
        }, (res, err) -> {}));
        this.awaitLatch(latch1);
        AtomicBoolean closed = new AtomicBoolean();
        pool.acquire(context, 0, this.onSuccess2(lease -> {
            this.assertNotNull(lease.get());
            this.assertTrue(closed.get());
            this.testComplete();
        }));
        request.listener.onRemove();
        closed.set(true);
        latch2.countDown();
        this.await();
    }

    @Test
    public void testConnectSuccessAfterClose() {
        this.testConnectResultAfterClose(true);
    }

    @Test
    public void testConnectFailureAfterClose() {
        this.testConnectResultAfterClose(false);
    }

    private void testConnectResultAfterClose(boolean success) {
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1});
        ContextInternal ctx = this.vertx.createEventLoopContext();
        AtomicInteger acquired = new AtomicInteger();
        pool.acquire(ctx, 0, (res, err) -> this.assertEquals(0L, acquired.getAndIncrement()));
        this.assertEquals(1L, pool.size());
        ConnectionRequest request = mgr.assertRequest();
        Future closeResult = Future.future(p -> pool.close((Completable)p));
        Throwable cause = new Throwable();
        Connection expected = new Connection();
        if (success) {
            request.connect(expected, 0);
        } else {
            request.fail(cause);
        }
        this.assertTrue(closeResult.isComplete());
        List connections = (List)closeResult.result();
        this.assertEquals(1L, connections.size());
        this.assertEquals(success, ((Future)connections.get(0)).succeeded());
        this.assertEquals(0L, pool.size());
        if (success) {
            this.assertEquals(expected, ((Future)connections.get(0)).result());
        } else {
            this.assertEquals(cause, ((Future)connections.get(0)).cause());
        }
        ConnectionPoolTest.waitUntil(() -> acquired.get() == 1);
    }

    @Test
    public void testCancelQueuedWaiters() throws Exception {
        this.waitFor(1);
        ContextInternal context = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1});
        final CompletableFuture w = new CompletableFuture();
        pool.acquire(context, 0, this.onSuccess2(lease -> {}));
        pool.acquire(context, (PoolWaiter.Listener)new PoolWaiter.Listener<Connection>(){

            public void onEnqueue(PoolWaiter<Connection> waiter) {
                w.complete(waiter);
            }
        }, 0, (res, err) -> this.fail());
        PoolWaiter waiter = (PoolWaiter)w.get(10L, TimeUnit.SECONDS);
        pool.cancel(waiter, this.onSuccess2(removed1 -> {
            this.assertTrue((boolean)removed1);
            this.assertEquals(0L, pool.waiters());
            pool.cancel(waiter, this.onSuccess2(removed2 -> {
                this.assertFalse((boolean)removed2);
                this.assertEquals(0L, pool.waiters());
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testCancelWaiterBeforeConnectionSuccess() throws Exception {
        this.testCancelWaiterBeforeConnection(true, 0);
    }

    @Test
    public void testCancelWaiterBeforeConnectionSuccessWithExtraWaiters() throws Exception {
        this.testCancelWaiterBeforeConnection(true, 2);
    }

    @Test
    public void testCancelWaiterBeforeConnectionFailure() throws Exception {
        this.testCancelWaiterBeforeConnection(false, 0);
    }

    public void testCancelWaiterBeforeConnection(boolean success, int extra) throws Exception {
        if (!success && extra > 0) {
            throw new IllegalArgumentException();
        }
        this.waitFor(1);
        ContextInternal context = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1}, (int)(1 + extra));
        final CompletableFuture waiterLatch = new CompletableFuture();
        pool.acquire(context, (PoolWaiter.Listener)new PoolWaiter.Listener<Connection>(){

            public void onConnect(PoolWaiter<Connection> waiter) {
                waiterLatch.complete(waiter);
            }
        }, 0, (res, err) -> this.fail());
        waiterLatch.get(10L, TimeUnit.SECONDS);
        final CountDownLatch enqueuedLatch = new CountDownLatch(extra);
        CountDownLatch recycledLatch = new CountDownLatch(extra);
        for (int i = 0; i < extra; ++i) {
            pool.acquire(context, (PoolWaiter.Listener)new PoolWaiter.Listener<Connection>(){

                public void onEnqueue(PoolWaiter<Connection> waiter) {
                    enqueuedLatch.countDown();
                }
            }, 0, this.onSuccess2(conn -> {
                conn.recycle();
                recycledLatch.countDown();
            }));
        }
        this.awaitLatch(enqueuedLatch);
        ConnectionRequest request = mgr.assertRequest();
        CountDownLatch latch = new CountDownLatch(1);
        pool.cancel((PoolWaiter)waiterLatch.get(10L, TimeUnit.SECONDS), this.onSuccess2(removed -> {
            this.assertTrue((boolean)removed);
            latch.countDown();
        }));
        this.awaitLatch(latch);
        if (success) {
            request.connect(new Connection(), 0);
        } else {
            request.fail(new Throwable());
        }
        this.awaitLatch(recycledLatch);
        CountDownLatch doneLatch = new CountDownLatch(extra);
        for (int i = 0; i < extra; ++i) {
            pool.acquire(context, 0, this.onSuccess2(conn -> {
                doneLatch.countDown();
                conn.recycle();
            }));
        }
        this.awaitLatch(doneLatch);
    }

    @Test
    public void testCancelWaiterAfterConnectionSuccess() throws Exception {
        this.testCancelWaiterAfterConnectionSuccess(true);
    }

    @Test
    public void testCancelWaiterAfterConnectionFailure() throws Exception {
        this.testCancelWaiterAfterConnectionSuccess(false);
    }

    public void testCancelWaiterAfterConnectionSuccess(boolean success) throws Exception {
        this.waitFor(1);
        ContextInternal context = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{1}, (int)1);
        final CompletableFuture w = new CompletableFuture();
        CountDownLatch latch = new CountDownLatch(1);
        pool.acquire(context, (PoolWaiter.Listener)new PoolWaiter.Listener<Connection>(){

            public void onConnect(PoolWaiter<Connection> waiter) {
                w.complete(waiter);
            }
        }, 0, (res, err) -> latch.countDown());
        w.get(10L, TimeUnit.SECONDS);
        ConnectionRequest request = mgr.assertRequest();
        if (success) {
            request.connect(new Connection(), 0);
        } else {
            request.fail(new Throwable());
        }
        this.awaitLatch(latch);
        pool.cancel((PoolWaiter)w.get(10L, TimeUnit.SECONDS), this.onSuccess2(removed -> {
            this.assertFalse((boolean)removed);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testConnectionSelector() throws Exception {
        this.waitFor(1);
        ContextInternal context = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{2});
        CountDownLatch latch1 = new CountDownLatch(1);
        pool.acquire(context, 0, this.onSuccess2(lease -> {
            lease.recycle();
            latch1.countDown();
        }));
        Connection conn1 = new Connection();
        mgr.assertRequest().connect(conn1, 0);
        this.awaitLatch(latch1);
        pool.connectionSelector((waiter, list) -> {
            this.assertEquals(1L, list.size());
            PoolConnection pooled = (PoolConnection)list.get(0);
            this.assertEquals(1L, pooled.available());
            this.assertEquals(1L, pooled.concurrency());
            this.assertSame(conn1, pooled.get());
            this.assertSame(context.nettyEventLoop(), pooled.context().nettyEventLoop());
            this.assertSame(context, waiter.context());
            return pooled;
        });
        pool.acquire(context, 0, this.onSuccess2(lease -> this.testComplete()));
        this.await();
    }

    @Test
    public void testDefaultSelector() throws Exception {
        ContextImpl context1 = (ContextImpl)this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{10}, (int)10);
        CountDownLatch latch1 = new CountDownLatch(1);
        pool.acquire((ContextInternal)context1, 0, this.onSuccess2(lease -> {
            lease.recycle();
            latch1.countDown();
        }));
        Connection expected = new Connection();
        this.assertEquals(1L, pool.requests());
        ConnectionRequest request = mgr.assertRequest();
        request.connect(expected, 0);
        this.awaitLatch(latch1);
        CountDownLatch latch2 = new CountDownLatch(1);
        pool.acquire((ContextInternal)context1, 0, this.onSuccess2(lease -> {
            this.assertEquals(expected, lease.get());
            lease.recycle();
            latch2.countDown();
        }));
        this.awaitLatch(latch2);
        CountDownLatch latch3 = new CountDownLatch(1);
        ContextInternal context2 = this.vertx.contextBuilder().withEventLoop(context1.nettyEventLoop()).withWorkerPool(context1.workerPool()).withClassLoader(context1.classLoader()).build();
        pool.acquire(context2, 0, this.onSuccess2(lease -> {
            this.assertEquals(expected, lease.get());
            lease.recycle();
            latch3.countDown();
        }));
        this.awaitLatch(latch3);
    }

    @Test
    public void testDefaultContextProviderUnwrap() {
        ContextInternal context = this.vertx.createEventLoopContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{10}, (int)10);
        pool.acquire(context.duplicate(), 0, this.onSuccess2(lease -> {}));
        this.assertEquals(1L, pool.requests());
        ConnectionRequest request = mgr.assertRequest();
        this.assertSame(context.nettyEventLoop(), request.context.nettyEventLoop());
    }

    @Test
    public void testDefaultContextProviderReusesSameEventLoop() {
        ContextInternal context = this.vertx.createWorkerContext();
        ConnectionManager mgr = new ConnectionManager();
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)mgr, (int[])new int[]{10}, (int)10);
        pool.acquire(context.duplicate(), 0, this.onSuccess2(lease -> {}));
        this.assertEquals(1L, pool.requests());
        ConnectionRequest request = mgr.assertRequest();
        this.assertSame(context.nettyEventLoop(), request.context.nettyEventLoop());
    }

    @Test
    public void testPostTasksTrampoline() throws Exception {
        final int numAcquires = 5;
        final AtomicReference<ConnectionPool> ref = new AtomicReference<ConnectionPool>();
        final ContextInternal ctx = this.vertx.createEventLoopContext();
        final List res = Collections.synchronizedList(new LinkedList());
        final AtomicInteger seq = new AtomicInteger();
        final CountDownLatch latch = new CountDownLatch(1 + numAcquires);
        final int[] count = new int[1];
        ConnectionPool pool = ConnectionPool.pool((PoolConnector)new PoolConnector<Connection>(){
            int reentrancy = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Future<ConnectResult<Connection>> connect(ContextInternal context, PoolConnector.Listener listener) {
                ConnectionPoolTest.this.assertEquals(0L, this.reentrancy++);
                try {
                    int n = count[0];
                    count[0] = n + 1;
                    int val = n;
                    if (val == 0) {
                        for (int i = 0; i < numAcquires; ++i) {
                            int num = seq.getAndIncrement();
                            ((ConnectionPool)ref.get()).acquire(ctx, 0, ConnectionPoolTest.this.onFailure2(err -> {
                                res.add(num);
                                latch.countDown();
                            }));
                        }
                        ConnectionPoolTest.this.assertEquals(1L, count[0]);
                    }
                    Future future = Future.failedFuture((String)"failure");
                    return future;
                }
                finally {
                    --this.reentrancy;
                }
            }

            public boolean isValid(Connection connection) {
                return true;
            }
        }, (int[])new int[]{1}, (int)(1 + numAcquires));
        ref.set(pool);
        ctx.runOnContext(v -> {
            int num = seq.getAndIncrement();
            pool.acquire(ctx, 0, this.onFailure2(err -> {
                res.add(num);
                latch.countDown();
            }));
        });
        this.awaitLatch(latch);
        this.assertEquals(1 + numAcquires, count[0]);
        List expected = IntStream.range(0, numAcquires + 1).boxed().collect(Collectors.toList());
        this.assertEquals(expected, res);
    }

    @Test
    public void testConcurrentPostTasksTrampoline() throws Exception {
        final AtomicReference<ConnectionPool> ref1 = new AtomicReference<ConnectionPool>();
        final AtomicReference<ConnectionPool> ref2 = new AtomicReference<ConnectionPool>();
        final ContextInternal ctx = this.vertx.createEventLoopContext();
        final List res = Collections.synchronizedList(new LinkedList());
        final CountDownLatch latch = new CountDownLatch(4);
        ConnectionPool pool1 = ConnectionPool.pool((PoolConnector)new PoolConnector<Connection>(){
            int count = 0;
            int reentrancy = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Future<ConnectResult<Connection>> connect(ContextInternal context, PoolConnector.Listener listener) {
                ConnectionPoolTest.this.assertEquals(0L, this.reentrancy++);
                try {
                    int val = this.count++;
                    if (val == 0) {
                        ((ConnectionPool)ref1.get()).acquire(ctx, 0, ConnectionPoolTest.this.onFailure2(err -> {
                            res.add(1);
                            latch.countDown();
                        }));
                        ((ConnectionPool)ref2.get()).acquire(ctx, 0, ConnectionPoolTest.this.onFailure2(err -> {
                            res.add(2);
                            latch.countDown();
                        }));
                    }
                    Future future = Future.failedFuture((String)"failure");
                    return future;
                }
                finally {
                    --this.reentrancy;
                }
            }

            public boolean isValid(Connection connection) {
                return true;
            }
        }, (int[])new int[]{1}, (int)2);
        ConnectionPool pool2 = ConnectionPool.pool((PoolConnector)new PoolConnector<Connection>(){
            int count = 0;
            int reentrancy = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Future<ConnectResult<Connection>> connect(ContextInternal context, PoolConnector.Listener listener) {
                ConnectionPoolTest.this.assertEquals(0L, this.reentrancy++);
                try {
                    int val = this.count++;
                    if (val == 0) {
                        ((ConnectionPool)ref2.get()).acquire(ctx, 0, ConnectionPoolTest.this.onFailure2(err -> {
                            res.add(3);
                            latch.countDown();
                        }));
                        ((ConnectionPool)ref1.get()).acquire(ctx, 0, ConnectionPoolTest.this.onFailure2(err -> {
                            res.add(4);
                            latch.countDown();
                        }));
                    }
                    Future future = Future.failedFuture((String)"failure");
                    return future;
                }
                finally {
                    --this.reentrancy;
                }
            }

            public boolean isValid(Connection connection) {
                return true;
            }
        }, (int[])new int[]{1}, (int)2);
        ref1.set(pool1);
        ref2.set(pool2);
        pool1.acquire(ctx, 0, this.onFailure2(err -> res.add(0)));
        this.awaitLatch(latch);
    }

    class ConnectionManager
    implements PoolConnector<Connection> {
        private final Queue<ConnectionRequest> requests = new ArrayBlockingQueue<ConnectionRequest>(100);

        ConnectionManager() {
        }

        public Future<ConnectResult<Connection>> connect(ContextInternal context, PoolConnector.Listener listener) {
            Promise promise = Promise.promise();
            this.requests.add(new ConnectionRequest(context, listener, (Promise<ConnectResult<Connection>>)promise));
            return promise.future();
        }

        public boolean isValid(Connection connection) {
            return true;
        }

        ConnectionRequest assertRequest() {
            ConnectionRequest request = this.requests.poll();
            ConnectionPoolTest.this.assertNotNull(request);
            return request;
        }
    }

    static class ConnectionRequest {
        final ContextInternal context;
        final PoolConnector.Listener listener;
        final Promise<ConnectResult<Connection>> completion;
        private int concurrency;
        private Connection connection;

        ConnectionRequest(ContextInternal context, PoolConnector.Listener listener, Promise<ConnectResult<Connection>> completion) {
            this.context = context;
            this.listener = listener;
            this.completion = completion;
            this.concurrency = 1;
        }

        void connect(Connection connection, int type) {
            if (this.connection != null) {
                throw new IllegalStateException();
            }
            this.connection = connection;
            this.completion.handle((AsyncResult)Future.succeededFuture((Object)new ConnectResult((Object)connection, (long)this.concurrency, (long)type)));
        }

        ConnectionRequest concurrency(int value) {
            if (value < this.concurrency) {
                if (this.connection != null) {
                    throw new IllegalStateException();
                }
                this.concurrency = value;
            } else {
                this.concurrency = value;
                this.listener.onConcurrencyChange((long)this.concurrency);
            }
            return this;
        }

        public void fail(Throwable cause) {
            this.completion.handle((AsyncResult)Future.failedFuture((Throwable)cause));
        }
    }

    static class Connection {
    }
}

