/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.pool;

import io.netty.util.internal.InternalThreadLocalMap;
import io.vertx.core.internal.pool.CombinerExecutor;
import io.vertx.core.internal.pool.Executor;
import io.vertx.core.internal.pool.Task;
import io.vertx.test.core.AsyncTestBase;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assume;
import org.junit.Test;

public class SynchronizationTest
extends AsyncTestBase {
    private static Long iterationsForOneMilli;

    private static long iterationsForOneMilli() {
        Long val = iterationsForOneMilli;
        if (val == null) {
            iterationsForOneMilli = val = Long.valueOf(Utils.calibrateBlackhole());
        }
        return val;
    }

    private static void burnCPU(long cpu) {
        long target_delay = Utils.ONE_MICRO_IN_NANO * cpu;
        long num_iters = Math.round((double)target_delay * 1.0 * (double)SynchronizationTest.iterationsForOneMilli() / (double)Utils.ONE_MILLI_IN_NANO);
        Utils.blackholeCpu(num_iters);
    }

    @Test
    public void testActionReentrancy() throws Exception {
        AtomicBoolean isReentrant1 = new AtomicBoolean();
        AtomicBoolean isReentrant2 = new AtomicBoolean();
        CombinerExecutor sync = new CombinerExecutor(new Object());
        CountDownLatch latch = new CountDownLatch(2);
        sync.submit(arg_0 -> this.lambda$testActionReentrancy$1((Executor)sync, isReentrant1, latch, isReentrant2, arg_0));
        this.awaitLatch(latch);
        this.assertFalse(isReentrant1.get());
        this.assertFalse(isReentrant2.get());
    }

    @Test
    public void testActionReentrancy2() throws Exception {
        LinkedList log = new LinkedList();
        CombinerExecutor combiner1 = new CombinerExecutor(new Object());
        CombinerExecutor combiner2 = new CombinerExecutor(new Object());
        int[] reentrancy = new int[2];
        combiner1.submit(arg_0 -> this.lambda$testActionReentrancy2$11(reentrancy, (Executor)combiner1, log, (Executor)combiner2, arg_0));
        this.assertEquals(0L, reentrancy[0]);
        this.assertEquals(0L, reentrancy[1]);
        this.assertEquals(Arrays.asList(1, 3, 0, 2), log);
    }

    static Task taskOf(final Runnable runnable) {
        return new Task(){

            public void run() {
                runnable.run();
            }
        };
    }

    @Test
    public void testFoo() throws Exception {
        Assume.assumeFalse((boolean)io.vertx.core.impl.Utils.isWindows());
        int numThreads = 8;
        int numIter = 100000;
        CombinerExecutor sync = new CombinerExecutor(new Object());
        Executor.Action action = s -> {
            SynchronizationTest.burnCPU(10L);
            return null;
        };
        Thread[] threads = new Thread[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            threads[i] = new Thread(() -> SynchronizationTest.lambda$testFoo$13(numIter, (Executor)sync, action));
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
    }

    @Test
    public void testOrdering() throws Exception {
        CombinerExecutor sync = new CombinerExecutor(new Object());
        AtomicInteger order = new AtomicInteger();
        sync.submit(arg_0 -> this.lambda$testOrdering$16((Executor)sync, order, arg_0));
        this.assertEquals(3L, order.get());
    }

    @Test
    public void testFastThreadLocalStability() {
        CombinerExecutor executor = new CombinerExecutor(null);
        int expected = InternalThreadLocalMap.lastVariableIndex();
        final AtomicInteger counter = new AtomicInteger();
        for (int i = 0; i < 1000; ++i) {
            executor = new CombinerExecutor(null);
            executor.submit(state -> new Task(){

                public void run() {
                    counter.incrementAndGet();
                }
            });
            this.assertEquals(i + 1, counter.get());
        }
        this.assertEquals(expected, InternalThreadLocalMap.lastVariableIndex());
    }

    private /* synthetic */ Task lambda$testOrdering$16(Executor sync, final AtomicInteger order, Object s) {
        sync.submit(s_ -> new Task(){

            public void run() {
                order.compareAndSet(1, 2);
            }
        });
        sync.submit(s_ -> new Task(){

            public void run() {
                order.compareAndSet(2, 3);
            }
        });
        return new Task(){

            public void run() {
                order.compareAndSet(0, 1);
            }
        };
    }

    private static /* synthetic */ void lambda$testFoo$13(int numIter, Executor sync, Executor.Action action) {
        for (int j = 0; j < numIter; ++j) {
            sync.submit(action);
        }
    }

    private /* synthetic */ Task lambda$testActionReentrancy2$11(int[] reentrancy, Executor combiner1, List log, Executor combiner2, Object state1) {
        return SynchronizationTest.taskOf(() -> {
            int n = reentrancy[0];
            reentrancy[0] = n + 1;
            this.assertEquals(0L, n);
            combiner1.submit(state2 -> SynchronizationTest.taskOf(() -> {
                int n = reentrancy[0];
                reentrancy[0] = n + 1;
                this.assertEquals(0L, n);
                log.add(0);
                reentrancy[0] = reentrancy[0] - 1;
            }));
            combiner2.submit(state2 -> SynchronizationTest.taskOf(() -> {
                int n = reentrancy[1];
                reentrancy[1] = n + 1;
                this.assertEquals(0L, n);
                log.add(1);
                combiner1.submit(state3 -> SynchronizationTest.taskOf(() -> {
                    int n = reentrancy[0];
                    reentrancy[0] = n + 1;
                    this.assertEquals(0L, n);
                    log.add(2);
                    reentrancy[0] = reentrancy[0] - 1;
                }));
                combiner2.submit(state3 -> SynchronizationTest.taskOf(() -> {
                    int n = reentrancy[1];
                    reentrancy[1] = n + 1;
                    this.assertEquals(0L, n);
                    log.add(3);
                    reentrancy[1] = reentrancy[1] - 1;
                }));
                reentrancy[1] = reentrancy[1] - 1;
            }));
            reentrancy[0] = reentrancy[0] - 1;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Task lambda$testActionReentrancy$1(Executor sync, AtomicBoolean isReentrant1, final CountDownLatch latch, final AtomicBoolean isReentrant2, Object state1) {
        final AtomicBoolean inCallback = new AtomicBoolean();
        inCallback.set(true);
        try {
            sync.submit(state2 -> {
                isReentrant1.set(inCallback.get());
                latch.countDown();
                return new Task(){

                    public void run() {
                        isReentrant2.set(inCallback.get());
                        latch.countDown();
                    }
                };
            });
        }
        finally {
            inCallback.set(false);
        }
        return null;
    }

    public static class Utils {
        public static long res = 0L;
        public static long ONE_MILLI_IN_NANO = 1000000L;
        public static long ONE_MICRO_IN_NANO = 1000L;

        public static void blackholeCpu(long iterations) {
            long result = 0L;
            int i = 0;
            while ((long)i < iterations) {
                int next = ThreadLocalRandom.current().nextInt() % 1019 / 17;
                result ^= Math.round(Math.pow(next, 3.0)) % 251L;
                ++i;
            }
            res += result;
        }

        public static long calibrateBlackhole() {
            ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
            for (int i = 0; i < 50000; ++i) {
                Utils.blackholeCpu(100L);
            }
            long[] iters = new long[]{1000L, 5000L, 10000L, 20000L, 50000L, 100000L};
            long timing = 0L;
            int i = -1;
            while (timing < ONE_MILLI_IN_NANO && ++i < iters.length) {
                long start_cpu = threadBean.getCurrentThreadCpuTime();
                Utils.blackholeCpu(iters[i]);
                timing = threadBean.getCurrentThreadCpuTime() - start_cpu;
            }
            return Math.round(Math.ceil((double)ONE_MILLI_IN_NANO * 1.0 / (double)timing * (double)iters[i]));
        }
    }
}

