/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.resource;

import io.vertx.core.Future;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.resource.ManagedResource;
import io.vertx.core.internal.resource.ResourceManager;
import io.vertx.test.core.Repeat;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.junit.Test;

public class ResourceManagerTest
extends VertxTestBase {
    private static final Object TEST_KEY = new Object();

    public Future<Resource> getResource(ContextInternal ctx, ResourceManager<Object, TestResource> mgr, Function<Object, TestResource> provider, Object key) {
        return mgr.withResourceAsync(key, provider, (endpoint, created) -> endpoint.acquire(ctx, 0L));
    }

    @Test
    public void testAcquireSuccess() {
        this.testAcquire(true);
    }

    @Test
    public void testAcquireFailure() {
        this.testAcquire(false);
    }

    private void testAcquire(final boolean success) {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        final Resource result = new Resource();
        final Throwable failure = new Throwable();
        Function<Object, TestResource> provider = key -> new TestResource(){

            @Override
            public Future<Resource> acquire(ContextInternal ctx1, long timeout) {
                this.incRefCount();
                if (success) {
                    return ctx1.succeededFuture((Object)result);
                }
                return ctx1.failedFuture(failure);
            }
        };
        ResourceManager mgr = new ResourceManager();
        this.getResource(ctx, (ResourceManager<Object, TestResource>)mgr, provider, TEST_KEY).onComplete(ar -> {
            if (ar.succeeded()) {
                this.assertTrue(success);
                this.assertSame(result, ar.result());
            } else {
                this.assertFalse(success);
                this.assertSame(failure, ar.cause());
            }
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testDisposeAfterResourceClose() {
        this.testDispose(true);
    }

    @Test
    public void testDisposeAfterCallback() {
        this.testDispose(false);
    }

    private void testDispose(final boolean closeConnectionAfterCallback) {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        final Resource expected = new Resource();
        final AtomicReference postCheck = new AtomicReference();
        final boolean[] disposed = new boolean[1];
        Function<Object, TestResource> provider = key -> new TestResource(){

            @Override
            public Future<Resource> acquire(ContextInternal ctx1, long timeout) {
                this.incRefCount();
                if (closeConnectionAfterCallback) {
                    postCheck.set(() -> {
                        ResourceManagerTest.this.assertFalse(disposed[0]);
                        this.decRefCount();
                        ResourceManagerTest.this.assertTrue(disposed[0]);
                    });
                    return ctx1.succeededFuture((Object)expected);
                }
                this.decRefCount();
                ResourceManagerTest.this.assertFalse(disposed[0]);
                postCheck.set(() -> ResourceManagerTest.this.assertTrue(disposed[0]));
                return ctx1.succeededFuture((Object)expected);
            }

            protected void cleanup() {
                disposed[0] = true;
            }
        };
        ResourceManager mgr = new ResourceManager();
        this.getResource(ctx, (ResourceManager<Object, TestResource>)mgr, provider, TEST_KEY).onComplete(this.onSuccess(conn -> {
            this.assertEquals(expected, conn);
            ((Runnable)postCheck.get()).run();
        }));
        ResourceManagerTest.waitUntil(() -> disposed[0]);
    }

    @Test
    public void testCloseManager() throws Exception {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        final Resource expected = new Resource();
        final boolean[] disposed = new boolean[1];
        Function<Object, TestResource> provider = key -> new TestResource(){

            @Override
            public Future<Resource> acquire(ContextInternal ctx1, long timeout) {
                this.incRefCount();
                return ctx1.succeededFuture((Object)expected);
            }

            protected void cleanup() {
                disposed[0] = true;
            }

            protected void handleClose() {
                this.decRefCount();
            }
        };
        ResourceManager mgr = new ResourceManager();
        CountDownLatch latch = new CountDownLatch(1);
        this.getResource(ctx, (ResourceManager<Object, TestResource>)mgr, provider, TEST_KEY).onComplete(this.onSuccess(conn -> {
            this.assertEquals(expected, conn);
            latch.countDown();
        }));
        this.awaitLatch(latch);
        this.assertFalse(disposed[0]);
        mgr.close();
        this.assertTrue(disposed[0]);
    }

    @Test
    public void testCloseManagerImmediately() {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        Resource expected = new Resource();
        boolean[] disposed = new boolean[1];
        final AtomicReference adder = new AtomicReference();
        Function<Object, TestResource> provider = key -> new TestResource(){

            @Override
            public Future<Resource> acquire(ContextInternal ctx1, long timeout) {
                adder.set(() -> this.incRefCount());
                return ctx1.promise();
            }
        };
        ResourceManager mgr = new ResourceManager();
        this.getResource(ctx, (ResourceManager<Object, TestResource>)mgr, provider, TEST_KEY).onComplete(this.onSuccess(conn -> {}));
        ResourceManagerTest.waitUntil(() -> adder.get() != null);
        mgr.close();
        ((Runnable)adder.get()).run();
    }

    @Repeat(times=20)
    @Test
    public void testConcurrentDispose() throws Exception {
        int i;
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        ConcurrentLinkedQueue<AtomicBoolean> disposals = new ConcurrentLinkedQueue<AtomicBoolean>();
        Function<Object, TestResource> provider = key -> {
            final AtomicBoolean disposed = new AtomicBoolean();
            disposals.add(disposed);
            return new TestResource(){

                @Override
                public Future<Resource> acquire(ContextInternal ctx1, long timeout) {
                    if (disposed.get()) {
                        ResourceManagerTest.this.fail();
                        return ctx1.promise();
                    }
                    Resource conn = new Resource();
                    this.incRefCount();
                    this.decRefCount();
                    return ctx1.succeededFuture((Object)conn);
                }

                protected void cleanup() {
                    disposed.set(true);
                }
            };
        };
        ResourceManager mgr = new ResourceManager();
        int num = 100000;
        int concurrency = 4;
        CountDownLatch[] latches = new CountDownLatch[concurrency];
        for (i = 0; i < concurrency; ++i) {
            CountDownLatch cc;
            latches[i] = cc = new CountDownLatch(num);
            new Thread(() -> {
                for (int j = 0; j < num; ++j) {
                    this.getResource(ctx, (ResourceManager<Object, TestResource>)mgr, provider, TEST_KEY).onComplete(this.onSuccess(conn -> cc.countDown()));
                }
            }).start();
        }
        for (i = 0; i < concurrency; ++i) {
            this.awaitLatch(latches[i]);
        }
        disposals.forEach(disposed -> ResourceManagerTest.waitUntil(disposed::get));
    }

    static class Resource {
        Resource() {
        }
    }

    static abstract class TestResource
    extends ManagedResource {
        TestResource() {
        }

        public abstract Future<Resource> acquire(ContextInternal var1, long var2);
    }
}

