/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.shareddata;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.shareddata.ClusterSerializable;
import io.vertx.core.shareddata.SharedData;
import io.vertx.test.core.AssertExpectations;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;

public abstract class AsyncMapTest
extends VertxTestBase {
    protected abstract Vertx getVertx();

    @Test
    public void testMapPutGetByte() {
        this.testMapPutGet((byte)1, (byte)2);
    }

    @Test
    public void testMapPutGetShort() {
        this.testMapPutGet((short)1, (short)2);
    }

    @Test
    public void testMapPutGetInt() {
        this.testMapPutGet(1, 2);
    }

    @Test
    public void testMapPutGetLong() {
        this.testMapPutGet(1L, 2L);
    }

    @Test
    public void testMapPutGetChar() {
        this.testMapPutGet(Character.valueOf('X'), Character.valueOf('Y'));
    }

    @Test
    public void testMapPutGetFloat() {
        this.testMapPutGet(Float.valueOf(1.2f), Float.valueOf(2.2f));
    }

    @Test
    public void testMapPutGetBuffer() {
        this.testMapPutGet(TestUtils.randomBuffer(4), TestUtils.randomBuffer(12));
    }

    @Test
    public void testMapPutGetDouble() {
        this.testMapPutGet(1.2, 2.2);
    }

    @Test
    public void testMapPutGetBoolean() {
        this.testMapPutGet("foo", true);
    }

    @Test
    public void testMapPutGetString() {
        this.testMapPutGet("foo", "bar");
    }

    @Test
    public void testMapPutGetJsonObject() {
        this.testMapPutGet(new JsonObject().put("foo", (Object)"bar"), new JsonObject().put("uihwqduh", (Object)"qiwiojw"));
    }

    @Test
    public void testMapPutGetJsonArray() {
        this.testMapPutGet(new JsonArray().add((Object)"foo").add((Object)2), new JsonArray().add((Object)"uihwqduh").add((Object)false));
    }

    @Test
    public void testMapPutGetSerializableObject() {
        this.testMapPutGet(new SomeSerializableObject("bar"), new SomeSerializableObject("bar"));
    }

    @Test
    public void testMapPutGetClusterSerializableObject() {
        this.testMapPutGet(new SomeClusterSerializableObject("bar"), new SomeClusterSerializableObject("bar"));
    }

    @Test
    public void testMapPutTtl() {
        SharedData sharedData = this.getVertx().sharedData();
        sharedData.getAsyncMap("foo").compose(map -> map.put((Object)"pipo", (Object)"molo", 10L)).compose(v -> this.assertWaitUntilMapContains(sharedData, "foo", "pipo", 15L, Objects::isNull)).onComplete(this.onSuccess(v -> this.testComplete()));
        this.await();
    }

    private Future<Void> assertWaitUntilMapContains(SharedData sharedData, String name, String key, long delay, Function<String, Boolean> checks) {
        return sharedData.getAsyncMap(name).compose(map -> this.assertWaitUntil((AsyncMap<String, String>)map, key, delay, checks));
    }

    private Future<Void> assertWaitUntil(AsyncMap<String, String> map, String key, long delay, Function<String, Boolean> checks) {
        return Future.future(p -> this.assertWaitUntil(map, key, delay, checks, (Promise<Void>)p));
    }

    private void assertWaitUntil(AsyncMap<String, String> map, String key, long delay, Function<String, Boolean> checks, Promise<Void> promise) {
        this.vertx.setTimer(delay, l -> map.get((Object)key).onComplete(this.onSuccess(value -> {
            if (((Boolean)checks.apply((String)value)).booleanValue()) {
                promise.complete();
            } else {
                this.assertWaitUntil(map, key, delay, checks, promise);
            }
        })));
    }

    @Test
    public void testMapPutTtlThenPut() {
        SharedData sharedData = this.getVertx().sharedData();
        sharedData.getAsyncMap("foo").compose(map -> map.put((Object)"pipo", (Object)"molo", 10L).compose(v -> map.put((Object)"pipo", (Object)"mili"))).compose(v -> this.assertWaitUntilMapContains(sharedData, "foo", "pipo", 20L, s -> "mili".equals(s))).onComplete(this.onSuccess(v -> this.testComplete()));
        this.await();
    }

    @Test
    public void testMapPutThenPutTtl() {
        SharedData sharedData = this.getVertx().sharedData();
        sharedData.getAsyncMap("foo").compose(map -> map.put((Object)"pipo", (Object)"molo").compose(v -> map.put((Object)"pipo", (Object)"mili", 10L))).compose(v -> this.assertWaitUntilMapContains(sharedData, "foo", "pipo", 15L, Objects::isNull)).onComplete(this.onSuccess(v -> this.testComplete()));
        this.await();
    }

    @Test
    public void testMapPutIfAbsentGetByte() {
        this.testMapPutIfAbsentGet((byte)1, (byte)2);
    }

    @Test
    public void testMapPutIfAbsentGetShort() {
        this.testMapPutIfAbsentGet((short)1, (short)2);
    }

    @Test
    public void testMapPutIfAbsentGetInt() {
        this.testMapPutIfAbsentGet(1, 2);
    }

    @Test
    public void testMapPutIfAbsentGetLong() {
        this.testMapPutIfAbsentGet(1L, 2L);
    }

    @Test
    public void testMapPutIfAbsentGetChar() {
        this.testMapPutIfAbsentGet(Character.valueOf('X'), Character.valueOf('Y'));
    }

    @Test
    public void testMapPutIfAbsentGetFloat() {
        this.testMapPutIfAbsentGet(Float.valueOf(1.2f), Float.valueOf(2.2f));
    }

    @Test
    public void testMapPutIfAbsentGetBuffer() {
        this.testMapPutIfAbsentGet(TestUtils.randomBuffer(4), TestUtils.randomBuffer(12));
    }

    @Test
    public void testMapPutIfAbsentGetDouble() {
        this.testMapPutIfAbsentGet(1.2, 2.2);
    }

    @Test
    public void testMapPutIfAbsentGetBoolean() {
        this.testMapPutIfAbsentGet("foo", true);
    }

    @Test
    public void testMapPutIfAbsentGetString() {
        this.testMapPutIfAbsentGet("foo", "bar");
    }

    @Test
    public void testMapPutIfAbsentGetJsonObject() {
        this.testMapPutIfAbsentGet(new JsonObject().put("foo", (Object)"bar"), new JsonObject().put("uihwqduh", (Object)"qiwiojw"));
    }

    @Test
    public void testMapPutIfAbsentGetJsonArray() {
        this.testMapPutIfAbsentGet(new JsonArray().add((Object)"foo").add((Object)2), new JsonArray().add((Object)"uihwqduh").add((Object)false));
    }

    @Test
    public void testMapPutIfAbsentGetSerializableObject() {
        this.testMapPutIfAbsentGet(new SomeSerializableObject("bar"), new SomeSerializableObject("bar"));
    }

    @Test
    public void testMapPutIfAbsentGetClusterSerializableObject() {
        this.testMapPutIfAbsentGet(new SomeClusterSerializableObject("bar"), new SomeClusterSerializableObject("bar"));
    }

    @Test
    public void testMapPutIfAbsentTtl() {
        SharedData sharedData = this.getVertx().sharedData();
        sharedData.getAsyncMap("foo").compose(map -> map.putIfAbsent((Object)"pipo", (Object)"molo", 10L).expecting(AssertExpectations.that(Assert::assertNull))).compose(v -> this.assertWaitUntilMapContains(sharedData, "foo", "pipo", 15L, Objects::isNull)).onComplete(this.onSuccess(v -> this.testComplete()));
        this.await();
    }

    @Test
    public void testMapPutIfAbsentTtlWithExistingNotGettingDeleted() {
        SharedData sharedData = this.getVertx().sharedData();
        sharedData.getAsyncMap("foo").compose(map -> map.put((Object)"pipo", (Object)"molo").compose(v -> map.putIfAbsent((Object)"pipo", (Object)"mili", 10L).expecting(AssertExpectations.that(vd -> this.assertEquals("molo", vd))))).compose(v -> this.assertWaitUntilMapContains(sharedData, "foo", "pipo", 15L, "molo"::equals)).onComplete(this.onSuccess(v -> this.testComplete()));
        this.await();
    }

    @Test
    public void testMapRemoveByte() {
        this.testMapRemove((byte)1, (byte)2);
    }

    @Test
    public void testMapRemoveShort() {
        this.testMapRemove((short)1, (short)2);
    }

    @Test
    public void testMapRemoveInt() {
        this.testMapRemove(1, 2);
    }

    @Test
    public void testMapRemoveLong() {
        this.testMapRemove(1L, 2L);
    }

    @Test
    public void testMapRemoveChar() {
        this.testMapRemove(Character.valueOf('X'), Character.valueOf('Y'));
    }

    @Test
    public void testMapRemoveFloat() {
        this.testMapRemove(Float.valueOf(1.2f), Float.valueOf(2.2f));
    }

    @Test
    public void testMapRemoveBuffer() {
        this.testMapRemove(TestUtils.randomBuffer(4), TestUtils.randomBuffer(12));
    }

    @Test
    public void testMapRemoveDouble() {
        this.testMapRemove(1.2, 2.2);
    }

    @Test
    public void testMapRemoveBoolean() {
        this.testMapRemove("foo", true);
    }

    @Test
    public void testMapRemoveString() {
        this.testMapRemove("foo", "bar");
    }

    @Test
    public void testMapRemoveJsonObject() {
        this.testMapRemove(new JsonObject().put("foo", (Object)"bar"), new JsonObject().put("uihwqduh", (Object)"qiwiojw"));
    }

    @Test
    public void testMapRemoveJsonArray() {
        this.testMapRemove(new JsonArray().add((Object)"foo").add((Object)2), new JsonArray().add((Object)"uihwqduh").add((Object)false));
    }

    @Test
    public void testMapRemoveSerializableObject() {
        this.testMapRemove(new SomeSerializableObject("bar"), new SomeSerializableObject("bar"));
    }

    @Test
    public void testMapRemoveClusterSerializableObject() {
        this.testMapRemove(new SomeClusterSerializableObject("bar"), new SomeClusterSerializableObject("bar"));
    }

    @Test
    public void testMapRemoveIfPresentByte() {
        this.testMapRemoveIfPresent((byte)1, (byte)2, (byte)3, (byte)4);
    }

    @Test
    public void testMapRemoveIfPresentShort() {
        this.testMapRemoveIfPresent((short)1, (short)2, (short)3, (short)4);
    }

    @Test
    public void testMapRemoveIfPresentInt() {
        this.testMapRemoveIfPresent(1, 2, 3, 4);
    }

    @Test
    public void testMapRemoveIfPresentLong() {
        this.testMapRemoveIfPresent(1L, 2L, 3L, 4L);
    }

    @Test
    public void testMapRemoveIfPresentChar() {
        this.testMapRemoveIfPresent(Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'));
    }

    @Test
    public void testMapRemoveIfPresentFloat() {
        this.testMapRemoveIfPresent(Float.valueOf(1.2f), Float.valueOf(2.2f), Float.valueOf(3.2f), Float.valueOf(4.2f));
    }

    @Test
    public void testMapRemoveIfPresentBuffer() {
        this.testMapRemoveIfPresent(TestUtils.randomBuffer(4), TestUtils.randomBuffer(4), TestUtils.randomBuffer(12), TestUtils.randomBuffer(14));
    }

    @Test
    public void testMapRemoveIfPresentDouble() {
        this.testMapRemoveIfPresent(1.2, 2.2, 3.2, 4.2);
    }

    @Test
    public void testMapRemoveIfPresentBoolean() {
        this.testMapRemoveIfPresent("foo", "bar", true, false);
    }

    @Test
    public void testMapRemoveIfPresentString() {
        this.testMapRemoveIfPresent("foo", "bar", "baz", "quux");
    }

    @Test
    public void testMapRemoveIfPresentJsonObject() {
        this.testMapRemoveIfPresent(new JsonObject().put("foo", (Object)"bar"), new JsonObject().put("baz", (Object)"quux"), new JsonObject().put("uihwqduh", (Object)"qiwiojw"), new JsonObject().put("regerg", (Object)"wfwef"));
    }

    @Test
    public void testMapRemoveIfPresentJsonArray() {
        this.testMapRemoveIfPresent(new JsonArray().add((Object)"foo").add((Object)2), new JsonArray().add((Object)"bar").add((Object)4), new JsonArray().add((Object)"uihwqduh").add((Object)false), new JsonArray().add((Object)"qqddq").add((Object)true));
    }

    @Test
    public void testMapRemoveIfPresentSerializableObject() {
        this.testMapRemoveIfPresent(new SomeSerializableObject("foo"), new SomeSerializableObject("bar"), new SomeSerializableObject("baz"), new SomeSerializableObject("quux"));
    }

    @Test
    public void testMapRemoveIfPresentClusterSerializableObject() {
        this.testMapRemoveIfPresent(new SomeClusterSerializableObject("foo"), new SomeClusterSerializableObject("bar"), new SomeClusterSerializableObject("baz"), new SomeClusterSerializableObject("quux"));
    }

    @Test
    public void testMapReplaceByte() {
        this.testMapReplace((byte)1, (byte)2, (byte)3);
    }

    @Test
    public void testMapReplaceShort() {
        this.testMapReplace((short)1, (short)2, (short)3);
    }

    @Test
    public void testMapReplaceInt() {
        this.testMapReplace(1, 2, 3);
    }

    @Test
    public void testMapReplaceLong() {
        this.testMapReplace(1L, 2L, 3L);
    }

    @Test
    public void testMapReplaceChar() {
        this.testMapReplace(Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'));
    }

    @Test
    public void testMapReplaceFloat() {
        this.testMapReplace(Float.valueOf(1.2f), Float.valueOf(2.2f), Float.valueOf(3.3f));
    }

    @Test
    public void testMapReplaceBuffer() {
        this.testMapReplace(TestUtils.randomBuffer(4), TestUtils.randomBuffer(12), TestUtils.randomBuffer(14));
    }

    @Test
    public void testMapReplaceDouble() {
        this.testMapReplace(1.2, 2.2, 3.3);
    }

    @Test
    public void testMapReplaceBoolean() {
        this.testMapReplace("foo", true, false);
    }

    @Test
    public void testMapReplaceString() {
        this.testMapReplace("foo", "bar", "quux");
    }

    @Test
    public void testMapReplaceJsonObject() {
        this.testMapReplace(new JsonObject().put("foo", (Object)"bar"), new JsonObject().put("uihwqduh", (Object)"qiwiojw"), new JsonObject().put("regerg", (Object)"wfwef"));
    }

    @Test
    public void testMapReplaceJsonArray() {
        this.testMapReplace(new JsonArray().add((Object)"foo").add((Object)2), new JsonArray().add((Object)"uihwqduh").add((Object)false), new JsonArray().add((Object)"qqddq").add((Object)true));
    }

    @Test
    public void testMapReplaceSerializableObject() {
        this.testMapReplace(new SomeSerializableObject("foo"), new SomeSerializableObject("bar"), new SomeSerializableObject("quux"));
    }

    @Test
    public void testMapReplaceClusterSerializableObject() {
        this.testMapReplace(new SomeClusterSerializableObject("foo"), new SomeClusterSerializableObject("bar"), new SomeClusterSerializableObject("quux"));
    }

    @Test
    public void testMapReplaceTtl() {
        SharedData sharedData = this.getVertx().sharedData();
        sharedData.getAsyncMap("foo").compose(map -> map.replace((Object)"pipo", (Object)"molo", 10L).expecting(AssertExpectations.that(Assert::assertNull))).compose(v -> this.assertWaitUntilMapContains(sharedData, "foo", "pipo", 15L, Objects::isNull)).onComplete(this.onSuccess(v -> this.testComplete()));
        this.await();
    }

    @Test
    public void testMapReplaceTtlWithPreviousValue() {
        SharedData sharedData = this.getVertx().sharedData();
        sharedData.getAsyncMap("foo").compose(map -> map.put((Object)"pipo", (Object)"molo").expecting(AssertExpectations.that(Assert::assertNull)).compose(vd -> map.replace((Object)"pipo", (Object)"mili", 10L))).compose(v -> this.assertWaitUntilMapContains(sharedData, "foo", "pipo", 15L, Objects::isNull)).onComplete(this.onSuccess(v -> this.testComplete()));
        this.await();
    }

    @Test
    public void testMapReplaceIfPresentByte() {
        this.testMapReplaceIfPresent((byte)1, (byte)2, (byte)3);
    }

    @Test
    public void testMapReplaceIfPresentShort() {
        this.testMapReplaceIfPresent((short)1, (short)2, (short)3);
    }

    @Test
    public void testMapReplaceIfPresentInt() {
        this.testMapReplaceIfPresent(1, 2, 3);
    }

    @Test
    public void testMapReplaceIfPresentLong() {
        this.testMapReplaceIfPresent(1L, 2L, 3L);
    }

    @Test
    public void testMapReplaceIfPresentChar() {
        this.testMapReplaceIfPresent(Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'));
    }

    @Test
    public void testMapReplaceIfPresentFloat() {
        this.testMapReplaceIfPresent(Float.valueOf(1.2f), Float.valueOf(2.2f), Float.valueOf(3.3f));
    }

    @Test
    public void testMapReplaceIfPresentBuffer() {
        this.testMapReplaceIfPresent(TestUtils.randomBuffer(4), TestUtils.randomBuffer(12), TestUtils.randomBuffer(14));
    }

    @Test
    public void testMapReplaceIfPresentDouble() {
        this.testMapReplaceIfPresent(1.2, 2.2, 3.3);
    }

    @Test
    public void testMapReplaceIfPresentBoolean() {
        this.testMapReplaceIfPresent("foo", true, false);
    }

    @Test
    public void testMapReplaceIfPresentString() {
        this.testMapReplaceIfPresent("foo", "bar", "quux");
    }

    @Test
    public void testMapReplaceIfPresentJsonObject() {
        this.testMapReplaceIfPresent(new JsonObject().put("foo", (Object)"bar"), new JsonObject().put("uihwqduh", (Object)"qiwiojw"), new JsonObject().put("regerg", (Object)"wfwef"));
    }

    @Test
    public void testMapReplaceIfPresentJsonArray() {
        this.testMapReplaceIfPresent(new JsonArray().add((Object)"foo").add((Object)2), new JsonArray().add((Object)"uihwqduh").add((Object)false), new JsonArray().add((Object)"qqddq").add((Object)true));
    }

    @Test
    public void testMapReplaceIfPresentSerializableObject() {
        this.testMapReplaceIfPresent(new SomeSerializableObject("foo"), new SomeSerializableObject("bar"), new SomeSerializableObject("quux"));
    }

    @Test
    public void testMapReplaceIfPresentClusterSerializableObject() {
        this.testMapReplaceIfPresent(new SomeClusterSerializableObject("foo"), new SomeClusterSerializableObject("bar"), new SomeClusterSerializableObject("quux"));
    }

    @Test
    public void testMapReplaceIfPresentTtl() {
        SharedData sharedData = this.getVertx().sharedData();
        sharedData.getAsyncMap("foo").compose(map -> map.put((Object)"pipo", (Object)"molo").expecting(AssertExpectations.that(Assert::assertNull)).compose(v -> map.replaceIfPresent((Object)"pipo", (Object)"molo", (Object)"mili", 10L).expecting(AssertExpectations.that(Assert::assertTrue)))).compose(v -> this.assertWaitUntilMapContains(sharedData, "foo", "pipo", 15L, Objects::isNull)).onComplete(this.onSuccess(v -> this.testComplete()));
        this.await();
    }

    @Test
    public void testMapReplaceIfPresentTtlWhenNotPresent() {
        this.getVertx().sharedData().getAsyncMap("foo").compose(map -> map.replaceIfPresent((Object)"pipo", (Object)"molo", (Object)"mili", 10L).expecting(AssertExpectations.that(Assert::assertFalse))).onComplete(this.onSuccess(vd -> this.testComplete()));
        this.await();
    }

    @Test
    public void testGetMapWithNullName() throws Exception {
        TestUtils.assertNullPointerException(() -> this.getVertx().sharedData().getAsyncMap(null));
    }

    @Test
    public void testPutNullKey() {
        this.getVertx().sharedData().getAsyncMap("foo").onComplete(this.onSuccess(map -> {
            TestUtils.assertIllegalArgumentException(() -> map.put(null, (Object)"foo"));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testPutNullValue() {
        this.getVertx().sharedData().getAsyncMap("foo").onComplete(this.onSuccess(map -> {
            TestUtils.assertIllegalArgumentException(() -> map.put((Object)"foo", null));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testPutInvalidKey() {
        this.getVertx().sharedData().getAsyncMap("foo").onComplete(this.onSuccess(map -> {
            TestUtils.assertIllegalArgumentException(() -> map.put((Object)new SomeObject(), (Object)"foo"));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testPutInvalidValue() {
        this.getVertx().sharedData().getAsyncMap("foo").onComplete(this.onSuccess(map -> {
            TestUtils.assertIllegalArgumentException(() -> map.put((Object)"foo", (Object)new SomeObject()));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testPutIfAbsentInvalidKey() {
        this.getVertx().sharedData().getAsyncMap("foo").onComplete(this.onSuccess(map -> {
            TestUtils.assertIllegalArgumentException(() -> map.putIfAbsent((Object)new SomeObject(), (Object)"foo"));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testPutIfAbsentInvalidValue() {
        this.getVertx().sharedData().getAsyncMap("foo").onComplete(this.onSuccess(map -> {
            TestUtils.assertIllegalArgumentException(() -> map.putIfAbsent((Object)"foo", (Object)new SomeObject()));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testMultipleMaps() {
        SharedData sharedData = this.getVertx().sharedData();
        sharedData.getAsyncMap("foo").compose(map -> map.put((Object)"foo", (Object)"bar")).compose(v -> sharedData.getAsyncMap("bar").compose(map -> map.get((Object)"foo")).expecting(AssertExpectations.that(Assert::assertNull))).onComplete(this.onSuccess(res -> this.testComplete()));
        this.await();
    }

    @Test
    public void testClear() {
        SharedData sharedData = this.getVertx().sharedData();
        sharedData.getAsyncMap("foo").compose(map -> map.put((Object)"foo", (Object)"bar")).compose(v -> sharedData.getAsyncMap("foo").compose(map -> map.clear().compose(v2 -> map.get((Object)"foo")))).onComplete(this.onSuccess(v -> this.testComplete()));
        this.await();
    }

    @Test
    public void testSize() {
        SharedData sharedData = this.getVertx().sharedData();
        sharedData.getAsyncMap("foo").compose(map -> map.size().expecting(AssertExpectations.that(size -> this.assertEquals(0L, size.intValue()))).compose(v -> map.put((Object)"foo", (Object)"bar")).compose(v -> map.size().expecting(AssertExpectations.that(size -> this.assertEquals(1L, size.intValue()))))).compose(v -> sharedData.getAsyncMap("foo").compose(map -> map.size().expecting(AssertExpectations.that(size -> this.assertEquals(1L, size.intValue()))))).onComplete(this.onSuccess(v -> this.testComplete()));
        this.await();
    }

    @Test
    public void testKeys() {
        Map<JsonObject, Buffer> map = this.genJsonToBuffer(100);
        this.loadData(map, (vertx, asyncMap) -> asyncMap.keys().onComplete(this.onSuccess(keys -> {
            this.assertEquals(map.keySet(), keys);
            this.testComplete();
        })));
        this.await();
    }

    @Test
    public void testValues() {
        Map<JsonObject, Buffer> map = this.genJsonToBuffer(100);
        this.loadData(map, (vertx, asyncMap) -> asyncMap.values().expecting(AssertExpectations.that(values -> {
            this.assertEquals(map.values().size(), values.size());
            this.assertTrue(map.values().containsAll((Collection<?>)values));
            this.assertTrue(values.containsAll(map.values()));
        })).onComplete(this.onSuccess(values -> this.testComplete())));
        this.await();
    }

    @Test
    public void testEntries() {
        Map<JsonObject, Buffer> map = this.genJsonToBuffer(100);
        this.loadData(map, (vertx, asyncMap) -> asyncMap.entries().expecting(AssertExpectations.that(res -> this.assertEquals(map.entrySet(), res.entrySet()))).onSuccess(res -> this.testComplete()));
        this.await();
    }

    protected Map<JsonObject, Buffer> genJsonToBuffer(int size) {
        HashMap<JsonObject, Buffer> map = new HashMap<JsonObject, Buffer>();
        for (int i = 0; i < size; ++i) {
            JsonObject key = new JsonObject().put("key", (Object)i);
            map.put(key, key.toBuffer());
        }
        return map;
    }

    protected void loadData(Map<JsonObject, Buffer> map, BiConsumer<Vertx, AsyncMap<JsonObject, Buffer>> test) {
        SharedData sharedData = this.getVertx().sharedData();
        ArrayList futures = new ArrayList(map.size());
        map.forEach((key, value) -> futures.add(sharedData.getAsyncMap("foo").compose(asyncMap -> asyncMap.put(key, value))));
        Future.all(futures).compose(cf -> sharedData.getAsyncMap("foo")).onComplete(this.onSuccess(asyncMap -> test.accept(this.getVertx(), (AsyncMap<JsonObject, Buffer>)asyncMap)));
    }

    private <K, V> void testMapPutGet(K k, V v) {
        SharedData sharedData = this.getVertx().sharedData();
        sharedData.getAsyncMap("foo").compose(map -> map.put(k, v)).compose(v_ -> sharedData.getAsyncMap("foo").compose(map -> map.get(k)).expecting(AssertExpectations.that(res -> this.assertEquals(v, res)))).onComplete(this.onSuccess(res -> this.testComplete()));
        this.await();
    }

    private <K, V> void testMapPutIfAbsentGet(K k, V v) {
        SharedData sharedData = this.getVertx().sharedData();
        sharedData.getAsyncMap("foo").compose(map -> map.putIfAbsent(k, v)).expecting(AssertExpectations.that(Assert::assertNull)).compose(v_ -> sharedData.getAsyncMap("foo")).compose(map -> map.get(k).expecting(AssertExpectations.that(res -> this.assertEquals(v, res))).compose(res2 -> map.putIfAbsent(k, v)).expecting(AssertExpectations.that(res -> this.assertEquals(v, res)))).onComplete(this.onSuccess(res -> this.testComplete()));
        this.await();
    }

    private <K, V> void testMapRemove(K k, V v) {
        SharedData sharedData = this.getVertx().sharedData();
        sharedData.getAsyncMap("foo").compose(map -> map.put(k, v).expecting(AssertExpectations.that(Assert::assertNull))).compose(v_ -> sharedData.getAsyncMap("foo").compose(map -> map.remove(k)).expecting(AssertExpectations.that(res -> this.assertEquals(v, res)))).onComplete(this.onSuccess(res -> this.testComplete()));
        this.await();
    }

    private <K, V> void testMapRemoveIfPresent(K k, K otherKey, V v, V otherValue) {
        SharedData sharedData = this.getVertx().sharedData();
        sharedData.getAsyncMap("foo").compose(map -> map.put(k, v).expecting(AssertExpectations.that(Assert::assertNull))).compose(v_ -> sharedData.getAsyncMap("foo")).compose(map -> map.removeIfPresent(otherKey, v).expecting(AssertExpectations.that(Assert::assertFalse)).compose(res -> map.removeIfPresent(k, otherValue).expecting(AssertExpectations.that(Assert::assertFalse))).compose(res -> map.removeIfPresent(k, v).expecting(AssertExpectations.that(Assert::assertTrue)))).onComplete(this.onSuccess(v_ -> this.testComplete()));
        this.await();
    }

    private <K, V> void testMapReplace(K k, V v, V other) {
        SharedData sharedData = this.getVertx().sharedData();
        sharedData.getAsyncMap("foo").compose(map -> map.put(k, v).expecting(AssertExpectations.that(Assert::assertNull))).compose(v_ -> sharedData.getAsyncMap("foo").compose(map -> map.replace(k, other).expecting(AssertExpectations.that(res -> this.assertEquals(v, res))).compose(v__ -> map.get(k).expecting(AssertExpectations.that(res -> this.assertEquals(other, res)))).compose(v__ -> map.remove(k)).compose(v__ -> map.replace(k, other).expecting(AssertExpectations.that(Assert::assertNull))).compose(v__ -> map.get(k).expecting(AssertExpectations.that(Assert::assertNull))))).onComplete(this.onSuccess(v_ -> this.testComplete()));
        this.await();
    }

    private <K, V> void testMapReplaceIfPresent(K k, V v, V other) {
        SharedData sharedData = this.getVertx().sharedData();
        sharedData.getAsyncMap("foo").compose(map -> map.put(k, v).expecting(AssertExpectations.that(Assert::assertNull))).compose(v_ -> sharedData.getAsyncMap("foo")).compose(map -> map.replaceIfPresent(k, v, other).compose(res2 -> map.replaceIfPresent(k, v, other).expecting(AssertExpectations.that(Assert::assertFalse))).compose(v_ -> map.get(k).expecting(AssertExpectations.that(res4 -> this.assertEquals(other, res4))))).onComplete(this.onSuccess(v_ -> this.testComplete()));
        this.await();
    }

    public static final class SomeClusterSerializableObject
    implements ClusterSerializable {
        private String str;
        private final Object object = new Object();

        public SomeClusterSerializableObject() {
        }

        public SomeClusterSerializableObject(String str) {
            this.str = str;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SomeClusterSerializableObject)) {
                return false;
            }
            SomeClusterSerializableObject that = (SomeClusterSerializableObject)o;
            return !(this.str != null ? !this.str.equals(that.str) : that.str != null);
        }

        public int hashCode() {
            return this.str != null ? this.str.hashCode() : 0;
        }

        public void writeToBuffer(Buffer buffer) {
            buffer.appendInt(this.str.length());
            buffer.appendString(this.str);
        }

        public int readFromBuffer(int pos, Buffer buffer) {
            int length = buffer.getInt(pos);
            this.str = buffer.getString(pos + 4, pos + 4 + length);
            return pos + 4 + length;
        }
    }

    public static final class SomeSerializableObject
    implements Serializable {
        private String str;

        public SomeSerializableObject(String str) {
            this.str = str;
        }

        public SomeSerializableObject() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SomeSerializableObject)) {
                return false;
            }
            SomeSerializableObject that = (SomeSerializableObject)o;
            return !(this.str != null ? !this.str.equals(that.str) : that.str != null);
        }

        public int hashCode() {
            return this.str != null ? this.str.hashCode() : 0;
        }
    }

    public static final class SomeObject {
    }
}

