/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.shareddata;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.Lock;
import io.vertx.core.shareddata.SharedData;
import io.vertx.core.shareddata.impl.LockInternal;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class AsynchronousLockTest
extends VertxTestBase {
    protected Vertx getVertx() {
        return this.vertx;
    }

    @Test
    public void testIllegalArguments() throws Exception {
        TestUtils.assertNullPointerException(() -> this.getVertx().sharedData().getLock(null));
        TestUtils.assertNullPointerException(() -> this.getVertx().sharedData().getLockWithTimeout(null, 1L));
        TestUtils.assertIllegalArgumentException(() -> this.getVertx().sharedData().getLockWithTimeout("foo", -1L));
    }

    @Test
    public void testAcquire() {
        SharedData sharedData = this.getVertx().sharedData();
        sharedData.getLock("foo").onComplete(this.onSuccess(lock -> {
            long start = System.currentTimeMillis();
            this.vertx.setTimer(1000L, tid -> lock.release());
            sharedData.getLock("foo").onComplete(this.onSuccess(v -> {
                this.assertTrue(System.currentTimeMillis() - start >= 1000L);
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testAcquireOnSameEventLoop() {
        Vertx vertx = this.getVertx();
        Context context = vertx.getOrCreateContext();
        SharedData sharedData = vertx.sharedData();
        AtomicReference start = new AtomicReference();
        context.runOnContext(v -> sharedData.getLock("foo").onComplete(this.onSuccess(lock -> {
            start.set(System.currentTimeMillis());
            vertx.setTimer(1000L, tid -> lock.release());
            context.runOnContext(v2 -> sharedData.getLock("foo").onComplete(this.onSuccess(ar2 -> {
                this.assertTrue(System.currentTimeMillis() - (Long)start.get() >= 1000L);
                this.testComplete();
            })));
        })));
        this.await();
    }

    @Test
    public void testAcquireDifferentLocksOnSameEventLoop() {
        Vertx vertx = this.getVertx();
        Context context = vertx.getOrCreateContext();
        SharedData sharedData = vertx.sharedData();
        AtomicInteger stage = new AtomicInteger();
        context.runOnContext(v -> sharedData.getLock("foo").onComplete(this.onSuccess(foo -> {
            this.assertTrue(stage.compareAndSet(0, 1));
            sharedData.getLock("foo").onComplete(this.onSuccess(foo1 -> {
                this.assertEquals(2L, stage.get());
                foo1.release();
                this.testComplete();
            }));
            sharedData.getLock("bar").onComplete(this.onSuccess(bar -> {
                this.assertTrue(stage.compareAndSet(1, 2));
                foo.release();
                bar.release();
            }));
        })));
        this.await();
    }

    @Test
    public void testAcquireOnExecuteBlocking() {
        Vertx vertx = this.getVertx();
        SharedData sharedData = vertx.sharedData();
        AtomicReference start = new AtomicReference();
        vertx.executeBlocking(() -> {
            CountDownLatch acquireLatch = new CountDownLatch(1);
            AtomicReference lockReference = new AtomicReference();
            sharedData.getLock("foo").onComplete(ar -> {
                lockReference.set(ar);
                acquireLatch.countDown();
            });
            this.awaitLatch(acquireLatch);
            AsyncResult ar2 = (AsyncResult)lockReference.get();
            if (ar2.succeeded()) {
                return (Lock)ar2.result();
            }
            throw new Exception(ar2.cause());
        }).compose(lock -> {
            start.set(System.currentTimeMillis());
            vertx.setTimer(1000L, tid -> lock.release());
            return vertx.executeBlocking(() -> {
                CountDownLatch acquireLatch = new CountDownLatch(1);
                AtomicReference lockReference = new AtomicReference();
                sharedData.getLock("foo").onComplete(ar2 -> {
                    lockReference.set(ar2);
                    acquireLatch.countDown();
                });
                this.awaitLatch(acquireLatch);
                AsyncResult ar3 = (AsyncResult)lockReference.get();
                if (ar3.succeeded()) {
                    return (Lock)ar3.result();
                }
                throw new Exception(ar3.cause());
            });
        }).onComplete(this.onSuccess(v -> {
            this.assertTrue(System.currentTimeMillis() - (Long)start.get() >= 1000L);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testAcquireDifferentLocks() {
        SharedData sharedData = this.getVertx().sharedData();
        sharedData.getLock("foo").onComplete(this.onSuccess(lock1 -> {
            long start = System.currentTimeMillis();
            sharedData.getLock("bar").onComplete(this.onSuccess(lock2 -> {
                this.assertTrue(System.currentTimeMillis() - start < 2000L);
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testWithLock() {
        this.waitFor(2);
        String expected = TestUtils.randomAlphaString(10);
        SharedData sharedData = this.getVertx().sharedData();
        sharedData.withLock("foo", () -> {
            long start = System.currentTimeMillis();
            sharedData.getLock("foo").onComplete(this.onSuccess(v2 -> {
                this.assertTrue(System.currentTimeMillis() - start >= 1000L);
                this.complete();
            }));
            return Future.future(p -> this.vertx.setTimer(1000L, tid -> p.complete((Object)expected)));
        }).onComplete(this.onSuccess(s -> {
            this.assertEquals(expected, s);
            this.complete();
        }));
        this.await();
    }

    @Test
    public void testWithLockFailure() {
        RuntimeException failure = new RuntimeException();
        SharedData sharedData = this.getVertx().sharedData();
        sharedData.withLock("foo", () -> {
            throw failure;
        }).onComplete(this.onFailure(err -> {
            this.assertSame(failure, err.getCause());
            this.complete();
        }));
        this.await();
    }

    @Test
    public void testWithDifferentLocks() {
        SharedData sharedData = this.getVertx().sharedData();
        sharedData.withLock("foo", () -> {
            long start = System.currentTimeMillis();
            return sharedData.withLock("bar", () -> Future.succeededFuture((Object)(System.currentTimeMillis() - start < 2000L ? 1 : 0)));
        }).onComplete(this.onSuccess(res -> {
            this.assertTrue((boolean)res);
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testAcquireTimeout() {
        SharedData sharedData = this.getVertx().sharedData();
        sharedData.getLock("foo").onComplete(this.onSuccess(ar -> {
            long start = System.currentTimeMillis();
            sharedData.getLockWithTimeout("foo", 1000L).onComplete(this.onFailure(ar2 -> {
                this.assertTrue(System.currentTimeMillis() - start >= 1000L);
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testWithLockTimeout() {
        SharedData sharedData = this.getVertx().sharedData();
        sharedData.getLock("foo").onComplete(this.onSuccess(ar -> {
            long start = System.currentTimeMillis();
            sharedData.withLock("foo", 1000L, () -> {
                this.fail();
                return Future.failedFuture((String)"should-not-be-called");
            }).onComplete(this.onFailure(ar2 -> {
                this.assertTrue(System.currentTimeMillis() - start >= 1000L);
                this.testComplete();
            }));
        }));
        this.await();
    }

    @Test
    public void testReleaseTwice() throws Exception {
        CountDownLatch latch = new CountDownLatch(2);
        AtomicInteger count = new AtomicInteger();
        this.getVertx().sharedData().getLock("foo").onComplete(this.onSuccess(lock1 -> {
            count.incrementAndGet();
            for (int i = 0; i < 2; ++i) {
                this.getVertx().sharedData().getLockWithTimeout("foo", 10L).onComplete(ar -> {
                    if (ar.succeeded()) {
                        count.incrementAndGet();
                    }
                    latch.countDown();
                });
            }
            lock1.release();
            lock1.release();
        }));
        this.awaitLatch(latch);
        this.assertEquals(2L, count.get());
    }

    @Test
    public void testNoWorkerStarvation() {
        this.waitFor(5);
        this.getVertx().deployVerticle(() -> new AbstractVerticle(){

            public void start() throws Exception {
                this.vertx.sharedData().getLock("foo").onComplete(AsynchronousLockTest.this.onSuccess(lock -> this.vertx.setTimer(10L, l -> {
                    lock.release();
                    AsynchronousLockTest.this.complete();
                })));
            }
        }, new DeploymentOptions().setInstances(5).setWorkerPoolName("bar").setWorkerPoolSize(1));
        this.await();
    }

    @Test
    public void evictTimedOutWaiters() {
        int numWaiters = 10;
        SharedData sharedData = this.vertx.sharedData();
        sharedData.getLocalLock("foo").onComplete(this.onSuccess(lock -> {
            ArrayList<Future> locks = new ArrayList<Future>();
            for (int i = 0; i < numWaiters; ++i) {
                locks.add(sharedData.getLocalLockWithTimeout("foo", 200L));
            }
            LockInternal lockInternal = (LockInternal)lock;
            this.assertEquals(numWaiters, lockInternal.waiters());
            Future.join(locks).onComplete(cf -> {
                this.assertEquals(0L, lockInternal.waiters());
                lock.release();
                this.testComplete();
            });
        }));
        this.await();
    }
}

