/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.shareddata;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.test.fakecluster.FakeClusterManager;
import io.vertx.tests.shareddata.AsyncMapTest;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;

public class ClusteredAsyncMapTest
extends AsyncMapTest {
    protected final int numNodes = 3;
    AtomicInteger pos = new AtomicInteger();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.startNodes(3);
    }

    @Override
    protected ClusterManager getClusterManager() {
        return new FakeClusterManager();
    }

    @Override
    protected Vertx getVertx() {
        int i = this.pos.incrementAndGet();
        i = this.mod(i, 3);
        return this.vertices[i];
    }

    private int mod(int idx, int size) {
        int i = idx % size;
        return i < 0 ? i + size : i;
    }

    @Test
    public void testGetLocalAsyncMap() {
        Vertx node1 = this.getVertx();
        Vertx node2 = this.getVertx();
        this.assertNotSame(node1, node2);
        Future.all((Future)node1.sharedData().getLocalAsyncMap("map"), (Future)node2.sharedData().getLocalAsyncMap("map")).compose(compFutureMaps -> {
            AsyncMap mapNode1 = (AsyncMap)((CompositeFuture)compFutureMaps.result()).resultAt(0);
            AsyncMap mapNode2 = (AsyncMap)((CompositeFuture)compFutureMaps.result()).resultAt(1);
            return Future.all((Future)mapNode1.put((Object)"Hodor", (Object)"Hodor"), (Future)mapNode2.put((Object)"Hodor", (Object)"Hodor Hodor")).compose(compFuturePutted -> Future.all((Future)mapNode1.get((Object)"Hodor"), (Future)mapNode2.get((Object)"Hodor")));
        }).onComplete(this.onSuccess(asyncCompFuture -> {
            String valueMapNode1 = (String)((CompositeFuture)asyncCompFuture.result()).resultAt(0);
            String valueMapNode2 = (String)((CompositeFuture)asyncCompFuture.result()).resultAt(1);
            this.assertEquals(valueMapNode1, "Hodor");
            this.assertEquals(valueMapNode2, "Hodor Hodor");
            this.testComplete();
        }));
        this.await();
    }
}

