/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.shareddata;

import io.vertx.core.Completable;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.shareddata.Lock;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.test.fakecluster.FakeClusterManager;
import io.vertx.tests.shareddata.AsynchronousLockTest;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.junit.Ignore;
import org.junit.Test;

public class ClusteredAsynchronousLockTest
extends AsynchronousLockTest {
    protected final int numNodes = 3;
    AtomicInteger pos = new AtomicInteger();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.startNodes(3);
    }

    @Override
    protected ClusterManager getClusterManager() {
        return new FakeClusterManager();
    }

    @Override
    protected Vertx getVertx() {
        int i = this.pos.incrementAndGet();
        i = this.mod(i, 3);
        return this.vertices[i];
    }

    private int mod(int idx, int size) {
        int i = idx % size;
        return i < 0 ? i + size : i;
    }

    @Test
    public void testGetLocalLock() {
        Vertx node1 = this.getVertx();
        Vertx node2 = this.getVertx();
        this.assertNotSame(node1, node2);
        AtomicInteger checkpoint = new AtomicInteger(1);
        Future.all((Future)node1.sharedData().getLocalLock("lock"), (Future)node2.sharedData().getLocalLock("lock")).compose(compFuture -> {
            Lock lockNode1 = (Lock)((CompositeFuture)compFuture.result()).resultAt(0);
            Lock lockNode2 = (Lock)((CompositeFuture)compFuture.result()).resultAt(1);
            lockNode1.release();
            return node2.sharedData().getLocalLockWithTimeout("lock", 250L).otherwise(t -> {
                this.assertEquals("Acquire lock should fail", "Timed out waiting to get lock", t.getMessage());
                checkpoint.decrementAndGet();
                return lockNode2;
            });
        }).onComplete(this.onSuccess(asyncLock -> {
            this.assertEquals(0L, checkpoint.get());
            asyncLock.release();
            this.testComplete();
        }));
        this.await();
    }

    @Test
    @Ignore
    public void testLockReleasedForClosedNode() throws Exception {
        this.testLockReleased(latch -> this.vertices[0].close().onComplete(this.onSuccess(v -> latch.countDown())));
    }

    @Test
    @Ignore
    public void testLockReleasedForKilledNode() throws Exception {
        this.testLockReleased(latch -> {
            VertxInternal vi = (VertxInternal)this.vertices[0];
            PromiseInternal promise = vi.getOrCreateContext().promise();
            vi.clusterManager().leave((Completable)promise);
            promise.future().onComplete(this.onSuccess(v -> latch.countDown()));
        });
    }

    private void testLockReleased(Consumer<CountDownLatch> action) throws Exception {
        Lock lock = (Lock)this.awaitFuture(this.vertices[0].sharedData().getLockWithTimeout("pimpo", this.getLockTimeout()));
        Future fut = this.vertices[1].sharedData().getLockWithTimeout("pimpo", this.getLockTimeout());
        CountDownLatch closeLatch = new CountDownLatch(1);
        action.accept(closeLatch);
        this.awaitLatch(closeLatch);
        Lock lock2 = (Lock)this.awaitFuture(fut);
        lock2.release();
    }

    protected long getLockTimeout() {
        return 10000L;
    }
}

