/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.shareddata;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.Counter;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.test.fakecluster.FakeClusterManager;
import io.vertx.tests.shareddata.SharedCounterTest;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;

public class ClusteredSharedCounterTest
extends SharedCounterTest {
    protected final int numNodes = 3;
    AtomicInteger pos = new AtomicInteger();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.startNodes(3);
    }

    @Override
    protected ClusterManager getClusterManager() {
        return new FakeClusterManager();
    }

    @Override
    protected Vertx getVertx() {
        int i = this.pos.incrementAndGet();
        i = this.mod(i, 3);
        return this.vertices[i];
    }

    private int mod(int idx, int size) {
        int i = idx % size;
        return i < 0 ? i + size : i;
    }

    @Test
    public void testGetLocalCounter() {
        Vertx node1 = this.getVertx();
        Vertx node2 = this.getVertx();
        this.assertNotSame(node1, node2);
        Future.all((Future)node1.sharedData().getLocalCounter("counter"), (Future)node2.sharedData().getLocalCounter("counter")).compose(compFuture -> {
            Counter counterNode1 = (Counter)((CompositeFuture)compFuture.result()).resultAt(0);
            Counter counterNode2 = (Counter)((CompositeFuture)compFuture.result()).resultAt(1);
            return Future.all((Future)counterNode1.addAndGet(1L), (Future)counterNode2.addAndGet(2L));
        }).onComplete(this.onSuccess(asyncCompFuture -> {
            long valueCounterNode1 = (Long)((CompositeFuture)asyncCompFuture.result()).resultAt(0);
            long valueCounterNode2 = (Long)((CompositeFuture)asyncCompFuture.result()).resultAt(1);
            this.assertEquals(valueCounterNode1, 1L);
            this.assertEquals(valueCounterNode2, 2L);
            this.testComplete();
        }));
        this.await();
    }
}

