/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.shareddata;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.core.shareddata.Shareable;
import io.vertx.core.shareddata.SharedData;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import io.vertx.tests.shareddata.AsyncMapTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import org.junit.Test;

public class LocalSharedDataTest
extends VertxTestBase {
    private SharedData sharedData;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.sharedData = this.vertx.sharedData();
    }

    @Test
    public void deleteElementOnComputeFunctionReturningNull() {
        LocalMap map = this.sharedData.getLocalMap("foo");
        map.put((Object)"hello", (Object)"world");
        map.computeIfPresent((Object)"hello", (key, oldValue) -> null);
        this.assertFalse(map.containsKey((Object)"hello"));
        map.compute((Object)"hello", (key, oldValue) -> null);
        this.assertFalse(map.containsKey((Object)"hello"));
        map.put((Object)"hello", (Object)"world");
        map.merge((Object)"hello", (Object)"world!!!!!!", (key, oldValue) -> null);
        this.assertFalse(map.containsKey((Object)"hello"));
        map.computeIfAbsent((Object)"hello", key -> null);
        this.assertFalse(map.containsKey((Object)"hello"));
    }

    @Test
    public void testMap() throws Exception {
        TestUtils.assertNullPointerException(() -> this.sharedData.getLocalMap(null));
        LocalMap map = this.sharedData.getLocalMap("foo");
        LocalMap map2 = this.sharedData.getLocalMap("foo");
        this.assertTrue(map == map2);
        LocalMap map3 = this.sharedData.getLocalMap("bar");
        this.assertFalse(map3 == map2);
        map.close();
        LocalMap map4 = this.sharedData.getLocalMap("foo");
        this.assertFalse(map4 == map3);
    }

    @Test
    public void testLocalMaps() {
        LocalMap map = this.sharedData.getLocalMap("test-map");
        this.assertNotNull(map);
        this.assertTrue(map.isEmpty());
        this.assertEquals(map.size(), 0L);
        this.assertEquals(map.entrySet().size(), 0L);
        this.assertEquals(map.values().size(), 0L);
        this.assertEquals(map.keySet().size(), 0L);
        this.assertEquals(map.getOrDefault((Object)"foo", (Object)"miss"), "miss");
        this.assertNull(map.putIfAbsent((Object)"foo", (Object)"there"));
        this.assertNotNull(map.putIfAbsent((Object)"foo", (Object)"there"));
        this.assertEquals(map.getOrDefault((Object)"foo", (Object)"miss"), "there");
        this.assertEquals(map.get((Object)"foo"), "there");
        this.assertNull(map.get((Object)"missing"));
        this.assertFalse(map.isEmpty());
        this.assertEquals(map.size(), 1L);
        this.assertEquals(map.entrySet().size(), 1L);
        this.assertEquals(map.values().size(), 1L);
        this.assertEquals(map.keySet().size(), 1L);
        this.assertFalse(map.removeIfPresent((Object)"missing", (Object)"nope"));
        this.assertTrue(map.removeIfPresent((Object)"foo", (Object)"there"));
        this.assertNull(map.put((Object)"foo", (Object)"there"));
        this.assertFalse(map.replaceIfPresent((Object)"missing", (Object)"nope", (Object)"something"));
        this.assertTrue(map.replaceIfPresent((Object)"foo", (Object)"there", (Object)"something"));
        this.assertEquals(map.get((Object)"foo"), "something");
        map.compute((Object)"foo", (k, v) -> "something else");
        this.assertEquals(map.get((Object)"foo"), "something else");
        map.compute((Object)"bar", (k, v) -> v == null ? "was null" : "was not null");
        this.assertEquals(map.get((Object)"bar"), "was null");
        map.computeIfAbsent((Object)"foo", k -> "was not there");
        this.assertEquals(map.get((Object)"foo"), "something else");
        map.computeIfAbsent((Object)"baz", k -> "was not there");
        this.assertEquals(map.get((Object)"baz"), "was not there");
        this.assertEquals(map.remove((Object)"baz"), "was not there");
        map.computeIfPresent((Object)"foo", (k, v) -> v.equals("something else") ? "replaced" : "wrong");
        this.assertEquals(map.get((Object)"foo"), "replaced");
        map.computeIfAbsent((Object)"foo", k -> "was not there");
        this.assertEquals(map.get((Object)"foo"), "replaced");
        map.computeIfAbsent((Object)"baz", k -> "was not there");
        this.assertTrue(map.remove((Object)"baz", (Object)"was not there"));
        this.assertTrue(map.toString().contains("bar"));
        this.assertTrue(map.toString().contains("replaced"));
        AtomicInteger count = new AtomicInteger();
        map.forEach((k, v) -> count.incrementAndGet());
        this.assertEquals(count.get(), 2L);
        HashMap<String, String> another = new HashMap<String, String>();
        another.put("foo", "value");
        another.put("new", "another value");
        map.putAll(another);
        this.assertTrue(map.containsKey((Object)"new"));
        this.assertTrue(map.containsValue((Object)"value"));
        map.merge((Object)"new", (Object)"another value", (k, v) -> "replaced");
        this.assertEquals(map.get((Object)"new"), "replaced");
        map.merge((Object)"bar", (Object)"another value", (k, v) -> "inserted");
        this.assertEquals(map.get((Object)"bar"), "inserted");
        map.replace((Object)"bar", (Object)"replaced");
        this.assertEquals(map.get((Object)"bar"), "replaced");
        map.replace((Object)"bar", (Object)"replaced", (Object)"replaced 2");
        this.assertEquals(map.get((Object)"bar"), "replaced 2");
        map.replace((Object)"bar", (Object)"replaced", (Object)"replaced 2");
        this.assertEquals(map.get((Object)"bar"), "replaced 2");
        map.replaceAll((k, v) -> {
            if (k.equals("new")) {
                return "new";
            }
            return v;
        });
        this.assertEquals(map.get((Object)"new"), "new");
        map.clear();
        this.assertTrue(map.isEmpty());
        map.close();
    }

    @Test
    public void testMapTypes() throws Exception {
        LocalMap map = this.sharedData.getLocalMap("foo");
        String key = "key";
        TestUtils.assertNullPointerException(() -> map.put((Object)key, null));
        double d = new Random().nextDouble();
        map.put((Object)key, (Object)d);
        this.assertEquals((Object)d, map.get((Object)key));
        float f = new Random().nextFloat();
        map.put((Object)key, (Object)Float.valueOf(f));
        this.assertEquals(Float.valueOf(f), map.get((Object)key));
        byte b = (byte)new Random().nextInt();
        map.put((Object)key, (Object)b);
        this.assertEquals((Object)b, map.get((Object)key));
        short s = (short)new Random().nextInt();
        map.put((Object)key, (Object)s);
        this.assertEquals((Object)s, map.get((Object)key));
        int i = new Random().nextInt();
        map.put((Object)key, (Object)i);
        this.assertEquals((Object)i, map.get((Object)key));
        long l = new Random().nextLong();
        map.put((Object)key, (Object)l);
        this.assertEquals((Object)l, map.get((Object)key));
        map.put((Object)key, (Object)true);
        this.assertTrue((Boolean)map.get((Object)key));
        map.put((Object)key, (Object)false);
        this.assertFalse((Boolean)map.get((Object)key));
        char c = (char)new Random().nextLong();
        map.put((Object)key, (Object)Character.valueOf(c));
        this.assertEquals(Character.valueOf(c), map.get((Object)key));
        Buffer buff = TestUtils.randomBuffer(100);
        map.put((Object)key, (Object)buff);
        Buffer got1 = (Buffer)map.get((Object)key);
        this.assertTrue(got1 != buff);
        this.assertEquals(buff, map.get((Object)key));
        Buffer got2 = (Buffer)map.get((Object)key);
        this.assertTrue(got1 != got2);
        this.assertTrue(got2 != buff);
        this.assertEquals(buff, map.get((Object)key));
        byte[] bytes = TestUtils.randomByteArray(100);
        map.put((Object)key, (Object)bytes);
        byte[] bgot1 = (byte[])map.get((Object)key);
        this.assertTrue(bgot1 != bytes);
        this.assertTrue(TestUtils.byteArraysEqual(bytes, bgot1));
        byte[] bgot2 = (byte[])map.get((Object)key);
        this.assertTrue(bgot2 != bytes);
        this.assertTrue(bgot1 != bgot2);
        this.assertTrue(TestUtils.byteArraysEqual(bytes, bgot2));
        TestUtils.assertIllegalArgumentException(() -> map.put((Object)key, (Object)new SomeOtherClass()));
        JsonObject obj = new JsonObject().put("foo", (Object)"bar");
        map.put((Object)"obj", (Object)obj);
        JsonObject other = (JsonObject)map.get((Object)"obj");
        this.assertEquals(obj, other);
        this.assertNotSame(obj, other);
        JsonArray arr = new JsonArray().add((Object)"foo");
        map.put((Object)"arr", (Object)arr);
        JsonArray otherArr = (JsonArray)map.get((Object)"arr");
        this.assertEquals(arr, otherArr);
        this.assertNotSame(arr, otherArr);
        BigInteger bi = BigInteger.valueOf(new Random().nextLong());
        map.put((Object)key, (Object)bi);
        BigInteger otherBi = (BigInteger)map.get((Object)key);
        this.assertSame(bi, otherBi);
        BigDecimal bd = BigDecimal.valueOf(new Random().nextDouble());
        map.put((Object)key, (Object)bd);
        BigDecimal otherBd = (BigDecimal)map.get((Object)key);
        this.assertSame(bd, otherBd);
        AsyncMapTest.SomeSerializableObject so = new AsyncMapTest.SomeSerializableObject(TestUtils.randomAlphaString(15));
        map.put((Object)key, (Object)so);
        AsyncMapTest.SomeSerializableObject otherSo = (AsyncMapTest.SomeSerializableObject)map.get((Object)key);
        this.assertEquals(so, otherSo);
        this.assertNotSame(so, otherSo);
        AsyncMapTest.SomeClusterSerializableObject cso = new AsyncMapTest.SomeClusterSerializableObject(TestUtils.randomAlphaString(15));
        map.put((Object)key, (Object)cso);
        AsyncMapTest.SomeClusterSerializableObject otherCso = (AsyncMapTest.SomeClusterSerializableObject)map.get((Object)key);
        this.assertEquals(cso, otherCso);
        this.assertNotSame(cso, otherCso);
    }

    @Test
    public void testKeys() {
        LocalMap map = this.sharedData.getLocalMap("foo");
        map.put((Object)"foo1", (Object)"val1");
        map.put((Object)"foo2", (Object)"val2");
        map.put((Object)"foo3", (Object)"val3");
        this.assertEquals(3L, map.size());
        Set keys = map.keySet();
        this.assertEquals(3L, keys.size());
        this.assertTrue(keys.contains("foo1"));
        this.assertTrue(keys.contains("foo2"));
        this.assertTrue(keys.contains("foo3"));
    }

    @Test
    public void testKeysCopied() {
        LocalMap map = this.sharedData.getLocalMap("foo");
        JsonObject json1 = new JsonObject().put("foo1", (Object)"val1");
        JsonObject json2 = new JsonObject().put("foo2", (Object)"val1");
        JsonObject json3 = new JsonObject().put("foo3", (Object)"val1");
        map.put((Object)json1, (Object)"val1");
        map.put((Object)json2, (Object)"val2");
        map.put((Object)json3, (Object)"val3");
        this.assertEquals(3L, map.size());
        Set keys = map.keySet();
        this.assertEquals(3L, keys.size());
        this.assertTrue(keys.contains(json1));
        this.assertTrue(keys.contains(json2));
        this.assertTrue(keys.contains(json3));
        this.assertFalse(this.containsExact(keys, json1));
        this.assertFalse(this.containsExact(keys, json2));
        this.assertFalse(this.containsExact(keys, json3));
    }

    private boolean containsExact(Collection<JsonObject> coll, JsonObject obj) {
        for (JsonObject j : coll) {
            if (j != obj) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testValues() {
        LocalMap map = this.sharedData.getLocalMap("foo");
        map.put((Object)"foo1", (Object)"val1");
        map.put((Object)"foo2", (Object)"val2");
        map.put((Object)"foo3", (Object)"val3");
        this.assertEquals(3L, map.size());
        Collection values = map.values();
        this.assertEquals(3L, values.size());
        this.assertTrue(values.contains("val1"));
        this.assertTrue(values.contains("val2"));
        this.assertTrue(values.contains("val3"));
    }

    @Test
    public void testValuesCopied() {
        LocalMap map = this.sharedData.getLocalMap("foo");
        JsonObject json1 = new JsonObject().put("foo1", (Object)"val1");
        JsonObject json2 = new JsonObject().put("foo2", (Object)"val1");
        JsonObject json3 = new JsonObject().put("foo3", (Object)"val1");
        map.put((Object)"key1", (Object)json1);
        map.put((Object)"key2", (Object)json2);
        map.put((Object)"key3", (Object)json3);
        this.assertEquals(3L, map.size());
        Collection values = map.values();
        this.assertEquals(3L, values.size());
        this.assertTrue(values.contains(json1));
        this.assertTrue(values.contains(json2));
        this.assertTrue(values.contains(json3));
        this.assertFalse(this.containsExact(values, json1));
        this.assertFalse(this.containsExact(values, json2));
        this.assertFalse(this.containsExact(values, json3));
    }

    @Test
    public void testCopyOnGet() {
        this.testMapOperationResult(LocalMap::get);
    }

    @Test
    public void testCopyOnPutIfAbsent() {
        this.testMapOperationResult((map, key) -> (ShareableObject)map.putIfAbsent(key, (Object)new ShareableObject("some other test data")));
    }

    @Test
    public void testCopyOnRemove() {
        this.testMapOperationResult(LocalMap::remove);
    }

    private void testMapOperationResult(BiFunction<LocalMap<String, ShareableObject>, String, ShareableObject> operation) {
        String key = "key";
        ShareableObject value = new ShareableObject("some test data");
        LocalMap map = this.vertx.sharedData().getLocalMap("foo");
        this.assertNull(map.put((Object)"key", (Object)value));
        ShareableObject result = operation.apply((LocalMap<String, ShareableObject>)map, "key");
        this.assertEquals(value, result);
        this.assertNotSame(value, result);
    }

    class SomeOtherClass {
        SomeOtherClass() {
        }
    }

    private static class ShareableObject
    implements Shareable {
        private final String data;

        public ShareableObject(String data) {
            this.data = data;
        }

        public Shareable copy() {
            return new ShareableObject(this.data);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShareableObject another = (ShareableObject)o;
            return this.data.equals(another.data);
        }

        public int hashCode() {
            return this.data.hashCode();
        }
    }
}

