/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.shareddata;

import io.vertx.core.Vertx;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import org.junit.Test;

public class SharedCounterTest
extends VertxTestBase {
    protected Vertx getVertx() {
        return this.vertx;
    }

    @Test
    public void testIllegalArguments() throws Exception {
        TestUtils.assertNullPointerException(() -> this.getVertx().sharedData().getCounter(null));
    }

    @Test
    public void testGet() {
        this.getVertx().sharedData().getCounter("foo").onComplete(this.onSuccess(counter -> counter.get().onComplete(this.onSuccess(res -> {
            this.assertEquals(0L, (long)res);
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testIncrementAndGet() {
        this.getVertx().sharedData().getCounter("foo").onComplete(this.onSuccess(counter -> counter.incrementAndGet().onComplete(this.onSuccess(res1 -> {
            this.assertEquals(1L, (long)res1);
            this.getVertx().sharedData().getCounter("foo").onComplete(this.onSuccess(counter2 -> counter2.incrementAndGet().onComplete(this.onSuccess(res2 -> {
                this.assertEquals(2L, (long)res2);
                this.testComplete();
            }))));
        }))));
        this.await();
    }

    @Test
    public void testGetAndIncrement() {
        this.getVertx().sharedData().getCounter("foo").onComplete(this.onSuccess(counter -> counter.getAndIncrement().onComplete(this.onSuccess(res -> {
            this.assertEquals(0L, (long)res);
            this.getVertx().sharedData().getCounter("foo").onComplete(this.onSuccess(counter2 -> counter2.getAndIncrement().onComplete(this.onSuccess(res2 -> {
                this.assertEquals(1L, (long)res2);
                counter2.get().onComplete(this.onSuccess(res3 -> {
                    this.assertEquals(2L, (long)res3);
                    this.testComplete();
                }));
            }))));
        }))));
        this.await();
    }

    @Test
    public void testDecrementAndGet() {
        this.getVertx().sharedData().getCounter("foo").onComplete(this.onSuccess(counter -> counter.decrementAndGet().onComplete(this.onSuccess(res -> {
            this.assertEquals(-1L, (long)res);
            this.getVertx().sharedData().getCounter("foo").onComplete(this.onSuccess(counter2 -> counter2.decrementAndGet().onComplete(this.onSuccess(res2 -> {
                this.assertEquals(-2L, (long)res2);
                this.testComplete();
            }))));
        }))));
        this.await();
    }

    @Test
    public void testAddAndGet() {
        this.getVertx().sharedData().getCounter("foo").onComplete(this.onSuccess(counter -> counter.addAndGet(2L).onComplete(this.onSuccess(res -> {
            this.assertEquals(2L, (long)res);
            this.getVertx().sharedData().getCounter("foo").onComplete(this.onSuccess(counter2 -> counter2.addAndGet(2L).onComplete(this.onSuccess(res2 -> {
                this.assertEquals(4L, (long)res2);
                this.testComplete();
            }))));
        }))));
        this.await();
    }

    @Test
    public void getAndAdd() {
        this.getVertx().sharedData().getCounter("foo").onComplete(this.onSuccess(counter -> counter.getAndAdd(2L).onComplete(this.onSuccess(res -> {
            this.assertEquals(0L, (long)res);
            this.getVertx().sharedData().getCounter("foo").onComplete(this.onSuccess(counter2 -> counter2.getAndAdd(2L).onComplete(this.onSuccess(res2 -> {
                this.assertEquals(2L, (long)res2);
                counter2.get().onComplete(this.onSuccess(res3 -> {
                    this.assertEquals(4L, (long)res3);
                    this.testComplete();
                }));
            }))));
        }))));
        this.await();
    }

    @Test
    public void testCompareAndSet() {
        this.getVertx().sharedData().getCounter("foo").onComplete(this.onSuccess(counter -> counter.compareAndSet(0L, 2L).onComplete(this.onSuccess(result -> this.getVertx().sharedData().getCounter("foo").onComplete(this.onSuccess(counter2 -> counter2.compareAndSet(2L, 4L).onComplete(this.onSuccess(result2 -> {
            this.assertTrue((boolean)result2);
            counter2.compareAndSet(3L, 5L).onComplete(this.onSuccess(result3 -> {
                this.assertFalse((boolean)result3);
                this.testComplete();
            }));
        }))))))));
        this.await();
    }

    @Test
    public void testDifferentCounters() {
        this.getVertx().sharedData().getCounter("foo").onComplete(this.onSuccess(counter -> counter.incrementAndGet().onComplete(this.onSuccess(res -> {
            this.assertEquals(1L, (long)res);
            this.getVertx().sharedData().getCounter("bar").onComplete(this.onSuccess(counter2 -> counter2.incrementAndGet().onComplete(this.onSuccess(res2 -> {
                this.assertEquals(1L, (long)res2);
                counter.incrementAndGet().onComplete(this.onSuccess(res3 -> {
                    this.assertEquals(2L, (long)res3);
                    this.testComplete();
                }));
            }))));
        }))));
        this.await();
    }
}

