/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.streams;

import io.vertx.core.Future;
import io.vertx.test.core.AsyncTestBase;
import io.vertx.test.fakestream.FakeStream;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.junit.Test;

public class ReadStreamReduceTest
extends AsyncTestBase {
    private FakeStream<Object> dst;
    private Object o1 = new Object();
    private Object o2 = new Object();
    private Object o3 = new Object();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.dst = new FakeStream();
    }

    @Test
    public void testCollect() {
        Future list = this.dst.collect(Collectors.toList());
        this.assertFalse(list.isComplete());
        this.dst.write(this.o1);
        this.assertFalse(list.isComplete());
        this.dst.write(this.o2);
        this.assertFalse(list.isComplete());
        this.dst.write(this.o3);
        this.dst.end();
        this.assertTrue(list.succeeded());
        this.assertEquals(Arrays.asList(this.o1, this.o2, this.o3), list.result());
    }

    @Test
    public void testFailure() {
        Future list = this.dst.collect(Collectors.toList());
        this.assertFalse(list.isComplete());
        this.dst.write(this.o1);
        this.assertFalse(list.isComplete());
        this.dst.write(this.o2);
        this.assertFalse(list.isComplete());
        Throwable err = new Throwable();
        this.dst.fail(err);
        this.assertTrue(list.failed());
        this.assertSame(err, list.cause());
    }
}

