/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.streams;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.streams.WriteStream;
import io.vertx.test.core.AsyncTestBase;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;

public class WriteStreamTest
extends AsyncTestBase {
    @Test
    public void testEndWithItemStreamAsync() {
        Object item = new Object();
        Throwable cause = new Throwable();
        EndWithItemStreamAsync src = new EndWithItemStreamAsync();
        Future resolvedFut = src.end(item);
        this.assertEquals(1L, src.writeCount.get());
        this.assertEquals(0L, src.endCount.get());
        this.assertFalse(resolvedFut.isComplete());
        src.writeFut.complete();
        this.assertEquals(1L, src.writeCount.get());
        this.assertEquals(1L, src.endCount.get());
        this.assertFalse(resolvedFut.isComplete());
        src.endFut.complete();
        this.assertEquals(1L, src.writeCount.get());
        this.assertEquals(1L, src.endCount.get());
        this.assertTrue(resolvedFut.succeeded());
        this.assertNull(resolvedFut.result());
        src = new EndWithItemStreamAsync();
        resolvedFut = src.end(item);
        src.writeFut.fail(cause);
        this.assertEquals(1L, src.writeCount.get());
        this.assertEquals(0L, src.endCount.get());
        this.assertTrue(resolvedFut.failed());
        this.assertSame(cause, resolvedFut.cause());
        src = new EndWithItemStreamAsync();
        resolvedFut = src.end(item);
        src.writeFut.complete();
        src.endFut.fail(cause);
        this.assertEquals(1L, src.writeCount.get());
        this.assertEquals(1L, src.endCount.get());
        this.assertTrue(resolvedFut.failed());
        this.assertSame(cause, resolvedFut.cause());
    }

    static class EndWithItemStreamAsync
    extends StreamBase<Object> {
        AtomicInteger writeCount = new AtomicInteger();
        Promise<Void> writeFut = Promise.promise();
        AtomicInteger endCount = new AtomicInteger();
        Promise<Void> endFut = Promise.promise();

        EndWithItemStreamAsync() {
        }

        @Override
        public Future<Void> write(Object data) {
            this.writeCount.incrementAndGet();
            return this.writeFut.future();
        }

        @Override
        public Future<Void> end() {
            this.endCount.incrementAndGet();
            return this.endFut.future();
        }
    }

    static class StreamBase<T>
    implements WriteStream<T> {
        StreamBase() {
        }

        public StreamBase<T> exceptionHandler(Handler<Throwable> handler) {
            throw new UnsupportedOperationException();
        }

        public Future<Void> write(T data) {
            throw new UnsupportedOperationException();
        }

        public StreamBase<T> setWriteQueueMaxSize(int maxSize) {
            throw new UnsupportedOperationException();
        }

        public boolean writeQueueFull() {
            throw new UnsupportedOperationException();
        }

        public StreamBase<T> drainHandler(@Nullable Handler<Void> handler) {
            throw new UnsupportedOperationException();
        }

        public Future<Void> end() {
            throw new UnsupportedOperationException();
        }
    }
}

