/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.tls;

import io.vertx.core.Expectation;
import io.vertx.core.Future;
import io.vertx.core.VertxOptions;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.http.HttpClientAgent;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpResponseExpectation;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.http.HttpTestBase;
import io.vertx.test.tls.Cert;
import org.junit.Test;

public class HttpHostnameVerificationTest
extends VertxTestBase {
    @Override
    protected VertxOptions getOptions() {
        return new VertxOptions(super.getOptions()).setAddressResolverOptions(new AddressResolverOptions().setHostsValue(Buffer.buffer((String)"127.0.0.1 example.com\n")));
    }

    @Test
    public void testDisableVerifyHost() throws Exception {
        HttpServer server = this.vertx.createHttpServer(new HttpServerOptions().setSsl(true).setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS.get()));
        server.requestHandler(req -> req.response().end("example.com"));
        this.awaitFuture(server.listen(HttpTestBase.DEFAULT_HTTPS_PORT, "localhost"));
        HttpClientAgent client = this.vertx.createHttpClient(new HttpClientOptions().setVerifyHost(false).setSsl(true).setTrustAll(true));
        RequestOptions options = new RequestOptions().setHost("example.com").setPort(Integer.valueOf(HttpTestBase.DEFAULT_HTTPS_PORT));
        Future response = client.request(options).compose(req -> req.send().expecting((Expectation)HttpResponseExpectation.SC_OK).compose(HttpClientResponse::body));
        this.assertEquals("example.com", ((Buffer)this.awaitFuture(response)).toString());
    }
}

