/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.tls;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslServerSessionContext;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.net.VertxSslContext;
import io.vertx.core.internal.tls.SslContextManager;
import io.vertx.core.internal.tls.SslContextProvider;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.tls.Cert;
import io.vertx.test.tls.Trust;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSessionContext;
import org.junit.Test;

public class SslContextManagerTest
extends VertxTestBase {
    @Test
    public void testUseJdkCiphersWhenNotSpecified() throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, null, null);
        SSLEngine engine = context.createSSLEngine();
        String[] expected = engine.getEnabledCipherSuites();
        SslContextManager helper = new SslContextManager(SslContextManager.resolveEngineOptions(null, (boolean)false));
        helper.buildSslContextProvider(new SSLOptions().setKeyCertOptions((KeyCertOptions)Cert.CLIENT_JKS.get()).setTrustOptions((TrustOptions)Trust.SERVER_JKS.get()), null, ClientAuth.NONE, null, false, (ContextInternal)this.vertx.getOrCreateContext()).onComplete(this.onSuccess(provider -> {
            VertxSslContext ctx = provider.createContext(false, false);
            this.assertEquals(new HashSet<String>(Arrays.asList(expected)), new HashSet(ctx.cipherSuites()));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testUseOpenSSLCiphersWhenNotSpecified() throws Exception {
        Set expected = OpenSsl.availableOpenSslCipherSuites();
        SslContextManager helper = new SslContextManager((SSLEngineOptions)new OpenSSLEngineOptions());
        helper.buildSslContextProvider(new SSLOptions().setKeyCertOptions((KeyCertOptions)Cert.CLIENT_PEM.get()).setTrustOptions((TrustOptions)Trust.SERVER_PEM.get()), null, ClientAuth.NONE, null, false, (ContextInternal)this.vertx.getOrCreateContext()).onComplete(this.onSuccess(provider -> {
            VertxSslContext ctx = provider.createContext(false, false);
            this.assertEquals(expected, new HashSet(ctx.cipherSuites()));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testDefaultOpenSslServerSessionContext() throws Exception {
        this.testOpenSslServerSessionContext(true);
    }

    @Test
    public void testUserSetOpenSslServerSessionContext() throws Exception {
        this.testOpenSslServerSessionContext(false);
    }

    private void testOpenSslServerSessionContext(boolean testDefault) {
        OpenSSLEngineOptions engineOptions = !testDefault ? new OpenSSLEngineOptions().setSessionCacheEnabled(false) : new OpenSSLEngineOptions();
        SslContextManager defaultHelper = new SslContextManager((SSLEngineOptions)engineOptions);
        SSLOptions sslOptions = new SSLOptions();
        sslOptions.setKeyCertOptions((KeyCertOptions)Cert.SERVER_PEM.get()).setTrustOptions((TrustOptions)Trust.SERVER_PEM.get());
        defaultHelper.buildSslContextProvider(sslOptions, null, ClientAuth.NONE, null, false, (ContextInternal)this.vertx.getOrCreateContext()).onComplete(this.onSuccess(provider -> {
            VertxSslContext ctx = provider.createContext(true, false);
            SSLSessionContext sslSessionContext = ctx.sessionContext();
            this.assertTrue(sslSessionContext instanceof OpenSslServerSessionContext);
            if (sslSessionContext instanceof OpenSslServerSessionContext) {
                this.assertEquals(testDefault, ((OpenSslServerSessionContext)sslSessionContext).isSessionCacheEnabled());
            }
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testPreserveEnabledCipherSuitesOrder() throws Exception {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, null, null);
        SSLEngine engine = context.createSSLEngine();
        SSLOptions options = new SSLOptions();
        for (String suite : engine.getEnabledCipherSuites()) {
            options.addEnabledCipherSuite(suite);
        }
        this.assertEquals(new ArrayList(options.getEnabledCipherSuites()), Arrays.asList(engine.getEnabledCipherSuites()));
        JsonObject json = options.toJson();
        this.assertEquals(new ArrayList(new HttpServerOptions(json).getEnabledCipherSuites()), Arrays.asList(engine.getEnabledCipherSuites()));
        SslContextManager helper = new SslContextManager(SslContextManager.resolveEngineOptions(null, (boolean)false));
        helper.buildSslContextProvider(options, null, ClientAuth.NONE, null, false, (ContextInternal)this.vertx.getOrCreateContext()).onComplete(this.onSuccess(sslContextProvider -> {
            this.assertEquals(new HashSet<String>(Arrays.asList(this.createEngine((SslContextProvider)sslContextProvider).getEnabledCipherSuites())), new HashSet<String>(Arrays.asList(engine.getEnabledCipherSuites())));
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testPreserveEnabledSecureTransportProtocolOrder() throws Exception {
        HttpServerOptions options = new HttpServerOptions();
        ArrayList<String> expectedProtocols = new ArrayList<String>(options.getEnabledSecureTransportProtocols());
        options.removeEnabledSecureTransportProtocol("TLSv1");
        options.addEnabledSecureTransportProtocol("SSLv3");
        expectedProtocols.remove("TLSv1");
        expectedProtocols.add("SSLv3");
        this.assertEquals(new ArrayList(options.getEnabledSecureTransportProtocols()), expectedProtocols);
        this.assertEquals(new ArrayList(new HttpServerOptions(options).getEnabledSecureTransportProtocols()), expectedProtocols);
        JsonObject json = options.toJson();
        this.assertEquals(new ArrayList(new HttpServerOptions(json).getEnabledSecureTransportProtocols()), expectedProtocols);
    }

    @Test
    public void testCache() throws Exception {
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        SslContextManager helper = new SslContextManager((SSLEngineOptions)new JdkSSLEngineOptions(), 4);
        SSLOptions options = new SSLOptions().setKeyCertOptions((KeyCertOptions)Cert.SERVER_JKS.get());
        SslContextProvider f1 = (SslContextProvider)this.awaitFuture(helper.resolveSslContextProvider(options, "", ClientAuth.NONE, null, ctx));
        SslContextProvider f2 = (SslContextProvider)this.awaitFuture(helper.resolveSslContextProvider(options, "", ClientAuth.NONE, null, ctx));
        this.assertSame(f1, f2);
        this.awaitFuture(helper.resolveSslContextProvider(new SSLOptions().setKeyCertOptions((KeyCertOptions)Cert.SERVER_PKCS12.get()), "", ClientAuth.NONE, null, ctx));
        this.awaitFuture(helper.resolveSslContextProvider(new SSLOptions().setKeyCertOptions((KeyCertOptions)Cert.SERVER_PEM.get()), "", ClientAuth.NONE, null, ctx));
        this.awaitFuture(helper.resolveSslContextProvider(new SSLOptions().setKeyCertOptions((KeyCertOptions)Cert.CLIENT_PEM.get()), "", ClientAuth.NONE, null, ctx));
        this.awaitFuture(helper.resolveSslContextProvider(new SSLOptions().setKeyCertOptions((KeyCertOptions)Cert.SNI_PEM.get()), "", ClientAuth.NONE, null, ctx));
        f2 = (SslContextProvider)this.awaitFuture(helper.resolveSslContextProvider(options, "", ClientAuth.NONE, null, ctx));
        this.assertNotSame(f1, f2);
    }

    @Test
    public void testDefaultVersions() {
        this.testTLSVersions(new SSLOptions(), engine -> {
            List<String> protocols = Arrays.asList(engine.getEnabledProtocols());
            this.assertEquals(2L, protocols.size());
            this.assertTrue(protocols.contains("TLSv1.2"));
            this.assertTrue(protocols.contains("TLSv1.3"));
        });
    }

    @Test
    public void testSetVersion() {
        this.testTLSVersions(new SSLOptions().setEnabledSecureTransportProtocols(new HashSet<String>(Arrays.asList("TLSv1.3"))), engine -> {
            List<String> protocols = Arrays.asList(engine.getEnabledProtocols());
            this.assertEquals(1L, protocols.size());
            this.assertTrue(protocols.contains("TLSv1.3"));
        });
    }

    @Test
    public void testSetVersions() {
        this.testTLSVersions(new SSLOptions().setEnabledSecureTransportProtocols(new HashSet<String>(Arrays.asList("TLSv1", "TLSv1.3"))), engine -> {
            List<String> protocols = Arrays.asList(engine.getEnabledProtocols());
            this.assertEquals(2L, protocols.size());
            this.assertTrue(protocols.contains("TLSv1"));
            this.assertTrue(protocols.contains("TLSv1.3"));
        });
    }

    private void testTLSVersions(SSLOptions options, Consumer<SSLEngine> check) {
        SslContextManager helper = new SslContextManager(SslContextManager.resolveEngineOptions(null, (boolean)false));
        helper.buildSslContextProvider(options, null, ClientAuth.NONE, null, false, (ContextInternal)this.vertx.getOrCreateContext()).onComplete(this.onSuccess(sslContextProvider -> {
            SSLEngine engine = this.createEngine((SslContextProvider)sslContextProvider);
            check.accept(engine);
            this.testComplete();
        }));
        this.await();
    }

    public SSLEngine createEngine(SslContextProvider provider) {
        return provider.createContext(false, false).newEngine(ByteBufAllocator.DEFAULT);
    }
}

