/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.tracing;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.spi.context.storage.ContextLocal;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.observability.HttpResponse;
import io.vertx.core.spi.tracing.SpanKind;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.test.core.ContextLocalHelper;
import io.vertx.test.http.HttpTestBase;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.junit.Test;

public abstract class HttpTracerTestBase
extends HttpTestBase {
    private VertxTracer tracer;
    private ContextLocal<Object> key;

    @Override
    public void setUp() throws Exception {
        this.key = ContextLocal.registerLocal(Object.class);
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        ContextLocalHelper.reset();
        super.tearDown();
    }

    @Override
    protected VertxTracer getTracer() {
        return this.tracer;
    }

    @Test
    public void testHttpServer() throws Exception {
        final Object val = new Object();
        final AtomicInteger seq = new AtomicInteger();
        this.setTracer(new VertxTracer(){

            public Object receiveRequest(Context context, SpanKind kind, TracingPolicy policy, Object request, String operation, Iterable headers, TagExtractor tagExtractor) {
                HttpTracerTestBase.this.assertNull(HttpTracerTestBase.this.key.get(context));
                HttpTracerTestBase.this.key.put(context, val);
                HttpTracerTestBase.this.assertTrue(seq.compareAndSet(0, 1));
                return request;
            }

            public void sendResponse(Context context, Object response, Object payload, Throwable failure, TagExtractor tagExtractor) {
                HttpTracerTestBase.this.assertTrue(seq.compareAndSet(1, 2));
                HttpTracerTestBase.this.assertNotNull(response);
                HttpTracerTestBase.this.assertTrue(response instanceof HttpServerResponse);
                HttpTracerTestBase.this.assertNull(failure);
                HttpTracerTestBase.this.assertSame(val, HttpTracerTestBase.this.key.get(context));
                HttpTracerTestBase.this.key.remove(context);
            }
        });
        CountDownLatch latch = new CountDownLatch(1);
        this.server.requestHandler(req -> {
            this.assertEquals(1L, seq.get());
            ContextInternal ctx = (ContextInternal)Vertx.currentContext();
            this.assertSame(val, this.key.get((Context)ctx));
            req.response().closeHandler(v -> {
                this.assertNull(this.key.get((Context)ctx));
                this.assertEquals(2L, seq.get());
            });
            req.response().end();
        }).listen(DEFAULT_HTTP_PORT, "localhost").onComplete(this.onSuccess(v -> latch.countDown()));
        this.awaitLatch(latch);
        this.client.request(HttpMethod.GET, DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(req -> req.send().onComplete(this.onSuccess(resp -> this.testComplete()))));
        this.await();
    }

    @Test
    public void testHttpServerError() throws Exception {
        this.waitFor(3);
        final Object val = new Object();
        final AtomicInteger seq = new AtomicInteger();
        this.setTracer(new VertxTracer(){

            public Object receiveRequest(Context context, SpanKind kind, TracingPolicy policy, Object request, String operation, Iterable headers, TagExtractor tagExtractor) {
                HttpTracerTestBase.this.assertNull(HttpTracerTestBase.this.key.get(context));
                HttpTracerTestBase.this.key.put(context, val);
                HttpTracerTestBase.this.assertTrue(seq.compareAndSet(0, 1));
                return request;
            }

            public void sendResponse(Context context, Object response, Object payload, Throwable failure, TagExtractor tagExtractor) {
                HttpTracerTestBase.this.assertTrue(seq.compareAndSet(1, 2));
                HttpTracerTestBase.this.assertNull(response);
                HttpTracerTestBase.this.assertNotNull(failure);
                HttpTracerTestBase.this.complete();
            }
        });
        CountDownLatch latch = new CountDownLatch(1);
        this.server.requestHandler(req -> {
            this.assertEquals(1L, seq.get());
            ContextInternal ctx = (ContextInternal)Vertx.currentContext();
            this.assertSame(val, this.key.get((Context)ctx));
            req.exceptionHandler(v -> this.complete());
        }).listen(DEFAULT_HTTP_PORT, "localhost").onComplete(this.onSuccess(v -> latch.countDown()));
        this.awaitLatch(latch);
        this.client.request(new RequestOptions().setPort(Integer.valueOf(DEFAULT_HTTP_PORT)).setHost("localhost").setURI("/")).onComplete(this.onSuccess(req -> {
            req.response().onComplete(this.onFailure(err -> this.complete()));
            req.setChunked(true).sendHead().onComplete(v -> req.connection().close());
        }));
        this.await();
    }

    @Test
    public void testHttpClientRequest() throws Exception {
        this.testHttpClientRequest(new RequestOptions().setPort(Integer.valueOf(DEFAULT_HTTP_PORT)).setHost("localhost").setURI("/"), "GET");
    }

    @Test
    public void testHttpClientRequestOverrideOperation() throws Exception {
        this.testHttpClientRequest(new RequestOptions().setPort(Integer.valueOf(DEFAULT_HTTP_PORT)).setHost("localhost").setURI("/").setTraceOperation("operation-override"), "operation-override");
    }

    private void testHttpClientRequest(RequestOptions request, final String expectedOperation) throws Exception {
        final Object val = new Object();
        final AtomicInteger seq = new AtomicInteger();
        final String traceId = UUID.randomUUID().toString();
        this.setTracer(new VertxTracer(){

            public Object sendRequest(Context context, SpanKind kind, TracingPolicy policy, Object request, String operation, BiConsumer headers, TagExtractor tagExtractor) {
                HttpTracerTestBase.this.assertSame(val, HttpTracerTestBase.this.key.get(context));
                HttpTracerTestBase.this.assertTrue(seq.compareAndSet(0, 1));
                headers.accept("X-B3-TraceId", traceId);
                HttpTracerTestBase.this.assertNotNull(request);
                HttpTracerTestBase.this.assertTrue(request instanceof HttpRequest);
                HttpTracerTestBase.this.assertEquals(expectedOperation, operation);
                return request;
            }

            public void receiveResponse(Context context, Object response, Object payload, Throwable failure, TagExtractor tagExtractor) {
                HttpTracerTestBase.this.assertSame(val, HttpTracerTestBase.this.key.get(context));
                HttpTracerTestBase.this.key.remove(context);
                HttpTracerTestBase.this.assertNotNull(response);
                HttpTracerTestBase.this.assertTrue(response instanceof HttpResponse);
                HttpTracerTestBase.this.assertNull(failure);
                HttpTracerTestBase.this.assertTrue(seq.compareAndSet(1, 2));
            }
        });
        CountDownLatch latch = new CountDownLatch(1);
        this.server.requestHandler(req -> {
            this.assertEquals(traceId, req.getHeader("X-B3-TraceId"));
            req.response().end();
        }).listen(DEFAULT_HTTP_PORT, "localhost").onComplete(this.onSuccess(v -> latch.countDown()));
        this.awaitLatch(latch);
        Context ctx = this.vertx.getOrCreateContext();
        ctx.runOnContext(v1 -> {
            this.key.put(ctx, val);
            this.client.request(request).onComplete(this.onSuccess(req -> req.send().onComplete(this.onSuccess(resp -> resp.endHandler(v2 -> ctx.runOnContext(v -> {
                this.assertNull(this.key.get(ctx));
                this.testComplete();
            }))))));
        });
        this.await();
    }

    @Test
    public void testHttpClientError() throws Exception {
        this.waitFor(2);
        final Object val = new Object();
        final AtomicInteger seq = new AtomicInteger();
        final String traceId = UUID.randomUUID().toString();
        this.setTracer(new VertxTracer(){

            public Object sendRequest(Context context, SpanKind kind, TracingPolicy policy, Object request, String operation, BiConsumer headers, TagExtractor tagExtractor) {
                HttpTracerTestBase.this.assertSame(val, HttpTracerTestBase.this.key.get(context));
                HttpTracerTestBase.this.assertTrue(seq.compareAndSet(0, 1));
                headers.accept("X-B3-TraceId", traceId);
                return request;
            }

            public void receiveResponse(Context context, Object response, Object payload, Throwable failure, TagExtractor tagExtractor) {
                HttpTracerTestBase.this.assertSame(val, HttpTracerTestBase.this.key.get(context));
                HttpTracerTestBase.this.key.remove(context);
                HttpTracerTestBase.this.assertNull(response);
                HttpTracerTestBase.this.assertNotNull(failure);
                HttpTracerTestBase.this.assertTrue(seq.compareAndSet(1, 2));
                HttpTracerTestBase.this.complete();
            }
        });
        CountDownLatch latch = new CountDownLatch(1);
        this.server.requestHandler(req -> {
            this.assertEquals(traceId, req.getHeader("X-B3-TraceId"));
            req.connection().close();
        }).listen(DEFAULT_HTTP_PORT, "localhost").onComplete(this.onSuccess(v -> latch.countDown()));
        this.awaitLatch(latch);
        Context ctx = this.vertx.getOrCreateContext();
        ctx.runOnContext(v1 -> {
            this.key.put(ctx, val);
            this.client.request(HttpMethod.GET, DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(req -> req.send().onComplete(this.onFailure(err -> this.complete()))));
        });
        this.await();
    }

    protected void setTracer(VertxTracer tracer) {
        this.server.close();
        this.tracer = tracer;
        this.vertx = this.vertx(this.getOptions());
        this.server = this.vertx.createHttpServer(this.createBaseServerOptions());
        this.client = this.vertx.createHttpClient(this.createBaseClientOptions());
    }
}

