/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.tracing;

import io.vertx.core.WorkerExecutor;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.faketracer.FakeTracer;
import org.junit.Test;

public class TracerTest
extends VertxTestBase {
    private FakeTracer tracer = new FakeTracer();

    @Override
    protected VertxTracer getTracer() {
        return this.tracer;
    }

    @Test
    public void testClose() throws Exception {
        this.assertEquals(0L, this.tracer.closeCount());
        this.awaitFuture(this.vertx.close());
        this.assertEquals(1L, this.tracer.closeCount());
    }

    @Test
    public void testWorkerExecutor() {
        WorkerExecutor exec = this.vertx.createSharedWorkerExecutor("exec");
        ContextInternal ctx = (ContextInternal)this.vertx.getOrCreateContext();
        ContextInternal duplicate = ctx.duplicate();
        duplicate.runOnContext(v -> exec.executeBlocking(() -> null).onComplete(this.onSuccess(res -> this.testComplete())));
        this.await();
    }
}

