/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.vertx;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Deployable;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Promise;
import io.vertx.core.ThreadingModel;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.threadchecker.BlockedThreadEvent;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Test;

public class BlockedThreadCheckerTest
extends VertxTestBase {
    private final List<BlockedThreadEvent> events = Collections.synchronizedList(new ArrayList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expectMessage(String poolName, long maxExecuteTime, TimeUnit maxExecuteTimeUnit) {
        ArrayList<BlockedThreadEvent> copy;
        List<BlockedThreadEvent> list = this.events;
        synchronized (list) {
            copy = new ArrayList<BlockedThreadEvent>(this.events);
        }
        boolean match = false;
        for (BlockedThreadEvent event : copy) {
            if (!event.thread().getName().startsWith(poolName) || event.maxExecTime() != maxExecuteTimeUnit.toNanos(maxExecuteTime)) continue;
            match = true;
            break;
        }
        this.assertTrue("Invalid events: " + String.valueOf(copy), match);
    }

    private void catchBlockedThreadEvents(Vertx vertx) {
        ((VertxInternal)vertx).blockedThreadChecker().setThreadBlockedHandler(event -> this.events.add((BlockedThreadEvent)event));
    }

    @Test
    public void testBlockCheckDefault() throws Exception {
        AbstractVerticle verticle = new AbstractVerticle(){

            public void start() throws InterruptedException {
                Thread.sleep(6000L);
                BlockedThreadCheckerTest.this.testComplete();
            }
        };
        this.catchBlockedThreadEvents(this.vertx);
        this.vertx.deployVerticle((Deployable)verticle);
        this.await();
        this.expectMessage("vert.x-eventloop-thread", VertxOptions.DEFAULT_MAX_EVENT_LOOP_EXECUTE_TIME, VertxOptions.DEFAULT_MAX_EVENT_LOOP_EXECUTE_TIME_UNIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockCheckExceptionTimeLimit() throws Exception {
        AbstractVerticle verticle = new AbstractVerticle(){

            public void start() throws InterruptedException {
                Thread.sleep(3000L);
                BlockedThreadCheckerTest.this.testComplete();
            }
        };
        long maxEventLoopExecuteTime = 1L;
        TimeUnit maxEventLoopExecuteTimeUnit = TimeUnit.SECONDS;
        VertxOptions vertxOptions = new VertxOptions();
        vertxOptions.setMaxEventLoopExecuteTime(maxEventLoopExecuteTime);
        vertxOptions.setMaxEventLoopExecuteTimeUnit(maxEventLoopExecuteTimeUnit);
        vertxOptions.setWarningExceptionTime(maxEventLoopExecuteTime);
        vertxOptions.setWarningExceptionTimeUnit(maxEventLoopExecuteTimeUnit);
        this.catchBlockedThreadEvents(newVertx);
        try (Vertx newVertx = this.vertx(vertxOptions);){
            newVertx.deployVerticle((Deployable)verticle);
            this.await();
            this.expectMessage("vert.x-eventloop-thread", maxEventLoopExecuteTime, maxEventLoopExecuteTimeUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockCheckWorker() throws Exception {
        AbstractVerticle verticle = new AbstractVerticle(){

            public void start() throws InterruptedException {
                Thread.sleep(3000L);
                BlockedThreadCheckerTest.this.testComplete();
            }
        };
        long maxWorkerExecuteTime = 1L;
        TimeUnit maxWorkerExecuteTimeUnit = TimeUnit.SECONDS;
        VertxOptions vertxOptions = new VertxOptions();
        vertxOptions.setMaxWorkerExecuteTime(maxWorkerExecuteTime);
        vertxOptions.setMaxWorkerExecuteTimeUnit(maxWorkerExecuteTimeUnit);
        vertxOptions.setWarningExceptionTime(maxWorkerExecuteTime);
        vertxOptions.setWarningExceptionTimeUnit(maxWorkerExecuteTimeUnit);
        try (Vertx newVertx = this.vertx(vertxOptions);){
            this.catchBlockedThreadEvents(newVertx);
            DeploymentOptions deploymentOptions = new DeploymentOptions();
            deploymentOptions.setThreadingModel(ThreadingModel.WORKER);
            newVertx.deployVerticle((Deployable)verticle, deploymentOptions);
            this.await();
            this.expectMessage("vert.x-worker-thread", maxWorkerExecuteTime, maxWorkerExecuteTimeUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockCheckExecuteBlocking() throws Exception {
        AbstractVerticle verticle = new AbstractVerticle(){

            public void start() throws InterruptedException {
                this.vertx.executeBlocking(() -> {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        BlockedThreadCheckerTest.this.fail();
                    }
                    BlockedThreadCheckerTest.this.testComplete();
                    return null;
                });
            }
        };
        long maxWorkerExecuteTime = 1L;
        TimeUnit maxWorkerExecuteTimeUnit = TimeUnit.SECONDS;
        VertxOptions vertxOptions = new VertxOptions();
        vertxOptions.setMaxWorkerExecuteTime(maxWorkerExecuteTime);
        vertxOptions.setMaxWorkerExecuteTimeUnit(maxWorkerExecuteTimeUnit);
        vertxOptions.setWarningExceptionTime(maxWorkerExecuteTime);
        vertxOptions.setWarningExceptionTimeUnit(maxWorkerExecuteTimeUnit);
        this.catchBlockedThreadEvents(newVertx);
        try (Vertx newVertx = this.vertx(vertxOptions);){
            newVertx.deployVerticle((Deployable)verticle);
            this.await();
            this.expectMessage("vert.x-worker-thread", maxWorkerExecuteTime, maxWorkerExecuteTimeUnit);
        }
    }

    @Test
    public void testNamedWorkerPoolMaxExecuteWorkerTime() {
        String poolName = TestUtils.randomAlphaString(10);
        long maxWorkerExecuteTime = TimeUnit.NANOSECONDS.convert(3L, TimeUnit.SECONDS);
        DeploymentOptions deploymentOptions = new DeploymentOptions().setWorkerPoolName(poolName).setMaxWorkerExecuteTime(maxWorkerExecuteTime);
        this.catchBlockedThreadEvents(this.vertx);
        this.vertx.deployVerticle((Deployable)new AbstractVerticle(){

            public void start(Promise<Void> startPromise) throws Exception {
                this.vertx.executeBlocking(() -> {
                    TimeUnit.SECONDS.sleep(5L);
                    return null;
                }).onComplete(startPromise);
            }
        }, deploymentOptions).onComplete(this.onSuccess(did -> this.testComplete()));
        this.await();
        this.expectMessage(poolName, maxWorkerExecuteTime, TimeUnit.NANOSECONDS);
    }

    @Test
    public void testCustomThreadBlockedHandler() throws Exception {
        this.disableThreadChecks();
        this.waitFor(2);
        AbstractVerticle verticle = new AbstractVerticle(){

            public void start() throws InterruptedException {
                Thread.sleep(3000L);
                BlockedThreadCheckerTest.this.complete();
            }
        };
        long maxWorkerExecuteTime = 1000L;
        long warningExceptionTime = 2L;
        TimeUnit maxWorkerExecuteTimeUnit = TimeUnit.MILLISECONDS;
        TimeUnit warningExceptionTimeUnit = TimeUnit.SECONDS;
        VertxOptions vertxOptions = new VertxOptions();
        vertxOptions.setMaxWorkerExecuteTime(maxWorkerExecuteTime);
        vertxOptions.setMaxWorkerExecuteTimeUnit(maxWorkerExecuteTimeUnit);
        vertxOptions.setWarningExceptionTime(warningExceptionTime);
        vertxOptions.setWarningExceptionTimeUnit(warningExceptionTimeUnit);
        Vertx newVertx = this.vertx(vertxOptions);
        ((VertxInternal)newVertx).blockedThreadChecker().setThreadBlockedHandler(bte -> {
            this.assertEquals(TimeUnit.NANOSECONDS.convert(maxWorkerExecuteTime, maxWorkerExecuteTimeUnit), bte.maxExecTime());
            this.assertEquals(TimeUnit.NANOSECONDS.convert(warningExceptionTime, warningExceptionTimeUnit), bte.warningExceptionTime());
            this.complete();
        });
        DeploymentOptions deploymentOptions = new DeploymentOptions();
        deploymentOptions.setThreadingModel(ThreadingModel.WORKER);
        newVertx.deployVerticle((Deployable)verticle, deploymentOptions);
        this.await();
    }
}

