/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.vertx;

import io.vertx.core.Closeable;
import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.internal.CloseFuture;
import io.vertx.test.core.AsyncTestBase;
import io.vertx.tests.vertx.VertxTest;
import java.lang.ref.Cleaner;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

public class CloseFutureTest
extends AsyncTestBase {
    private static final Cleaner cleaner = Cleaner.create();
    private static final ThreadLocal<Object> closing = new ThreadLocal();

    @Test
    public void testHookCompletion() {
        CloseFuture cf = new CloseFuture();
        AtomicReference ref = new AtomicReference();
        cf.add(completion -> ref.set(completion));
        this.assertFalse(cf.close().succeeded());
        this.assertNotNull(ref.get());
        ((Completable)ref.get()).succeed();
        this.assertTrue(cf.close().succeeded());
    }

    @Test
    public void testRemoveDisposedCloseFutureHook() {
        CloseFuture cf = new CloseFuture();
        CloseFuture hook = new CloseFuture();
        cf.add((Closeable)hook);
        this.assertTrue(hook.close().succeeded());
        cf.close();
        this.assertFalse(cf.remove((Closeable)hook));
    }

    @Test
    public void testCloseFutureDuplicateClose() {
        AtomicReference ref = new AtomicReference();
        CloseFuture fut = new CloseFuture();
        fut.add(newValue -> ref.set(newValue));
        Promise p1 = Promise.promise();
        fut.close((Completable)p1);
        this.assertNotNull(ref.get());
        Promise p2 = Promise.promise();
        fut.close((Completable)p2);
        this.assertFalse(p1.future().isComplete());
        this.assertFalse(p2.future().isComplete());
        ((Completable)ref.get()).succeed();
        this.assertTrue(p1.future().isComplete());
        this.assertTrue(p2.future().isComplete());
    }

    @Test
    public void testCloseHook() {
        CloseFuture cf = new CloseFuture();
        CloseFuture hook = new CloseFuture();
        cf.add((Closeable)hook);
        hook.close();
        this.assertFalse(cf.remove((Closeable)hook));
        this.assertTrue(cf.close().succeeded());
    }

    @Test
    public void testUseCaseGC() {
        UseCaseResource resource = new UseCaseResource();
        CleanableUseCase cleanable = new CleanableUseCase(resource);
        WeakReference<CleanableUseCase> ref = new WeakReference<CleanableUseCase>(cleanable);
        CloseFuture owner = new CloseFuture();
        owner.add((Closeable)resource);
        cleanable = null;
        long now = System.currentTimeMillis();
        do {
            this.assertTrue(System.currentTimeMillis() - now < 20000L);
            VertxTest.runGC();
        } while (ref.get() != null || !resource.closed.get());
    }

    @Test
    public void testUseCaseClose() {
        UseCaseResource resource = new UseCaseResource();
        CleanableUseCase cleanable = new CleanableUseCase(resource);
        CloseFuture owner = new CloseFuture();
        owner.add((Closeable)resource);
        cleanable.close();
    }

    @Test
    public void testDetachFromCloseFutureOnCompletion() {
        CloseFuture closeFuture = new CloseFuture();
        CloseFuture nested = new CloseFuture();
        closeFuture.add((Closeable)nested);
        nested.close();
        this.assertFalse(closeFuture.remove((Closeable)nested));
    }

    private static class UseCaseResource
    implements Closeable,
    UseCase {
        private CloseFuture closeFuture = new CloseFuture();
        private AtomicBoolean closed = new AtomicBoolean();

        private UseCaseResource() {
        }

        public void close(Completable<Void> completion) {
            this.closed.set(true);
            completion.succeed();
        }

        @Override
        public Future<Void> close() {
            throw new UnsupportedOperationException();
        }
    }

    private static class CleanableUseCase
    implements UseCase {
        private UseCaseResource resource;
        private Cleaner.Cleanable cleanable = cleaner.register(this, () -> {
            boolean blocking;
            boolean bl = blocking = closing.get() == null;
            if (blocking) {
                Promise promise = Promise.promise();
                resource.close((Completable<Void>)promise);
            } else {
                resource.close((Completable<Void>)Promise.promise());
            }
        });

        public CleanableUseCase(UseCaseResource resource) {
            this.resource = resource;
        }

        @Override
        public Future<Void> close() {
            closing.set(true);
            try {
                this.cleanable.clean();
            }
            finally {
                closing.set(false);
            }
            return this.resource.closeFuture.future();
        }
    }

    private static interface UseCase {
        public Future<Void> close();
    }
}

