/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.vertx;

import io.vertx.core.Closeable;
import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.internal.CloseFuture;
import io.vertx.core.internal.CloseSequence;
import io.vertx.test.core.AsyncTestBase;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Before;
import org.junit.Test;

public class CloseSequenceTest
extends AsyncTestBase {
    private AtomicReference<Completable<Void>> ref1;
    private AtomicReference<Completable<Void>> ref2;
    private AtomicReference<Completable<Void>> ref3;
    private CloseSequence seq;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.ref1 = new AtomicReference();
        this.ref2 = new AtomicReference();
        this.ref3 = new AtomicReference();
        this.seq = new CloseSequence(new Closeable[]{newValue -> this.ref3.set((Completable<Void>)newValue), newValue1 -> this.ref2.set((Completable<Void>)newValue1), newValue2 -> this.ref1.set((Completable<Void>)newValue2)});
    }

    @Test
    public void testCompletion() {
        Future f1 = this.seq.progressTo(2);
        this.assertFalse(f1.isComplete());
        this.assertNotNull(this.ref1.get());
        this.assertNull(this.ref2.get());
        this.assertNull(this.ref3.get());
        this.ref1.get().succeed();
        this.assertTrue(f1.succeeded());
        this.assertNotNull(this.ref1.get());
        this.assertNull(this.ref2.get());
        this.assertNull(this.ref3.get());
        Future f2 = this.seq.progressTo(1);
        this.assertFalse(f2.isComplete());
        this.assertNotNull(this.ref1.get());
        this.assertNotNull(this.ref2.get());
        this.assertNull(this.ref3.get());
        this.ref2.get().succeed();
        this.assertTrue(f2.succeeded());
        this.assertNotNull(this.ref1.get());
        this.assertNotNull(this.ref2.get());
        this.assertNull(this.ref3.get());
        Future f3 = this.seq.progressTo(0);
        this.assertFalse(f3.isComplete());
        this.assertNotNull(this.ref1.get());
        this.assertNotNull(this.ref2.get());
        this.assertNotNull(this.ref3.get());
        this.ref3.get().succeed();
        this.assertTrue(f3.succeeded());
        this.assertNotNull(this.ref1.get());
        this.assertNotNull(this.ref2.get());
        this.assertNotNull(this.ref3.get());
    }

    @Test
    public void testCompletion2() {
        Future fut2 = this.seq.progressTo(1);
        this.assertFalse(fut2.isComplete());
        this.assertNotNull(this.ref1.get());
        this.assertNull(this.ref2.get());
        this.assertNull(this.ref3.get());
        this.ref1.get().succeed();
        this.assertFalse(fut2.isComplete());
        this.assertNotNull(this.ref1.get());
        this.assertNotNull(this.ref2.get());
        this.assertNull(this.ref3.get());
        this.ref2.get().succeed();
        this.assertTrue(fut2.isComplete());
        this.assertNotNull(this.ref1.get());
        this.assertNotNull(this.ref2.get());
        this.assertNull(this.ref3.get());
    }

    @Test
    public void testConcurrent() {
        Future fut1 = this.seq.progressTo(2);
        Future fut2 = this.seq.progressTo(1);
        this.assertFalse(fut1.isComplete());
        this.assertFalse(fut2.isComplete());
        this.assertNotNull(this.ref1.get());
        this.assertNull(this.ref2.get());
        this.assertNull(this.ref3.get());
        this.ref1.get().succeed();
        this.assertTrue(fut1.isComplete());
        this.assertFalse(fut2.isComplete());
        this.assertNotNull(this.ref1.get());
        this.assertNotNull(this.ref2.get());
        this.assertNull(this.ref3.get());
        this.ref2.get().succeed();
        this.assertTrue(fut1.isComplete());
        this.assertTrue(fut2.isComplete());
        this.assertNotNull(this.ref1.get());
        this.assertNotNull(this.ref2.get());
        this.assertNull(this.ref3.get());
    }

    @Test
    public void testDetachFromCloseFutureOnCompletion() {
        CloseFuture closeFuture = new CloseFuture();
        closeFuture.add((Closeable)this.seq);
        this.seq.close();
        this.ref1.get().succeed();
        this.ref2.get().succeed();
        this.ref3.get().succeed();
        this.assertFalse(closeFuture.remove((Closeable)this.seq));
    }
}

