/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.vertx;

import io.vertx.core.impl.cpu.CpuCoreSensor;
import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class CpuCoreSensorTest {
    @Test
    public void readRegular() throws Exception {
        File file = new File("src/test/resources/cpus/status-1.txt");
        Assert.assertThat((Object)CpuCoreSensor.readCPUMask((File)file), (Matcher)Is.is((Object)1));
    }

    @Test
    public void readRegular2() throws Exception {
        File file = new File("src/test/resources/cpus/status-2.txt");
        Assert.assertThat((Object)CpuCoreSensor.readCPUMask((File)file), (Matcher)Is.is((Object)2));
    }

    @Test
    public void readMissingFile() throws Exception {
        File file = new File("src/test/resources/cpus/does-not-exist");
        Assert.assertThat((Object)CpuCoreSensor.readCPUMask((File)file), (Matcher)Is.is((Object)-1));
    }

    @Test
    public void readMissingEntry() throws Exception {
        File file = new File("src/test/resources/cpus/missing.txt");
        Assert.assertThat((Object)CpuCoreSensor.readCPUMask((File)file), (Matcher)Is.is((Object)-1));
    }

    @Test
    public void readCorruptedFile() throws Exception {
        File file = new File("src/test/resources/cpus/corrupted.txt");
        Assert.assertThat((Object)CpuCoreSensor.readCPUMask((File)file), (Matcher)Is.is((Object)-1));
    }
}

