/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.vertx;

import io.vertx.core.Completable;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.test.core.VertxTestBase;
import io.vertx.test.fakecluster.FakeClusterManager;
import org.junit.Test;

public class CreateVertxTest
extends VertxTestBase {
    @Test
    public void testCreateSimpleVertx() {
        Vertx vertx = this.vertx();
        this.assertNotNull(vertx);
    }

    @Test
    public void testCreateVertxWithOptions() {
        VertxOptions options = new VertxOptions();
        Vertx vertx = this.vertx(options);
        this.assertNotNull(vertx);
        this.assertFalse(vertx.isClustered());
    }

    @Test
    public void testCreateClusteredVertxAsync() {
        VertxOptions options = new VertxOptions();
        this.clusteredVertx(options).compose(v -> {
            this.assertTrue(v.isClustered());
            return v.close();
        }).await();
    }

    @Test
    public void testCreateClusteredVertxAsyncDetectJoinFailure() {
        FakeClusterManager clusterManager = new FakeClusterManager(){

            @Override
            public void join(Completable<Void> promise) {
                promise.fail("joinfailure");
            }
        };
        try {
            this.clusteredVertx(new VertxOptions(), clusterManager).await();
        }
        catch (Throwable e) {
            this.assertEquals("joinfailure", e.getMessage());
            return;
        }
        this.fail();
    }
}

