/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.vertx;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ServerChannel;
import io.vertx.core.Vertx;
import io.vertx.core.impl.transports.NioTransport;
import io.vertx.core.internal.VertxBootstrap;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import io.vertx.core.spi.transport.Transport;
import io.vertx.test.core.AsyncTestBase;
import io.vertx.test.http.HttpTestBase;
import java.util.concurrent.CountDownLatch;
import org.junit.After;
import org.junit.Test;

public class GlobalEventExecutorNotificationTest
extends AsyncTestBase {
    private Vertx vertx;

    @Override
    @After
    public void after() throws Exception {
        if (this.vertx != null) {
            CountDownLatch latch = new CountDownLatch(1);
            this.vertx.close().onComplete(v -> latch.countDown());
            this.awaitLatch(latch);
        }
    }

    @Test
    public void testConnectError() {
        this.testConnectErrorNotifiesOnEventLoop(new NetClientOptions());
    }

    @Test
    public void testProxyConnectError() {
        this.testConnectErrorNotifiesOnEventLoop(new NetClientOptions().setProxyOptions(new ProxyOptions().setPort(1234).setType(ProxyType.SOCKS5).setHost("localhost")));
    }

    private void testConnectErrorNotifiesOnEventLoop(NetClientOptions options) {
        final RuntimeException cause = new RuntimeException();
        this.vertx = VertxBootstrap.create().transport((Transport)new NioTransport(){

            public ChannelFactory<? extends Channel> channelFactory(boolean domainSocket) {
                return () -> {
                    throw cause;
                };
            }
        }).init().vertx();
        this.vertx.createNetServer().connectHandler(so -> this.fail()).listen(1234, "localhost").onComplete(this.onSuccess(v -> this.vertx.createNetClient(options).connect(1234, "localhost").onComplete(this.onFailure(err -> {
            this.assertSame(err, cause);
            this.testComplete();
        }))));
        this.await();
    }

    @Test
    public void testNetBindError() {
        final RuntimeException cause = new RuntimeException();
        this.vertx = VertxBootstrap.create().transport((Transport)new NioTransport(){

            public ChannelFactory<? extends ServerChannel> serverChannelFactory(boolean domainSocket) {
                return () -> {
                    throw cause;
                };
            }
        }).init().vertx();
        this.vertx.createNetServer().connectHandler(so -> this.fail()).listen(1234, "localhost").onComplete(this.onFailure(err -> this.testComplete()));
        this.await();
    }

    @Test
    public void testHttpBindError() {
        final RuntimeException cause = new RuntimeException();
        this.vertx = VertxBootstrap.create().transport((Transport)new NioTransport(){

            public ChannelFactory<? extends ServerChannel> serverChannelFactory(boolean domainSocket) {
                return () -> {
                    throw cause;
                };
            }
        }).init().vertx();
        this.vertx.createHttpServer().requestHandler(req -> this.fail()).listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost").onComplete(this.onFailure(err -> this.testComplete()));
        this.await();
    }
}

