/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.vertx;

import io.vertx.core.impl.ThreadPerTaskExecutorService;
import io.vertx.test.core.AsyncTestBase;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;

public class ThreadPerTaskExecutorServiceTest
extends AsyncTestBase {
    @Test
    public void testExecute() throws Exception {
        ThreadPerTaskExecutorService exec = new ThreadPerTaskExecutorService(Executors.defaultThreadFactory());
        int numTasks = 100;
        Set threads = Collections.synchronizedSet(new HashSet());
        for (int i = 0; i < numTasks; ++i) {
            exec.execute(() -> threads.add(Thread.currentThread()));
        }
        exec.shutdown();
        exec.awaitTermination(5L, TimeUnit.SECONDS);
        this.assertEquals(numTasks, threads.size());
    }

    @Test
    public void testShutdown() throws Exception {
        ThreadPerTaskExecutorService exec = new ThreadPerTaskExecutorService(Executors.defaultThreadFactory());
        int numTasks = 10;
        CountDownLatch latch = new CountDownLatch(1);
        CyclicBarrier barrier = new CyclicBarrier(numTasks + 1);
        for (int i = 0; i < numTasks; ++i) {
            exec.execute(() -> {
                try {
                    barrier.await();
                    latch.await();
                }
                catch (Exception e) {
                    this.fail(e);
                }
            });
        }
        barrier.await();
        exec.shutdown();
        latch.countDown();
        long now = System.currentTimeMillis();
        exec.awaitTermination(5L, TimeUnit.SECONDS);
        this.assertTrue(System.currentTimeMillis() - now < 1000L);
    }

    @Test
    public void testShutdownEmpty() throws Exception {
        ThreadPerTaskExecutorService exec = new ThreadPerTaskExecutorService(Executors.defaultThreadFactory());
        exec.shutdown();
        long now = System.currentTimeMillis();
        exec.awaitTermination(5L, TimeUnit.SECONDS);
        this.assertTrue(System.currentTimeMillis() - now < 1000L);
    }

    @Test
    public void testInterrupt() throws Exception {
        ThreadPerTaskExecutorService exec = new ThreadPerTaskExecutorService(Executors.defaultThreadFactory());
        int numTasks = 100;
        CyclicBarrier barrier = new CyclicBarrier(numTasks + 1);
        CountDownLatch latch = new CountDownLatch(1);
        AtomicInteger interrupts = new AtomicInteger();
        for (int i = 0; i < numTasks; ++i) {
            exec.execute(() -> {
                try {
                    barrier.await();
                    latch.await();
                }
                catch (InterruptedException e) {
                    interrupts.incrementAndGet();
                }
                catch (BrokenBarrierException e) {
                    this.fail(e);
                }
            });
        }
        barrier.await();
        exec.shutdownNow();
        exec.awaitTermination(5L, TimeUnit.SECONDS);
        this.assertEquals(numTasks, interrupts.get());
    }
}

