/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.vertx;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.impl.transports.NioTransport;
import io.vertx.core.internal.VertxBootstrap;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.spi.ExecutorServiceFactory;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.VertxThreadFactory;
import io.vertx.core.spi.VertxTracerFactory;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.transport.Transport;
import io.vertx.core.tracing.TracingOptions;
import io.vertx.test.fakecluster.FakeClusterManager;
import io.vertx.test.fakemetrics.FakeVertxMetrics;
import io.vertx.test.faketracer.FakeTracer;
import io.vertx.test.faketracer.FakeTracerFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import junit.framework.AssertionFailedError;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class VertxBootstrapTest {
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();

    @Test
    public void testCreate() {
        VertxBootstrap factory = VertxBootstrap.create().init();
        Vertx vertx = factory.init().vertx();
        Assert.assertNotNull((Object)vertx);
    }

    @Test
    public void testCreateClustered() throws Exception {
        VertxBootstrap factory = VertxBootstrap.create().init();
        CompletableFuture fut = new CompletableFuture();
        factory.init();
        factory.clusterManager((ClusterManager)new FakeClusterManager());
        factory.clusteredVertx().onComplete(ar -> {
            if (ar.succeeded()) {
                fut.complete((Vertx)ar.result());
            } else {
                fut.completeExceptionally(ar.cause());
            }
        });
        Vertx vertx = (Vertx)fut.get(10L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)vertx);
        Assert.assertNotNull((Object)((VertxInternal)vertx).clusterManager());
    }

    @Test
    public void testFactoryMetricsOverridesMetaInf() {
        this.runWithServiceFromMetaInf(VertxMetricsFactory.class, FakeVertxMetrics.class.getName(), () -> {
            FakeVertxMetrics metrics = new FakeVertxMetrics();
            MetricsOptions metricsOptions = new MetricsOptions().setEnabled(true);
            VertxBootstrap factory = VertxBootstrap.create().options(new VertxOptions().setMetricsOptions(metricsOptions));
            factory.metricsFactory(options -> metrics);
            factory.init();
            Vertx vertx = factory.vertx();
            Assert.assertSame((Object)metrics, (Object)((VertxInternal)vertx).metrics());
        });
    }

    @Test
    public void testFactoryTracerOverridesMetaInf() {
        this.runWithServiceFromMetaInf(VertxTracerFactory.class, FakeTracerFactory.class.getName(), () -> {
            FakeTracer tracer = new FakeTracer();
            TracingOptions tracingOptions = new TracingOptions();
            VertxBootstrap factory = VertxBootstrap.create().options(new VertxOptions().setTracingOptions(tracingOptions));
            factory.tracerFactory(options -> tracer);
            factory.init();
            Vertx vertx = factory.vertx();
            Assert.assertSame((Object)tracer, (Object)((VertxInternal)vertx).getOrCreateContext().tracer());
        });
    }

    @Test
    public void testFactoryClusterManagerOverridesMetaInf() throws Exception {
        FakeClusterManager clusterManager = new FakeClusterManager();
        CompletableFuture res = new CompletableFuture();
        this.runWithServiceFromMetaInf(ClusterManager.class, FakeClusterManager.class.getName(), () -> {
            VertxBootstrap factory = VertxBootstrap.create().options(new VertxOptions());
            factory.clusterManager((ClusterManager)clusterManager);
            factory.init();
            factory.clusteredVertx().onComplete(ar -> {
                if (ar.succeeded()) {
                    res.complete((Vertx)ar.result());
                } else {
                    res.completeExceptionally(ar.cause());
                }
            });
        });
        Vertx vertx = (Vertx)res.get(10L, TimeUnit.SECONDS);
        Assert.assertSame((Object)clusterManager, (Object)((VertxInternal)vertx).clusterManager());
    }

    @Test
    public void testFactoryTransportOverridesDefault() {
        VertxBootstrap factory = VertxBootstrap.create();
        NioTransport override = new NioTransport(){};
        factory.transport((Transport)override);
        factory.init();
        Vertx vertx = factory.vertx();
        Assert.assertSame((Object)override, (Object)((VertxInternal)vertx).transport());
    }

    @Test
    public void testThatThreadFactoryCanCreateThreadsDuringTheirInitialization() {
        VertxBootstrap factory = VertxBootstrap.create();
        VertxThreadFactory tf = new VertxThreadFactory(){

            public VertxThread newVertxThread(Runnable target, String name, boolean worker, long maxExecTime, TimeUnit maxExecTimeUnit) {
                return VertxThreadFactory.INSTANCE.newVertxThread(target, name, worker, maxExecTime, maxExecTimeUnit);
            }
        };
        factory.threadFactory(tf).executorServiceFactory((ExecutorServiceFactory)new CustomExecutorServiceFactory()).init().vertx().close().await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithServiceFromMetaInf(Class<?> service, String implementationName, Runnable runnable) {
        URLClassLoader classLoader;
        try {
            File dir = new File(this.testFolder.newFolder("META-INF"), "services");
            dir.mkdirs();
            Assert.assertTrue((boolean)dir.exists());
            File desc = new File(dir, service.getName());
            Files.write(desc.toPath(), implementationName.getBytes(), new OpenOption[0]);
            Assert.assertTrue((boolean)desc.exists());
            classLoader = new URLClassLoader(new URL[]{this.testFolder.getRoot().toURI().toURL()});
        }
        catch (IOException e) {
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause((Throwable)e);
            throw afe;
        }
        Thread thread = Thread.currentThread();
        ClassLoader prev = thread.getContextClassLoader();
        thread.setContextClassLoader(classLoader);
        try {
            runnable.run();
        }
        finally {
            thread.setContextClassLoader(prev);
        }
    }

    private class CustomExecutorServiceFactory
    implements ExecutorServiceFactory {
        private CustomExecutorServiceFactory() {
        }

        public ExecutorService createExecutor(ThreadFactory threadFactory, Integer concurrency, Integer maxConcurrency) {
            threadFactory.newThread(() -> {});
            return Executors.newCachedThreadPool();
        }
    }
}

