/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tests.vertx;

import io.vertx.core.Closeable;
import io.vertx.core.Completable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.http.HttpClientAgent;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.PoolOptions;
import io.vertx.core.http.impl.CleanableHttpClient;
import io.vertx.core.internal.CloseFuture;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.net.NetSocketInternal;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.CleanableNetClient;
import io.vertx.test.core.AsyncTestBase;
import io.vertx.test.core.Repeat;
import io.vertx.test.core.RepeatRule;
import io.vertx.test.http.HttpTestBase;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Rule;
import org.junit.Test;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class VertxTest
extends AsyncTestBase {
    private static final Runner RUNNER = new Runner(new OptionsBuilder().shouldDoGC(true).build());
    @Rule
    public RepeatRule repeatRule = new RepeatRule();

    public static void runGC() {
        RUNNER.runSystemGC();
    }

    @Test
    public void testCloseHooksCalled() {
        AtomicInteger closedCount = new AtomicInteger();
        Closeable myCloseable1 = completionHandler -> {
            closedCount.incrementAndGet();
            completionHandler.succeed();
        };
        Closeable myCloseable2 = completionHandler -> {
            closedCount.incrementAndGet();
            completionHandler.succeed();
        };
        VertxInternal vertx = (VertxInternal)Vertx.vertx();
        vertx.addCloseHook(myCloseable1);
        vertx.addCloseHook(myCloseable2);
        vertx.close().onComplete(this.onSuccess(v -> {
            this.assertEquals(2L, closedCount.get());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testCloseHookFailure1() {
        final AtomicInteger closedCount = new AtomicInteger();
        VertxInternal vertx = (VertxInternal)Vertx.vertx();
        class Hook
        implements Closeable {
            Hook() {
            }

            public void close(Completable<Void> completion) {
                if (closedCount.incrementAndGet() == 1) {
                    throw new RuntimeException("Don't be afraid");
                }
                completion.succeed();
            }
        }
        vertx.addCloseHook((Closeable)new Hook());
        vertx.addCloseHook((Closeable)new Hook());
        vertx.close().onComplete(this.onSuccess(v -> {
            this.assertEquals(2L, closedCount.get());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testCloseHookFailure2() throws Exception {
        final AtomicInteger closedCount = new AtomicInteger();
        VertxInternal vertx = (VertxInternal)Vertx.vertx();
        class Hook
        implements Closeable {
            Hook() {
            }

            public void close(Completable<Void> completion) {
                if (closedCount.incrementAndGet() == 1) {
                    completion.succeed();
                    throw new RuntimeException();
                }
                completion.succeed();
            }
        }
        vertx.addCloseHook((Closeable)new Hook());
        vertx.addCloseHook((Closeable)new Hook());
        vertx.close().onComplete(this.onSuccess(v -> {
            this.assertEquals(2L, closedCount.get());
            this.testComplete();
        }));
        this.await();
    }

    @Test
    public void testCloseFuture() {
        Vertx vertx = Vertx.vertx();
        Future fut = vertx.close();
        fut.onComplete(this.onSuccess(v -> this.testComplete()));
        this.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFinalizeHttpClient() throws Exception {
        VertxInternal vertx = (VertxInternal)Vertx.vertx();
        try {
            AtomicBoolean closed1 = new AtomicBoolean();
            AtomicBoolean closed2 = new AtomicBoolean();
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference socketRef = new AtomicReference();
            vertx.createNetServer().connectHandler(so -> {
                socketRef.set(so);
                so.closeHandler(v -> closed1.set(true));
            }).listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost").onComplete(this.onSuccess(server -> latch.countDown()));
            this.awaitLatch(latch);
            HttpClientAgent client = vertx.createHttpClient();
            client.request(HttpMethod.GET, HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onSuccess(req -> req.send());
            ((CleanableHttpClient)client).delegate.netClient().closeFuture().onComplete(ar -> closed2.set(true));
            WeakReference<HttpClientAgent> ref = new WeakReference<HttpClientAgent>(client);
            VertxTest.assertWaitUntil(() -> socketRef.get() != null);
            client = null;
            for (int i = 0; i < 10; ++i) {
                Thread.sleep(10L);
                VertxTest.runGC();
                this.assertFalse(closed1.get());
                this.assertNull(ref.get());
            }
            ((NetSocket)socketRef.get()).end((Object)Buffer.buffer((String)"HTTP/1.1 200 OK\r\nContent-Length: 0\r\n\r\n"));
            long now = System.currentTimeMillis();
            do {
                this.assertTrue(System.currentTimeMillis() - now < 20000L);
                VertxTest.runGC();
            } while (!closed1.get());
            now = System.currentTimeMillis();
            do {
                this.assertTrue(System.currentTimeMillis() - now < 20000L);
                VertxTest.runGC();
            } while (!closed2.get());
        }
        finally {
            vertx.close().onComplete(this.onSuccess(v -> this.testComplete()));
        }
        this.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFinalizeHttpClientWithRequestNotYetSent() throws Exception {
        VertxInternal vertx = (VertxInternal)Vertx.vertx();
        try {
            CountDownLatch latch = new CountDownLatch(1);
            vertx.createNetServer().connectHandler(so -> so.handler(buff -> so.write("HTTP/1.1 200 OK\r\nContent-Length: 0\r\n\r\n"))).listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost").onComplete(this.onSuccess(server -> latch.countDown()));
            this.awaitLatch(latch);
            HttpClientAgent client = vertx.createHttpClient(new PoolOptions().setHttp1MaxSize(1));
            Future fut = client.request(HttpMethod.GET, HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/");
            VertxTest.assertWaitUntil(() -> ((Future)fut).succeeded());
            WeakReference<HttpClientAgent> ref = new WeakReference<HttpClientAgent>(client);
            client = null;
            VertxTest.runGC();
            this.assertNull(ref.get());
            fut.onComplete(this.onSuccess(req -> req.send().onComplete(this.onSuccess(resp -> this.testComplete()))));
            this.await();
        }
        finally {
            this.awaitFuture(vertx.close());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCascadeCloseHttpClient() throws Exception {
        Vertx vertx1 = Vertx.vertx();
        try {
            HttpServer server = vertx1.createHttpServer();
            AtomicBoolean connected = new AtomicBoolean();
            this.awaitFuture(server.requestHandler(req -> {
                connected.set(true);
                req.connection().closeHandler(v -> connected.set(false));
            }).listen(HttpTestBase.DEFAULT_HTTP_PORT, "localhost"));
            VertxInternal vertx2 = (VertxInternal)Vertx.vertx();
            HttpClientAgent client = vertx2.createHttpClient();
            client.request(HttpMethod.GET, HttpTestBase.DEFAULT_HTTP_PORT, "localhost", "/").onComplete(this.onSuccess(req -> req.send()));
            VertxTest.waitUntil(connected::get);
            this.awaitFuture(vertx2.close());
            VertxTest.waitUntil(() -> !connected.get());
        }
        finally {
            this.awaitFuture(vertx1.close());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFinalizeNetClient() throws Exception {
        VertxInternal vertx = (VertxInternal)Vertx.vertx();
        try {
            AtomicBoolean closed1 = new AtomicBoolean();
            AtomicBoolean closed2 = new AtomicBoolean();
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference socketRef = new AtomicReference();
            vertx.createNetServer().connectHandler(so -> {
                socketRef.set(so);
                so.closeHandler(v -> closed1.set(true));
            }).listen(1234, "localhost").onComplete(this.onSuccess(server -> latch.countDown()));
            this.awaitLatch(latch);
            NetClient client = vertx.createNetClient();
            CountDownLatch latch2 = new CountDownLatch(1);
            AtomicInteger shutdownEventCount = new AtomicInteger();
            client.connect(1234, "localhost").onComplete(ar -> {
                if (ar.succeeded()) {
                    NetSocketInternal so = (NetSocketInternal)ar.result();
                    so.eventHandler(v -> shutdownEventCount.incrementAndGet());
                    latch2.countDown();
                }
            });
            ((CleanableNetClient)client).unwrap().closeFuture().onComplete(ar -> closed2.set(true));
            this.awaitLatch(latch2);
            WeakReference<NetClient> ref = new WeakReference<NetClient>(client);
            VertxTest.assertWaitUntil(() -> socketRef.get() != null);
            client = null;
            for (int i = 0; i < 10; ++i) {
                Thread.sleep(10L);
                VertxTest.runGC();
                this.assertFalse(closed1.get());
                this.assertNull(ref.get());
            }
            ((NetSocket)socketRef.get()).close();
            long now = System.currentTimeMillis();
            do {
                this.assertTrue(System.currentTimeMillis() - now < 20000L);
                VertxTest.runGC();
            } while (!closed1.get());
            this.assertEquals(1L, shutdownEventCount.get());
            now = System.currentTimeMillis();
            do {
                this.assertTrue(System.currentTimeMillis() - now < 20000L);
                VertxTest.runGC();
            } while (!closed2.get());
        }
        finally {
            vertx.close().onComplete(this.onSuccess(v -> this.testComplete()));
        }
        this.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCascadeCloseNetClient() throws Exception {
        Vertx vertx1 = Vertx.vertx();
        try {
            NetServer server = vertx1.createNetServer();
            AtomicBoolean connected = new AtomicBoolean();
            this.awaitFuture(server.connectHandler(so -> {
                connected.set(true);
                so.closeHandler(v -> connected.set(false));
            }).listen(1234, "localhost"));
            VertxInternal vertx2 = (VertxInternal)Vertx.vertx();
            NetClient client = vertx2.createNetClient();
            client.connect(1234, "localhost").onComplete(this.onSuccess(so -> {}));
            VertxTest.waitUntil(connected::get);
            this.awaitFuture(vertx2.close());
            VertxTest.waitUntil(() -> !connected.get());
        }
        finally {
            this.awaitFuture(vertx1.close());
        }
    }

    @Test
    public void testCascadeCloseDatagramSocket() throws Exception {
        VertxInternal vertx = (VertxInternal)Vertx.vertx();
        try {
            DatagramSocket socket = vertx.createDatagramSocket();
            this.awaitFuture(socket.listen(1234, "127.0.0.1"));
            this.awaitFuture(vertx.close());
        }
        finally {
            vertx.close().onComplete(this.onSuccess(v -> this.testComplete()));
        }
        this.await();
    }

    @Test
    public void testFinalizeSharedWorkerExecutor() throws Exception {
        VertxInternal vertx = (VertxInternal)Vertx.vertx();
        try {
            Thread[] threads = new Thread[2];
            vertx.createSharedWorkerExecutor("LeakTest").executeBlocking(() -> {
                threads[0] = Thread.currentThread();
                return null;
            }).await(20L, TimeUnit.SECONDS);
            vertx.createSharedWorkerExecutor("LeakTest").executeBlocking(() -> {
                threads[1] = Thread.currentThread();
                return null;
            }).await(20L, TimeUnit.SECONDS);
            VertxTest.runGC();
            this.assertFalse(threads[0].isAlive());
            this.assertFalse(threads[1].isAlive());
        }
        finally {
            vertx.close().await(20L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStickContextFinalization() throws Exception {
        Vertx vertx = Vertx.vertx();
        try {
            AtomicReference ref = new AtomicReference();
            Thread t = new Thread(() -> {
                Context context = vertx.getOrCreateContext();
                ref.set(new WeakReference<Context>(context));
                CountDownLatch latch = new CountDownLatch(1);
                context.runOnContext(v -> latch.countDown());
                try {
                    latch.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            });
            t.start();
            t.join(10000L);
            t = null;
            long now = System.currentTimeMillis();
            do {
                this.assertTrue(System.currentTimeMillis() - now < 20000L);
                VertxTest.runGC();
            } while (((WeakReference)ref.get()).get() != null);
        }
        finally {
            vertx.close().onComplete(this.onSuccess(v -> this.testComplete()));
        }
        this.await();
    }

    @Test
    public void testCloseVertxShouldWaitConcurrentCloseHook() throws Exception {
        VertxInternal vertx = (VertxInternal)Vertx.vertx();
        AtomicReference ref = new AtomicReference();
        CloseFuture fut = new CloseFuture();
        fut.add(newValue -> ref.set(newValue));
        vertx.addCloseHook((Closeable)fut);
        Promise p = Promise.promise();
        fut.close((Completable)p);
        AtomicBoolean closed = new AtomicBoolean();
        vertx.close().onComplete(ar -> closed.set(true));
        Thread.sleep(500L);
        this.assertFalse(closed.get());
        ((Completable)ref.get()).succeed();
        VertxTest.assertWaitUntil(closed::get);
    }

    @Test
    public void testEnableTCCL() {
        this.testTCCL(false);
    }

    @Test
    public void testDisableTCCL() {
        this.testTCCL(true);
    }

    private void testTCCL(boolean disable) {
        VertxOptions options = new VertxOptions().setDisableTCCL(disable);
        Vertx vertx = Vertx.vertx((VertxOptions)options);
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        URLClassLoader cl = new URLClassLoader(new URL[0], orig);
        Thread.currentThread().setContextClassLoader(cl);
        Context ctx = vertx.getOrCreateContext();
        Thread.currentThread().setContextClassLoader(orig);
        ctx.runOnContext(v -> {
            ClassLoader expected = disable ? orig : cl;
            this.assertSame(expected, Thread.currentThread().getContextClassLoader());
            this.testComplete();
        });
        this.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Repeat(times=100)
    @Test
    public void testWorkerExecutorConcurrentCloseWithVertx() throws InterruptedException {
        try (Vertx vertx = Vertx.vertx();){
            CountDownLatch latch = new CountDownLatch(1);
            WorkerExecutor workerExecutor = vertx.createSharedWorkerExecutor("test");
            vertx.runOnContext(v -> {
                latch.countDown();
                workerExecutor.close();
            });
            latch.await();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThreadLeak() throws Exception {
        Vertx vertx = Vertx.vertx();
        try {
            WorkerExecutor exec = vertx.createSharedWorkerExecutor("pool");
            WeakReference ref = (WeakReference)exec.executeBlocking(() -> new WeakReference<Thread>(Thread.currentThread())).await();
            exec.close().await();
            long now = System.currentTimeMillis();
            do {
                this.assertTrue(System.currentTimeMillis() - now < 20000L);
                VertxTest.runGC();
            } while (ref.get() != null);
        }
        finally {
            vertx.close().onComplete(this.onSuccess(v -> this.testComplete()));
        }
        this.await();
    }

    @Test
    public void testVersion() {
        this.assertNotNull(VertxInternal.version());
    }
}

