/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.http.ClientWebSocket;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.metrics.Measured;
import io.vertx.core.net.ClientSSLOptions;
import java.util.concurrent.TimeUnit;

@VertxGen
public interface WebSocketClient
extends Measured {
    public ClientWebSocket webSocket();

    default public Future<WebSocket> connect(int port, String host, String requestURI) {
        return this.connect(new WebSocketConnectOptions().setURI(requestURI).setHost(host).setPort(port));
    }

    default public Future<WebSocket> connect(String host, String requestURI) {
        return this.connect(new WebSocketConnectOptions().setURI(requestURI).setHost(host));
    }

    default public Future<WebSocket> connect(String requestURI) {
        return this.connect(new WebSocketConnectOptions().setURI(requestURI));
    }

    public Future<WebSocket> connect(WebSocketConnectOptions var1);

    default public Future<Void> shutdown() {
        return this.shutdown(30L, TimeUnit.SECONDS);
    }

    default public Future<Void> close() {
        return this.shutdown(0L, TimeUnit.SECONDS);
    }

    default public Future<Boolean> updateSSLOptions(ClientSSLOptions options) {
        return this.updateSSLOptions(options, false);
    }

    public Future<Boolean> updateSSLOptions(ClientSSLOptions var1, boolean var2);

    public Future<Void> shutdown(long var1, TimeUnit var3);
}

