/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.file.impl;

import io.vertx.core.Future;
import io.vertx.core.file.AsyncFileLock;
import io.vertx.core.file.FileSystemException;
import io.vertx.core.internal.VertxInternal;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.util.Objects;

public class AsyncFileLockImpl
implements AsyncFileLock {
    private final VertxInternal vertx;
    private final FileLock fileLock;

    public AsyncFileLockImpl(VertxInternal vertx, FileLock fileLock) {
        this.vertx = Objects.requireNonNull(vertx, "vertx is null");
        this.fileLock = Objects.requireNonNull(fileLock, "fileLock is null");
    }

    @Override
    public long position() {
        return this.fileLock.position();
    }

    @Override
    public long size() {
        return this.fileLock.size();
    }

    @Override
    public boolean isShared() {
        return this.fileLock.isShared();
    }

    @Override
    public boolean overlaps(long position, long size) {
        return this.fileLock.overlaps(position, size);
    }

    @Override
    public boolean isValidBlocking() {
        return this.fileLock.isValid();
    }

    @Override
    public Future<Boolean> isValid() {
        return this.vertx.executeBlockingInternal(this::isValidBlocking);
    }

    @Override
    public void releaseBlocking() {
        try {
            this.fileLock.release();
        }
        catch (IOException e) {
            throw new FileSystemException(e);
        }
    }

    @Override
    public Future<Void> release() {
        return this.vertx.executeBlockingInternal(() -> {
            try {
                this.fileLock.release();
                return null;
            }
            catch (IOException e) {
                throw new FileSystemException(e);
            }
        });
    }
}

