/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.NetSocketInternal;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.impl.DB2SocketConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.command.CommandResponse;
import java.util.Collections;
import java.util.Map;

public class DB2ConnectionFactory {
    private final NetClient netClient;
    private final Context context;
    private final boolean registerCloseHook;
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final String database;
    private final Map<String, String> connectionAttributes;
    private final boolean cachePreparedStatements;
    private final int preparedStatementCacheSize;
    private final int preparedStatementCacheSqlLimit;
    private final int pipeliningLimit;
    private final Closeable hook;

    public DB2ConnectionFactory(Context context, boolean registerCloseHook, DB2ConnectOptions options) {
        NetClientOptions netClientOptions = new NetClientOptions((NetClientOptions)options);
        this.context = context;
        this.registerCloseHook = registerCloseHook;
        this.hook = this::close;
        if (registerCloseHook) {
            context.addCloseHook(this.hook);
        }
        this.host = options.getHost();
        this.port = options.getPort();
        this.username = options.getUser();
        this.password = options.getPassword();
        this.database = options.getDatabase();
        this.connectionAttributes = options.getProperties() == null ? null : Collections.unmodifiableMap(options.getProperties());
        this.cachePreparedStatements = options.getCachePreparedStatements();
        this.preparedStatementCacheSize = options.getPreparedStatementCacheMaxSize();
        this.preparedStatementCacheSqlLimit = options.getPreparedStatementCacheSqlLimit();
        this.pipeliningLimit = options.getPipeliningLimit();
        this.netClient = context.owner().createNetClient(netClientOptions);
    }

    private void close(Handler<AsyncResult<Void>> completionHandler) {
        this.netClient.close();
        completionHandler.handle((Object)Future.succeededFuture());
    }

    void close() {
        if (this.registerCloseHook) {
            this.context.removeCloseHook(this.hook);
        }
        this.netClient.close();
    }

    public void connect(Handler<AsyncResult<Connection>> handler) {
        Promise promise = Promise.promise();
        promise.future().setHandler(ar1 -> {
            if (ar1.succeeded()) {
                NetSocketInternal socket = (NetSocketInternal)ar1.result();
                DB2SocketConnection conn = new DB2SocketConnection(socket, this.cachePreparedStatements, this.preparedStatementCacheSize, this.preparedStatementCacheSqlLimit, this.pipeliningLimit, this.context);
                conn.init();
                conn.sendStartupMessage(this.username, this.password, this.database, this.connectionAttributes, (Handler<? super CommandResponse<Connection>>)handler);
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar1.cause()));
            }
        });
        this.netClient.connect(this.port, this.host, (Handler)promise);
    }
}

