/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.core.buffer.Buffer;
import io.vertx.db2client.impl.codec.DB2PreparedStatement;
import io.vertx.db2client.impl.codec.DB2RowDesc;
import io.vertx.db2client.impl.codec.QueryCommandBaseCodec;
import io.vertx.db2client.impl.codec.RowResultDecoder;
import io.vertx.db2client.impl.drda.DRDAQueryRequest;
import io.vertx.db2client.impl.drda.DRDAQueryResponse;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.sqlclient.impl.command.CommandResponse;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommandBase;
import java.util.stream.Collector;

abstract class ExtendedQueryCommandBaseCodec<R, C extends ExtendedQueryCommandBase<R>>
extends QueryCommandBaseCodec<R, C> {
    final DB2PreparedStatement statement;

    ExtendedQueryCommandBaseCodec(C cmd) {
        super(cmd);
        this.statement = (DB2PreparedStatement)cmd.preparedStatement();
        this.columnDefinitions = this.statement.rowDesc.columnDefinitions();
    }

    void encodePreparedQuery(DRDAQueryRequest queryRequest, DB2PreparedStatement.QueryInstance queryInstance, Tuple params) {
        int requiredParams = this.statement.paramDesc.paramDefinitions().columns_;
        if (params.size() != requiredParams) {
            this.completionHandler.handle((Object)CommandResponse.failure((String)("Only " + params.size() + " prepared statement parameters were provided but " + requiredParams + " parameters are required.")));
            return;
        }
        Object[] inputs = ExtendedQueryCommandBaseCodec.sanitize(params);
        if (queryInstance.cursor == null) {
            queryRequest.writeOpenQuery(this.statement.section, this.encoder.connMetadata.databaseName, ((ExtendedQueryCommandBase)this.cmd).fetch(), 1003, this.statement.paramDesc.paramDefinitions(), inputs);
        } else {
            queryRequest.writeFetch(this.statement.section, this.encoder.connMetadata.databaseName, ((ExtendedQueryCommandBase)this.cmd).fetch(), queryInstance.queryInstanceId);
        }
    }

    void encodePreparedUpdate(DRDAQueryRequest queryRequest, Tuple params) {
        Object[] inputs = ExtendedQueryCommandBaseCodec.sanitize(params);
        boolean outputExpected = false;
        boolean chainAutoCommit = true;
        queryRequest.writeExecute(this.statement.section, this.encoder.connMetadata.databaseName, this.statement.paramDesc.paramDefinitions(), inputs, outputExpected, chainAutoCommit);
    }

    RowResultDecoder<?, R> decodePreparedQuery(ByteBuf payload, DRDAQueryResponse resp, DB2PreparedStatement.QueryInstance queryInstance) {
        RowResultDecoder decoder = null;
        if (queryInstance.cursor == null) {
            resp.setOutputColumnMetaData(this.columnDefinitions);
            resp.readBeginOpenQuery();
            decoder = new RowResultDecoder(((ExtendedQueryCommandBase)this.cmd).collector(), new DB2RowDesc(this.columnDefinitions), resp.getCursor(), resp);
            queryInstance.cursor = resp.getCursor();
            queryInstance.queryInstanceId = resp.getQueryInstanceId();
        } else {
            resp.readFetch(queryInstance.cursor);
            decoder = new RowResultDecoder(((ExtendedQueryCommandBase)this.cmd).collector(), this.statement.rowDesc, queryInstance.cursor, resp);
        }
        while (decoder.next()) {
            decoder.handleRow(this.columnDefinitions.columns_, payload);
        }
        if (decoder.isQueryComplete()) {
            resp.readEndOpenQuery();
            this.statement.closeQuery(queryInstance);
        }
        return decoder;
    }

    void handleUpdateResult(DRDAQueryResponse updateResponse) {
        int updatedCount = (int)updateResponse.readExecute();
        Object result = ExtendedQueryCommandBaseCodec.emptyResult(((ExtendedQueryCommandBase)this.cmd).collector());
        ((ExtendedQueryCommandBase)this.cmd).resultHandler().handleResult(updatedCount, 0, null, result, null);
    }

    static <A, T> T emptyResult(Collector<Row, A, T> collector) {
        return collector.finisher().apply(collector.supplier().get());
    }

    private static Object[] sanitize(Tuple params) {
        Object[] inputs = new Object[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            Object val = params.getValue(i);
            if (val instanceof Numeric) {
                val = ((Numeric)val).bigDecimalValue();
            }
            if (val instanceof Buffer) {
                val = ((Buffer)val).getByteBuf();
            }
            inputs[i] = val;
        }
        return inputs;
    }

    @Override
    public String toString() {
        if (this.isQuery) {
            return super.toString() + ", fetch=" + ((ExtendedQueryCommandBase)this.cmd).fetch();
        }
        return super.toString();
    }
}

