/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.drda;

import io.vertx.db2client.impl.drda.ClientTypes;
import java.util.ArrayList;
import java.util.List;

public class ColumnMetaData {
    public int columns_;
    public boolean[] nullable_;
    public short sqldHold_;
    public short sqldReturn_;
    public short sqldScroll_;
    public short sqldSensitive_;
    public short sqldFcode_;
    public short sqldKeytype_;
    public String sqldRdbnam_;
    public String sqldSchema_;
    public int[] sqlPrecision_;
    public int[] sqlScale_;
    public long[] sqlLength_;
    public int[] sqlType_;
    public int[] sqlCcsid_;
    public String[] sqlName_;
    public String[] sqlLabel_;
    public short[] sqlUnnamed_;
    public String[] sqlComment_;
    public String[] sqlUDTname_;
    public String[] sqlUDTclassName_;
    public short[] sqlxKeymem_;
    public short[] sqlxGenerated_;
    public short[] sqlxParmmode_;
    public String[] sqlxCorname_;
    public String[] sqlxName_;
    public String[] sqlxBasename_;
    public int[] sqlxUpdatable_;
    public String[] sqlxSchema_;
    public String[] sqlxRdbnam_;
    public transient int[][] protocolTypesCache_ = null;
    public transient int[] types_;
    public transient int[] clientParamtertype_;

    public void setColumnCount(int numColumns) {
        if (this.nullable_ != null) {
            if (this.columns_ == numColumns) {
                return;
            }
            if (this.columns_ > numColumns) {
                this.columns_ = numColumns;
                return;
            }
        }
        this.columns_ = numColumns;
        this.nullable_ = new boolean[numColumns];
        this.sqlPrecision_ = new int[numColumns];
        this.sqlScale_ = new int[numColumns];
        this.sqlLength_ = new long[numColumns];
        this.sqlType_ = new int[numColumns];
        this.sqlCcsid_ = new int[numColumns];
        this.sqlName_ = new String[numColumns];
        this.sqlLabel_ = new String[numColumns];
        this.sqlUnnamed_ = new short[numColumns];
        this.sqlComment_ = new String[numColumns];
        this.sqlUDTname_ = new String[numColumns];
        this.sqlUDTclassName_ = new String[numColumns];
        this.sqlxKeymem_ = new short[numColumns];
        this.sqlxGenerated_ = new short[numColumns];
        this.sqlxParmmode_ = new short[numColumns];
        this.sqlxCorname_ = new String[numColumns];
        this.sqlxName_ = new String[numColumns];
        this.sqlxBasename_ = new String[numColumns];
        this.sqlxUpdatable_ = new int[numColumns];
        this.sqlxSchema_ = new String[numColumns];
        this.sqlxRdbnam_ = new String[numColumns];
        this.types_ = new int[numColumns];
        this.clientParamtertype_ = new int[numColumns];
    }

    public List<String> getColumnNames() {
        ArrayList<String> cols = new ArrayList<String>(this.columns_);
        for (int i = 0; i < this.columns_; ++i) {
            cols.add(i, this.getColumnName(i));
        }
        return cols;
    }

    public String getColumnName(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("Requested column name for negative index: " + i);
        }
        if (this.sqlName_ != null && i < this.sqlName_.length && this.sqlName_[i] != null) {
            return this.sqlName_[i];
        }
        if (this.sqlxName_ != null && i < this.sqlxName_.length) {
            return this.sqlxName_[i];
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("{");
        for (int i = 0; i < this.columns_; ++i) {
            sb.append("{name=");
            sb.append(this.getColumnName(i));
            sb.append(", type=");
            if (this.types_ != null && i < this.types_.length) {
                sb.append(this.types_[i]);
                sb.append("/");
                sb.append(ClientTypes.getTypeString(this.types_[i]));
            } else {
                sb.append("null");
            }
            sb.append(", nullable=");
            if (this.nullable_ != null && i < this.nullable_.length) {
                sb.append(this.nullable_[i]);
            } else {
                sb.append("null");
            }
            sb.append("}");
        }
        sb.append("}");
        return sb.toString();
    }
}

