/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.impl.NetSocketInternal;
import io.vertx.db2client.impl.codec.DB2Codec;
import io.vertx.db2client.impl.command.InitialHandshakeCommand;
import io.vertx.db2client.impl.drda.ConnectionMetaData;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.SocketConnectionBase;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.CommandResponse;
import io.vertx.sqlclient.impl.command.SimpleQueryCommand;
import io.vertx.sqlclient.spi.DatabaseMetadata;
import java.util.Map;
import java.util.function.Predicate;

public class DB2SocketConnection
extends SocketConnectionBase {
    private DB2Codec codec;
    private Handler<Void> closeHandler;
    public final ConnectionMetaData connMetadata = new ConnectionMetaData();

    public DB2SocketConnection(NetSocketInternal socket, boolean cachePreparedStatements, int preparedStatementCacheSize, Predicate<String> preparedStatementCacheSqlFilter, int pipeliningLimit, Context context) {
        super(socket, cachePreparedStatements, preparedStatementCacheSize, preparedStatementCacheSqlFilter, pipeliningLimit, context);
    }

    void sendStartupMessage(String username, String password, String database, Map<String, String> properties, Handler<? super CommandResponse<Connection>> completionHandler) {
        InitialHandshakeCommand cmd = new InitialHandshakeCommand(this, username, password, database, properties);
        this.schedule(cmd, completionHandler);
    }

    public void init() {
        this.codec = new DB2Codec(this);
        ChannelPipeline pipeline = this.socket.channelHandlerContext().pipeline();
        pipeline.addBefore("handler", "codec", (ChannelHandler)this.codec);
        super.init();
    }

    public void schedule(CommandBase<?> cmd) {
        if (cmd instanceof SimpleQueryCommand && "BEGIN".equals(((SimpleQueryCommand)cmd).sql())) {
            cmd.handler.handle((Object)CommandResponse.success(null));
            return;
        }
        super.schedule(cmd);
    }

    public void handleClose(Throwable t) {
        super.handleClose(t);
        this.context().runOnContext(this.closeHandler);
    }

    public DatabaseMetadata getDatabaseMetaData() {
        return this.connMetadata.dbMetadata;
    }

    public DB2SocketConnection closeHandler(Handler<Void> handler) {
        this.closeHandler = handler;
        return this;
    }
}

