/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.drda;

import io.vertx.db2client.DB2Exception;
import io.vertx.db2client.impl.drda.CCSIDConstants;
import java.util.Arrays;

public class NetSqlca {
    private static final String SQLERRMC_MESSAGE_DELIMITER = new String(new char[]{'\u0014', '\u0014', '\u0014', '\u0014'});
    private static final int HIGH_ORDER_ROW_COUNT = 0;
    private static final int LOW_ORDER_ROW_COUNT = 1;
    private static final int LOW_ORDER_UPDATE_COUNT = 2;
    private static final int HIGH_ORDER_UPDATE_COUNT = 3;
    public static final int SQL_ERR_LENGTH = 6;
    boolean messageTextRetrievedContainsTokensOnly_ = true;
    protected int sqlCode_;
    private String sqlErrmc_;
    private String[] sqlErrmcMessages_;
    private String[] sqlStates_;
    private String sqlErrp_;
    protected int[] sqlErrd_;
    private String sqlWarn_;
    protected String sqlState_;
    protected byte[] sqlErrmcBytes_;
    protected byte[] sqlErrpBytes_;
    protected byte[] sqlWarnBytes_;
    private boolean containsSqlcax_ = true;
    private long rowsetRowCount_;
    private boolean returnTokensOnlyInMessageText_ = false;
    private String[] cachedMessages;
    private static final String elevenBlanks = "           ";

    NetSqlca(int sqlCode, String sqlState, byte[] sqlErrpBytes) {
        this.sqlCode_ = sqlCode;
        this.sqlState_ = sqlState;
        this.sqlErrpBytes_ = sqlErrpBytes;
    }

    NetSqlca(int sqlCode, byte[] sqlState, byte[] sqlErrpBytes) {
        this.sqlCode_ = sqlCode;
        this.sqlState_ = this.bytes2String(sqlState, 0, sqlState.length);
        this.sqlErrpBytes_ = sqlErrpBytes;
    }

    public static int complete(NetSqlca sqlca, int ... allowedCodes) {
        if (sqlca == null || sqlca.sqlCode_ == 0) {
            return 0;
        }
        boolean allowed = Arrays.stream(allowedCodes).anyMatch(code -> code == sqlca.sqlCode_);
        if (!allowed && sqlca.sqlCode_ < 0) {
            NetSqlca.throwSqlError(sqlca);
        }
        if (!allowed && sqlca.sqlCode_ > 0) {
            System.out.println("WARNING sqlcode=" + sqlca.sqlCode_);
        }
        return sqlca.sqlCode_;
    }

    public static void throwSqlError(NetSqlca sqlca) {
        if (sqlca == null || sqlca.sqlCode_ == 0) {
            return;
        }
        String errMsg = sqlca.getSqlErrmc();
        if (errMsg == null || errMsg.trim().length() == 0) {
            errMsg = "";
        }
        Object[] errMsgTokens = errMsg.split("\ufffd");
        switch (sqlca.sqlCode_) {
            case -104: {
                if (errMsg.length() > 0 && errMsgTokens.length > 1) {
                    throw new DB2Exception("The SQL syntax provided was invalid at or near the tokens: " + Arrays.toString(errMsgTokens), sqlca.sqlCode_, sqlca.sqlState_);
                }
                throw new DB2Exception("The SQL syntax provided was invalid", sqlca.sqlCode_, sqlca.sqlState_);
            }
            case -117: {
                throw new DB2Exception("An INSERT statement contained a different number of insert columns from the number of insert values that were supplied", sqlca.sqlCode_, sqlca.sqlState_);
            }
            case -121: {
                if (errMsg.length() > 0) {
                    throw new DB2Exception("An INSERT or UPDATE statement listed the same column name (" + errMsg + ") more than one time in its update list", sqlca.sqlCode_, sqlca.sqlState_);
                }
                throw new DB2Exception("An INSERT or UPDATE statement listed the same column name more than one time in its update list", sqlca.sqlCode_, sqlca.sqlState_);
            }
            case -125: {
                throw new DB2Exception("The ORDER BY clause in the statement contains a column number that is either less than one or greater than the number of columns of the result table (the number of items in the SELECT clause)", sqlca.sqlCode_, sqlca.sqlState_);
            }
            case -151: {
                throw new DB2Exception("An UPDATE statement referenced a column that is marked in the catalog as non-updateable.", sqlca.sqlCode_, sqlca.sqlState_);
            }
            case -199: {
                if (errMsg.length() > 0) {
                    throw new DB2Exception("The keyword, '" + errMsg + "' is not valid", sqlca.sqlCode_, sqlca.sqlState_);
                }
                throw new DB2Exception("The keyword is not valid", sqlca.sqlCode_, sqlca.sqlState_);
            }
            case -203: {
                if (errMsg.length() > 0) {
                    throw new DB2Exception("A reference to the column name '" + errMsg + "' is ambiguous", sqlca.sqlCode_, sqlca.sqlState_);
                }
                throw new DB2Exception("A reference to a column name is ambiguous", sqlca.sqlCode_, sqlca.sqlState_);
            }
            case -204: {
                if (errMsg.length() > 0) {
                    throw new DB2Exception("The object '" + errMsg + "' provided is not defined", sqlca.sqlCode_, sqlca.sqlState_);
                }
                throw new DB2Exception("An object provided is not defined", sqlca.sqlCode_, sqlca.sqlState_);
            }
            case -206: {
                if (errMsg.length() > 0) {
                    throw new DB2Exception("The column '" + errMsg + "' provided does not exist", sqlca.sqlCode_, sqlca.sqlState_);
                }
                throw new DB2Exception("A column provided does not exist", sqlca.sqlCode_, sqlca.sqlState_);
            }
            case -407: {
                throw new DB2Exception("An attempt was made to INSERT or UPDATE a column that was declared as not nullable with the NULL value: " + errMsg, sqlca.sqlCode_, sqlca.sqlState_);
            }
            case -542: {
                if (errMsg.length() > 0) {
                    throw new DB2Exception("The column '" + errMsg + "' cannot be a column of a primary key because it can contain null values", sqlca.sqlCode_, sqlca.sqlState_);
                }
                throw new DB2Exception("A column could not be created as a primary key column because it can contain null values", sqlca.sqlCode_, sqlca.sqlState_);
            }
            case -601: {
                if (errMsg.length() > 0) {
                    if (errMsgTokens.length == 2) {
                        String objectType = errMsgTokens[1];
                        String objectName = errMsgTokens[0];
                        throw new DB2Exception("The object with the name '" + objectName + "' of type '" + objectType + "' already exists", sqlca.sqlCode_, sqlca.sqlState_);
                    }
                    throw new DB2Exception("The object with the name '" + errMsg + "' already exists", sqlca.sqlCode_, sqlca.sqlState_);
                }
                throw new DB2Exception("The name of the object to be created cannot be identical to the existing name", sqlca.sqlCode_, sqlca.sqlState_);
            }
            case -1001: {
                if (errMsg.length() > 0) {
                    throw new DB2Exception("The database '" + errMsg + "' provided was not found", sqlca.sqlCode_, sqlca.sqlState_);
                }
                throw new DB2Exception("The database provided was not found", sqlca.sqlCode_, sqlca.sqlState_);
            }
            case -604: {
                if (errMsg.length() > 0) {
                    throw new DB2Exception("The statement cannot be processed. The data type definition '" + errMsg + "' specifies an invalid attribute such as precision, length, or scale.", sqlca.sqlCode_, sqlca.sqlState_);
                }
                throw new DB2Exception("The statement cannot be processed. A data type definition specifies an invalid attribute such as precision, length, or scale.", sqlca.sqlCode_, sqlca.sqlState_);
            }
            case -798: {
                if (errMsg.length() > 0) {
                    throw new DB2Exception("A value cannot be specified for column '" + errMsg + "' which is identified as GENERATED ALWAYS", sqlca.sqlCode_, sqlca.sqlState_);
                }
                throw new DB2Exception("A value cannot be specified for a column which is identified as GENERATED ALWAYS", sqlca.sqlCode_, sqlca.sqlState_);
            }
            case -803: {
                if (errMsgTokens.length >= 2) {
                    throw new DB2Exception("Duplicate keys were detected on table " + errMsgTokens[1], sqlca.sqlCode_, sqlca.sqlState_);
                }
                throw new DB2Exception("Duplicate keys were detected on the updated table", sqlca.sqlCode_, sqlca.sqlState_);
            }
        }
        throw new IllegalStateException("ERROR: " + sqlca.toString());
    }

    void setSqlerrd(int[] sqlErrd) {
        this.sqlErrd_ = sqlErrd;
    }

    void setSqlwarnBytes(byte[] sqlWarnBytes) {
        this.sqlWarnBytes_ = sqlWarnBytes;
    }

    void setSqlerrmcBytes(byte[] sqlErrmcBytes) {
        this.sqlErrmcBytes_ = sqlErrmcBytes;
    }

    void returnTokensOnlyInMessageText(boolean returnTokensOnlyInMessageText) {
        this.returnTokensOnlyInMessageText_ = returnTokensOnlyInMessageText;
    }

    synchronized int numberOfMessages() {
        this.initSqlErrmcMessages();
        if (this.sqlErrmcMessages_ != null) {
            return this.sqlErrmcMessages_.length;
        }
        return 1;
    }

    public synchronized int getSqlCode() {
        return this.sqlCode_;
    }

    public synchronized String getSqlErrmc() {
        int indx;
        if (this.sqlErrmc_ != null) {
            return this.sqlErrmc_;
        }
        this.initSqlErrmcMessages();
        if (this.sqlErrmcMessages_ == null) {
            return null;
        }
        if (this.sqlErrmcMessages_.length == 0) {
            this.sqlErrmc_ = "";
            return this.sqlErrmc_;
        }
        StringBuffer buffer = new StringBuffer();
        for (indx = 0; indx < this.sqlErrmcMessages_.length - 1; ++indx) {
            buffer.append(this.sqlErrmcMessages_[indx]);
            buffer.append(SQLERRMC_MESSAGE_DELIMITER);
            buffer.append(this.sqlStates_[indx + 1]);
            buffer.append(":");
        }
        buffer.append(this.sqlErrmcMessages_[indx]);
        this.sqlErrmc_ = buffer.toString();
        return this.sqlErrmc_;
    }

    private void initSqlErrmcMessages() {
        if (this.sqlErrmcMessages_ == null || this.sqlStates_ == null) {
            this.processSqlErrmcTokens(this.sqlErrmcBytes_);
        }
    }

    public synchronized String getSqlErrp() {
        if (this.sqlErrp_ != null) {
            return this.sqlErrp_;
        }
        if (this.sqlErrpBytes_ == null) {
            return null;
        }
        this.sqlErrp_ = this.bytes2String(this.sqlErrpBytes_, 0, this.sqlErrpBytes_.length);
        return this.sqlErrp_;
    }

    private int[] getSqlErrd() {
        if (this.sqlErrd_ != null) {
            return this.sqlErrd_;
        }
        this.sqlErrd_ = new int[6];
        return this.sqlErrd_;
    }

    public synchronized String getSqlWarn() {
        if (this.sqlWarn_ == null) {
            this.sqlWarn_ = this.sqlWarnBytes_ != null ? this.bytes2String(this.sqlWarnBytes_, 0, this.sqlWarnBytes_.length) : elevenBlanks;
        }
        return this.sqlWarn_;
    }

    public synchronized String getSqlState() {
        return this.sqlState_;
    }

    synchronized String getSqlState(int messageNumber) {
        this.initSqlErrmcMessages();
        if (this.sqlStates_ != null) {
            return this.sqlStates_[messageNumber];
        }
        return this.getSqlState();
    }

    private void processSqlErrmcTokens(byte[] tokenBytes) {
        if (tokenBytes == null) {
            return;
        }
        int length = tokenBytes.length;
        if (length == 0) {
            this.sqlErrmcMessages_ = new String[0];
            this.sqlStates_ = this.sqlErrmcMessages_;
            return;
        }
        String fullString = this.bytes2String(tokenBytes, 0, length);
        String[] tokens = fullString.split("\\u0014{3}");
        String[] states = new String[tokens.length];
        states[0] = this.getSqlState();
        for (int i = 1; i < tokens.length; ++i) {
            int colonpos = tokens[i].indexOf(":");
            states[i] = tokens[i].substring(0, colonpos);
            tokens[i] = tokens[i].substring(colonpos + 1);
        }
        this.sqlStates_ = states;
        this.sqlErrmcMessages_ = tokens;
    }

    private String bytes2String(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return this.bytes2String(bytes, 0, bytes.length);
    }

    protected String bytes2String(byte[] bytes, int offset, int length) {
        return new String(bytes, offset, length, CCSIDConstants.UTF8);
    }

    public long getUpdateCount() {
        if (this.sqlErrd_ == null) {
            return 0L;
        }
        long result = this.getSqlErrd()[2];
        result &= 0xFFFFFFFFL;
        return result |= (long)this.getSqlErrd()[3] << 32;
    }

    public long getRowCount() {
        return ((long)this.getSqlErrd()[0] << 32) + (long)this.getSqlErrd()[1];
    }

    public void setContainsSqlcax(boolean containsSqlcax) {
        this.containsSqlcax_ = containsSqlcax;
    }

    public boolean containsSqlcax() {
        return this.containsSqlcax_;
    }

    public void resetRowsetSqlca(int sqlCode, String sqlState) {
        this.sqlCode_ = sqlCode;
        this.sqlState_ = sqlState;
        this.sqlErrpBytes_ = null;
    }

    public void setRowsetRowCount(long rowCount) {
        this.rowsetRowCount_ = rowCount;
    }

    public long getRowsetRowCount() {
        return this.rowsetRowCount_;
    }

    public String toString() {
        return super.toString() + "  sqlCode=" + this.sqlCode_ + "  sqlState=" + this.sqlState_ + "  sqlErrd=" + Arrays.toString(this.sqlErrd_) + "  sqlErrmc=" + this.getSqlErrmc() + "  sqlErrp=" + this.bytes2String(this.sqlErrpBytes_) + "  sqlStates=" + Arrays.deepToString(this.sqlStates_) + "  sqlWarn=" + this.bytes2String(this.sqlWarnBytes_);
    }
}

