/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.ContextInternal;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.impl.DB2PoolImpl;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;

@VertxGen
public interface DB2Pool
extends Pool {
    public static DB2Pool pool(String connectionUri) {
        return DB2Pool.pool(connectionUri, new PoolOptions());
    }

    public static DB2Pool pool(String connectionUri, PoolOptions poolOptions) {
        return DB2Pool.pool(DB2ConnectOptions.fromUri(connectionUri), poolOptions);
    }

    public static DB2Pool pool(Vertx vertx, String connectionUri) {
        return DB2Pool.pool(vertx, DB2ConnectOptions.fromUri(connectionUri), new PoolOptions());
    }

    public static DB2Pool pool(Vertx vertx, String connectionUri, PoolOptions poolOptions) {
        return DB2Pool.pool(vertx, DB2ConnectOptions.fromUri(connectionUri), poolOptions);
    }

    public static DB2Pool pool(DB2ConnectOptions connectOptions, PoolOptions poolOptions) {
        if (Vertx.currentContext() != null) {
            throw new IllegalStateException("Running in a Vertx context => use DB2Pool#pool(Vertx, DB2ConnectOptions, PoolOptions) instead");
        }
        VertxOptions vertxOptions = new VertxOptions();
        Vertx vertx = Vertx.vertx((VertxOptions)vertxOptions);
        return new DB2PoolImpl((Context)((ContextInternal)vertx.getOrCreateContext()), true, connectOptions, poolOptions);
    }

    public static DB2Pool pool(Vertx vertx, DB2ConnectOptions connectOptions, PoolOptions poolOptions) {
        return new DB2PoolImpl((Context)((ContextInternal)vertx.getOrCreateContext()), false, connectOptions, poolOptions);
    }
}

