/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.codec;

import io.vertx.db2client.impl.drda.ColumnMetaData;
import io.vertx.sqlclient.desc.ColumnDescriptor;
import io.vertx.sqlclient.impl.RowDesc;
import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.List;

class DB2RowDesc
extends RowDesc {
    private final ColumnMetaData columnDefinitions;

    DB2RowDesc(ColumnMetaData columnDefinitions) {
        super(columnDefinitions.getColumnNames(), DB2RowDesc.columns(columnDefinitions));
        this.columnDefinitions = columnDefinitions;
    }

    ColumnMetaData columnDefinitions() {
        return this.columnDefinitions;
    }

    private static List<ColumnDescriptor> columns(ColumnMetaData md) {
        List<String> names = md.getColumnNames();
        List<JDBCType> types = md.getJdbcTypes();
        ArrayList<ColumnDescriptor> columns = new ArrayList<ColumnDescriptor>(names.size());
        for (int i = 0; i < names.size(); ++i) {
            columns.add(new DB2ColumnDesc(names.get(i), types.get(i)));
        }
        return columns;
    }

    static class DB2ColumnDesc
    implements ColumnDescriptor {
        private final String name;
        private final JDBCType type;

        public DB2ColumnDesc(String name, JDBCType type) {
            this.name = name;
            this.type = type;
        }

        public String name() {
            return this.name;
        }

        public JDBCType jdbcType() {
            return this.type;
        }

        public boolean isArray() {
            return false;
        }
    }
}

