/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl;

import io.vertx.core.Closeable;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.DB2Pool;
import io.vertx.db2client.impl.DB2ConnectionFactory;
import io.vertx.db2client.impl.DB2ConnectionImpl;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionFactory;
import io.vertx.sqlclient.impl.PoolBase;
import io.vertx.sqlclient.impl.SqlConnectionImpl;
import io.vertx.sqlclient.impl.tracing.QueryTracer;

public class DB2PoolImpl
extends PoolBase<DB2PoolImpl>
implements DB2Pool {
    private final DB2ConnectionFactory factory;

    public static DB2PoolImpl create(ContextInternal context, boolean closeVertx, DB2ConnectOptions connectOptions, PoolOptions poolOptions) {
        QueryTracer tracer = context.tracer() == null ? null : new QueryTracer(context.tracer(), (SqlConnectOptions)connectOptions);
        VertxMetrics vertxMetrics = context.owner().metricsSPI();
        ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(connectOptions.getSocketAddress(), "sql", connectOptions.getMetricsName()) : null;
        EventLoopContext eventLoopContext = ConnectionFactory.asEventLoopContext((ContextInternal)context);
        DB2PoolImpl pool = new DB2PoolImpl(eventLoopContext, poolOptions, new DB2ConnectionFactory(eventLoopContext, connectOptions), tracer, metrics);
        CloseFuture closeFuture = pool.closeFuture();
        if (closeVertx) {
            closeFuture.onComplete(ar -> context.owner().close());
        } else {
            context.addCloseHook((Closeable)closeFuture);
        }
        return pool;
    }

    private DB2PoolImpl(EventLoopContext context, PoolOptions poolOptions, DB2ConnectionFactory factory, QueryTracer tracer, ClientMetrics metrics) {
        super(context, (ConnectionFactory)factory, tracer, metrics, poolOptions);
        this.factory = factory;
    }

    protected SqlConnectionImpl wrap(ContextInternal context, Connection conn) {
        return new DB2ConnectionImpl(this.factory, context, conn, this.tracer, this.metrics);
    }
}

