/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.VertxInternal;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.impl.DB2PoolImpl;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlClient;

@VertxGen
public interface DB2Pool
extends Pool {
    public static DB2Pool pool(String connectionUri) {
        return DB2Pool.pool(connectionUri, new PoolOptions());
    }

    public static DB2Pool pool(String connectionUri, PoolOptions poolOptions) {
        return DB2Pool.pool(DB2ConnectOptions.fromUri(connectionUri), poolOptions);
    }

    public static DB2Pool pool(Vertx vertx, String connectionUri) {
        return DB2Pool.pool(vertx, DB2ConnectOptions.fromUri(connectionUri), new PoolOptions());
    }

    public static DB2Pool pool(Vertx vertx, String connectionUri, PoolOptions poolOptions) {
        return DB2Pool.pool(vertx, DB2ConnectOptions.fromUri(connectionUri), poolOptions);
    }

    public static DB2Pool pool(DB2ConnectOptions connectOptions, PoolOptions poolOptions) {
        if (Vertx.currentContext() != null) {
            throw new IllegalStateException("Running in a Vertx context => use DB2Pool#pool(Vertx, DB2ConnectOptions, PoolOptions) instead");
        }
        VertxOptions vertxOptions = new VertxOptions();
        Vertx vertx = Vertx.vertx((VertxOptions)vertxOptions);
        return DB2PoolImpl.create((VertxInternal)vertx, true, false, connectOptions, poolOptions);
    }

    public static DB2Pool pool(Vertx vertx, DB2ConnectOptions connectOptions, PoolOptions poolOptions) {
        return DB2PoolImpl.create((VertxInternal)vertx, false, false, connectOptions, poolOptions);
    }

    public static SqlClient client(String connectionUri) {
        return DB2Pool.client(connectionUri, new PoolOptions());
    }

    public static SqlClient client(String connectionUri, PoolOptions poolOptions) {
        return DB2Pool.client(DB2ConnectOptions.fromUri(connectionUri), poolOptions);
    }

    public static SqlClient client(Vertx vertx, String connectionUri) {
        return DB2Pool.client(vertx, DB2ConnectOptions.fromUri(connectionUri), new PoolOptions());
    }

    public static SqlClient client(Vertx vertx, String connectionUri, PoolOptions poolOptions) {
        return DB2Pool.client(vertx, DB2ConnectOptions.fromUri(connectionUri), poolOptions);
    }

    public static SqlClient client(DB2ConnectOptions connectOptions, PoolOptions poolOptions) {
        if (Vertx.currentContext() != null) {
            throw new IllegalStateException("Running in a Vertx context => use DB2Pool#pool(Vertx, DB2ConnectOptions, PoolOptions) instead");
        }
        VertxOptions vertxOptions = new VertxOptions();
        Vertx vertx = Vertx.vertx((VertxOptions)vertxOptions);
        return DB2PoolImpl.create((VertxInternal)vertx, true, true, connectOptions, poolOptions);
    }

    public static SqlClient client(Vertx vertx, DB2ConnectOptions connectOptions, PoolOptions poolOptions) {
        return DB2PoolImpl.create((VertxInternal)vertx, false, true, connectOptions, poolOptions);
    }
}

