/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.impl.DB2SocketConnection;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionFactory;
import io.vertx.sqlclient.impl.SqlConnectionFactoryBase;

public class DB2ConnectionFactory
extends SqlConnectionFactoryBase
implements ConnectionFactory {
    private int pipeliningLimit;

    public DB2ConnectionFactory(VertxInternal vertx, DB2ConnectOptions options) {
        super(vertx, (SqlConnectOptions)options);
    }

    protected void initializeConfiguration(SqlConnectOptions connectOptions) {
        DB2ConnectOptions options = (DB2ConnectOptions)connectOptions;
        this.pipeliningLimit = options.getPipeliningLimit();
    }

    protected void configureNetClientOptions(NetClientOptions netClientOptions) {
    }

    protected void doConnectInternal(Promise<Connection> promise) {
        PromiseInternal promiseInternal = (PromiseInternal)promise;
        EventLoopContext context = ConnectionFactory.asEventLoopContext((ContextInternal)promiseInternal.context());
        Future fut = this.netClient.connect(this.socketAddress);
        fut.onComplete(ar -> {
            if (ar.succeeded()) {
                NetSocket so = (NetSocket)ar.result();
                DB2SocketConnection conn = new DB2SocketConnection((NetSocketInternal)so, this.cachePreparedStatements, this.preparedStatementCacheSize, this.preparedStatementCacheSqlFilter, this.pipeliningLimit, context);
                conn.init();
                conn.sendStartupMessage(this.username, this.password, this.database, this.properties, promise);
            } else {
                promise.fail(ar.cause());
            }
        });
    }
}

