/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.DB2Connection;
import io.vertx.db2client.impl.DB2ConnectionFactory;
import io.vertx.db2client.impl.command.PingCommand;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.SqlConnectionImpl;
import io.vertx.sqlclient.impl.tracing.QueryTracer;

public class DB2ConnectionImpl
extends SqlConnectionImpl<DB2ConnectionImpl>
implements DB2Connection {
    public static Future<DB2Connection> connect(Vertx vertx, DB2ConnectOptions options) {
        DB2ConnectionFactory client;
        ContextInternal ctx = (ContextInternal)vertx.getOrCreateContext();
        try {
            client = new DB2ConnectionFactory(ctx.owner(), options);
        }
        catch (Exception e) {
            return ctx.failedFuture((Throwable)e);
        }
        ctx.addCloseHook((Closeable)client);
        QueryTracer tracer = ctx.tracer() == null ? null : new QueryTracer(ctx.tracer(), (SqlConnectOptions)options);
        PromiseInternal promise = ctx.promise();
        client.connect((Promise)promise);
        return promise.future().map(conn -> {
            DB2ConnectionImpl db2Connection = new DB2ConnectionImpl(client, ctx, (Connection)conn, tracer, null);
            conn.init((Connection.Holder)db2Connection);
            return db2Connection;
        });
    }

    public DB2ConnectionImpl(DB2ConnectionFactory factory, ContextInternal context, Connection conn, QueryTracer tracer, ClientMetrics metrics) {
        super(context, conn, tracer, metrics);
    }

    @Override
    public DB2Connection ping(Handler<AsyncResult<Void>> handler) {
        Future<Void> fut = this.ping();
        if (handler != null) {
            fut.onComplete(handler);
        }
        return this;
    }

    @Override
    public Future<Void> ping() {
        return this.schedule(this.context, new PingCommand());
    }

    @Override
    public DB2Connection debug(Handler<AsyncResult<Void>> handler) {
        throw new UnsupportedOperationException("Debug command not implemented");
    }

    @Override
    public Future<Void> debug() {
        throw new UnsupportedOperationException("Debug command not implemented");
    }
}

