/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl;

import io.vertx.core.Closeable;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.DB2Pool;
import io.vertx.db2client.impl.DB2ConnectionFactory;
import io.vertx.db2client.impl.DB2ConnectionImpl;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionFactory;
import io.vertx.sqlclient.impl.PoolBase;
import io.vertx.sqlclient.impl.SqlConnectionImpl;
import io.vertx.sqlclient.impl.tracing.QueryTracer;

public class DB2PoolImpl
extends PoolBase<DB2PoolImpl>
implements DB2Pool {
    private final DB2ConnectionFactory factory;

    public static DB2PoolImpl create(VertxInternal vertx, boolean closeVertx, boolean pipelined, DB2ConnectOptions connectOptions, PoolOptions poolOptions) {
        QueryTracer tracer = vertx.tracer() == null ? null : new QueryTracer(vertx.tracer(), (SqlConnectOptions)connectOptions);
        VertxMetrics vertxMetrics = vertx.metricsSPI();
        int pipeliningLimit = pipelined ? connectOptions.getPipeliningLimit() : 1;
        ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(connectOptions.getSocketAddress(), "sql", connectOptions.getMetricsName()) : null;
        DB2PoolImpl pool = new DB2PoolImpl(vertx, pipeliningLimit, poolOptions, new DB2ConnectionFactory(vertx, connectOptions), tracer, metrics);
        pool.init();
        CloseFuture closeFuture = pool.closeFuture();
        if (closeVertx) {
            closeFuture.future().onComplete(ar -> vertx.close());
        } else {
            ContextInternal ctx = vertx.getContext();
            if (ctx != null) {
                ctx.addCloseHook((Closeable)closeFuture);
            } else {
                vertx.addCloseHook((Closeable)closeFuture);
            }
        }
        return pool;
    }

    private DB2PoolImpl(VertxInternal vertx, int pipeliningLimit, PoolOptions poolOptions, DB2ConnectionFactory factory, QueryTracer tracer, ClientMetrics metrics) {
        super(vertx, (ConnectionFactory)factory, tracer, metrics, pipeliningLimit, poolOptions);
        this.factory = factory;
    }

    protected SqlConnectionImpl wrap(ContextInternal context, Connection conn) {
        return new DB2ConnectionImpl(this.factory, context, conn, this.tracer, this.metrics);
    }
}

