/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.db2client.impl.codec.DB2Encoder;
import io.vertx.db2client.impl.codec.DB2PreparedStatement;
import io.vertx.db2client.impl.codec.ExtendedQueryCommandBaseCodec;
import io.vertx.db2client.impl.codec.RowResultDecoder;
import io.vertx.db2client.impl.drda.DRDAQueryRequest;
import io.vertx.db2client.impl.drda.DRDAQueryResponse;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.command.CommandResponse;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

class ExtendedBatchQueryCommandCodec<R>
extends ExtendedQueryCommandBaseCodec<R, ExtendedQueryCommand<R>> {
    private static final Logger LOG = LoggerFactory.getLogger(ExtendedBatchQueryCommandCodec.class);
    private final List<Tuple> params;
    private final List<DB2PreparedStatement.QueryInstance> queryInstances;
    private final String baseCursorId;

    ExtendedBatchQueryCommandCodec(ExtendedQueryCommand<R> cmd) {
        super(cmd);
        this.params = cmd.paramsList();
        this.queryInstances = new ArrayList<DB2PreparedStatement.QueryInstance>(this.params.size());
        this.baseCursorId = (cmd.cursorId() == null ? UUID.randomUUID().toString() : cmd.cursorId()) + "-";
    }

    @Override
    void encode(DB2Encoder encoder) {
        if (this.params.isEmpty()) {
            this.completionHandler.handle((Object)CommandResponse.failure((String)"Can not execute batch query with 0 sets of batch parameters."));
            return;
        }
        super.encode(encoder);
    }

    @Override
    void encodeQuery(DRDAQueryRequest req) {
        for (int i = 0; i < this.params.size(); ++i) {
            Tuple params = this.params.get(i);
            DB2PreparedStatement.QueryInstance queryInstance = this.statement.getQueryInstance(this.baseCursorId + i);
            this.queryInstances.add(i, queryInstance);
            this.encodePreparedQuery(req, queryInstance, params);
        }
    }

    @Override
    void encodeUpdate(DRDAQueryRequest req) {
        for (Tuple params : this.params) {
            this.encodePreparedUpdate(req, params);
        }
        if (((ExtendedQueryCommand)this.cmd).autoCommit()) {
            req.buildRDBCMM();
        }
    }

    @Override
    void decodeQuery(ByteBuf payload) {
        boolean hasMoreResults = true;
        DRDAQueryResponse resp = new DRDAQueryResponse(payload, this.encoder.socketConnection.connMetadata);
        for (int i = 0; i < this.params.size(); ++i) {
            DB2PreparedStatement.QueryInstance queryInstance;
            RowResultDecoder decoder;
            boolean queryComplete;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Decode query " + i));
            }
            hasMoreResults &= !(queryComplete = (decoder = this.decodePreparedQuery(payload, resp, queryInstance = this.queryInstances.get(i))).isQueryComplete());
            this.handleQueryResult(decoder);
        }
        this.completionHandler.handle((Object)CommandResponse.success((Object)hasMoreResults));
    }

    @Override
    void decodeUpdate(ByteBuf payload) {
        DRDAQueryResponse updateResponse = new DRDAQueryResponse(payload, this.encoder.socketConnection.connMetadata);
        for (int i = 0; i < this.params.size(); ++i) {
            this.handleUpdateResult(updateResponse);
        }
        if (((ExtendedQueryCommand)this.cmd).autoCommit()) {
            updateResponse.readLocalCommit();
        }
        this.completionHandler.handle((Object)CommandResponse.success((Object)true));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(", params=");
        sb.append("[");
        sb.append(((ExtendedQueryCommand)this.cmd).paramsList().stream().map(Tuple::deepToString).collect(Collectors.joining(",")));
        sb.append("]");
        return sb.toString();
    }
}

