/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.drda;

import io.netty.buffer.ByteBuf;
import io.vertx.db2client.impl.drda.CCSIDConstants;
import io.vertx.db2client.impl.drda.ColumnMetaData;
import io.vertx.db2client.impl.drda.ConnectionMetaData;
import io.vertx.db2client.impl.drda.DRDAConnectRequest;
import io.vertx.db2client.impl.drda.FdocaConstants;
import io.vertx.db2client.impl.drda.Section;
import io.vertx.db2client.impl.drda.Typdef;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.RowId;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.UUID;

public class DRDAQueryRequest
extends DRDAConnectRequest {
    private static final String COLLECTIONNAME = "NULLID";
    public static final int defaultFetchSize = 64;
    private ArrayList<Integer> extdtaPositions_ = null;
    private final HashMap<Integer, Object> promototedParameters_ = new HashMap();

    public DRDAQueryRequest(ByteBuf buffer, ConnectionMetaData metadata) {
        super(buffer, metadata);
    }

    public static boolean isQuery(String sql) {
        if (sql != null) {
            String trimmedLower = sql.trim().toLowerCase();
            return trimmedLower.startsWith("select") || trimmedLower.startsWith("with") || trimmedLower.startsWith("values");
        }
        throw new IllegalArgumentException("SQLState.NULL_SQL_TEXT");
    }

    public void writePrepareDescribeOutput(String sql, String dbName, Section section) {
        this.buildPRPSQLSTT(section, sql, dbName, true, true, 4);
        String cursorAttrs = DRDAQueryRequest.isQuery(sql) ? "FOR READ ONLY " : "FOR UPDATE ";
        this.buildSQLATTRcommandData(cursorAttrs);
        this.buildSQLSTTcommandData(sql);
    }

    public void writeDescribeInput(Section section, String dbName) {
        int typsqlda = 5;
        this.buildDSCSQLSTT(section, dbName, true, typsqlda);
    }

    private void buildDSCSQLSTT(Section section, String dbName, boolean sendTypsqlda, int typsqlda) {
        this.createCommand();
        this.markLengthBytes(8200);
        this.buildPKGNAMCSN(dbName, section);
        if (sendTypsqlda) {
            this.buildTYPSQLDA(typsqlda);
        }
        this.updateLengthBytes();
    }

    private void buildEXCSQLSTT(Section section, String dbName, boolean sendOutexp, boolean outexp, boolean sendPrcnam, String prcnam, boolean sendQryblksz, boolean sendMaxrslcnt, int maxrslcnt, boolean sendMaxblkext, int maxblkext, boolean sendRslsetflg, int resultSetFlag, boolean sendQryrowset, int qryrowset) {
        this.createCommand();
        this.markLengthBytes(8203);
        this.buildPKGNAMCSN(dbName, section);
        this.buildRDBCMTOK();
        if (sendOutexp) {
            this.buildOUTEXP(outexp);
        }
        if (sendQryblksz) {
            this.buildQRYBLKSZ();
        }
        if (sendQryrowset && sendMaxblkext) {
            this.buildMAXBLKEXT(maxblkext);
        }
        if (sendMaxrslcnt) {
            this.buildMAXRSLCNT(maxrslcnt);
        }
        if (sendRslsetflg) {
            this.buildRSLSETFLG(resultSetFlag);
        }
        if (sendQryrowset) {
            this.buildQRYROWSET(qryrowset);
        }
        if (sendPrcnam) {
            this.buildPRCNAM(prcnam);
        }
        this.updateLengthBytes();
    }

    private void buildPRCNAM(String prcnam) {
        if (prcnam == null) {
            throw new IllegalArgumentException("SQLState.NET_NULL_PROCEDURE_NAME");
        }
        int prcnamLength = prcnam.length();
        if (prcnamLength == 0 || prcnamLength > 255) {
            throw new IllegalArgumentException("SQLState.NET_PROCEDURE_NAME_LENGTH_OUT_OF_RANGE: " + prcnamLength);
        }
        this.writeScalarString(8504, prcnam);
    }

    private void buildRSLSETFLG(int resultSetFlag) {
        this.writeScalar1Byte(8514, resultSetFlag);
    }

    private void buildMAXRSLCNT(int maxResultSetCount) {
        if (maxResultSetCount == 0) {
            return;
        }
        this.writeScalar2Bytes(8512, maxResultSetCount);
    }

    private void buildOUTEXP(boolean outputExpected) {
        if (outputExpected) {
            this.writeScalar1Byte(8465, -15);
        }
    }

    public void writeOpenQuery(Section section, String dbName, int fetchSize, int resultSetType, ColumnMetaData parameterMetaData, Object[] inputs) {
        fetchSize = this.checkFetchsize(fetchSize, resultSetType);
        this.buildOPNQRY(section, dbName, fetchSize);
        if (inputs != null && inputs.length > 0) {
            if (this.extdtaPositions_ != null && !this.extdtaPositions_.isEmpty()) {
                this.extdtaPositions_.clear();
            }
            boolean overrideExists = this.buildSQLDTAcommandData(parameterMetaData, inputs);
            this.buildEXTDTA(parameterMetaData, inputs, false);
        }
    }

    public void writeFetch(Section section, String dbName, int fetchSize, long queryId) {
        boolean sendQryrowset = true;
        boolean sendRtnextdta = false;
        if (sendQryrowset) {
            sendRtnextdta = true;
        } else if (fetchSize == 0) {
            sendQryrowset = false;
        }
        this.buildCNTQRY(section, dbName, sendQryrowset, queryId, fetchSize, sendRtnextdta);
    }

    private void buildOUTOVR(ColumnMetaData resultSetMetaData, boolean firstOutovrBuilt, boolean hasLobs) {
    }

    private void buildCNTQRY(Section section, String dbName, boolean sendQryrowset, long queryInstanceIdentifier, int qryrowsetSize, boolean sendRtnextdta) {
        this.buildCoreCNTQRY(section, dbName, sendQryrowset, queryInstanceIdentifier, qryrowsetSize);
        if (sendRtnextdta) {
            this.buildRTNEXTDTA(2);
        }
        this.updateLengthBytes();
    }

    private void buildRTNEXTDTA(int rtnextdta) {
        this.writeScalar1Byte(8520, rtnextdta);
    }

    private void buildCoreCNTQRY(Section section, String dbName, boolean sendQryrowset, long queryInstanceIdentifier, int qryrowsetSize) {
        this.createCommand();
        this.markLengthBytes(8198);
        this.buildPKGNAMCSN(dbName, section);
        this.buildQRYBLKSZ();
        if (sendQryrowset) {
            this.buildMAXBLKEXT(-1);
        }
        this.buildQRYINSID(queryInstanceIdentifier);
        if (sendQryrowset) {
            this.buildQRYROWSET(qryrowsetSize);
        }
    }

    private void buildEXTDTA(ColumnMetaData parameterMetaData, Object[] inputRow, boolean chained) {
        if (this.extdtaPositions_ == null) {
            return;
        }
        throw new UnsupportedOperationException("EXTDTA");
    }

    private boolean buildSQLDTAcommandData(ColumnMetaData parameterMetaData, Object[] inputRow) {
        this.createEncryptedCommandData();
        int loc = this.buffer.writerIndex();
        this.markLengthBytes(9234);
        int[][] protocolTypesAndLengths = this.allocateLidAndLengthsArray(parameterMetaData);
        Hashtable protocolTypeToOverrideLidMapping = null;
        ArrayList mddOverrideArray = null;
        protocolTypeToOverrideLidMapping = this.computeProtocolTypesAndLengths(inputRow, parameterMetaData, protocolTypesAndLengths, protocolTypeToOverrideLidMapping);
        boolean overrideExists = false;
        this.buildFDODSC(inputRow.length, protocolTypesAndLengths, overrideExists, protocolTypeToOverrideLidMapping, mddOverrideArray);
        this.buildFDODTA(protocolTypesAndLengths, inputRow);
        this.updateLengthBytes();
        return overrideExists;
    }

    private void buildFDODTA(int[][] protocolTypesAndLengths, Object[] inputs) {
        Object o = null;
        this.markLengthBytes(5242);
        this.buffer.writeByte(0);
        block22: for (int i = 0; i < inputs.length; ++i) {
            if (inputs[i] == null) {
                if (protocolTypesAndLengths[i][0] % 2 != 1) continue;
                this.buffer.writeByte(255);
                continue;
            }
            if (protocolTypesAndLengths[i][0] % 2 == 1) {
                this.buffer.writeByte(0);
            }
            switch (protocolTypesAndLengths[i][0] | 1) {
                case 63: 
                case 65: {
                    o = this.retrievePromotedParameterIfExists(i);
                    if (o == null) {
                        String strInput = inputs[i] instanceof UUID ? ((UUID)inputs[i]).toString() : (inputs[i] instanceof Enum ? ((Enum)inputs[i]).name() : (String)inputs[i]);
                        this.writeSingleorMixedCcsidLDString(strInput, Typdef.typdef.getCcsidMbcEncoding());
                        continue block22;
                    }
                    throw new UnsupportedOperationException("CLOB");
                }
                case 51: 
                case 53: {
                    o = this.retrievePromotedParameterIfExists(i);
                    if (o == null) continue block22;
                    throw new UnsupportedOperationException("CLOB");
                }
                case 191: {
                    this.buffer.writeBoolean(((Boolean)inputs[i]).booleanValue());
                    continue block22;
                }
                case 3: {
                    this.buffer.writeInt(((Number)inputs[i]).intValue());
                    continue block22;
                }
                case 5: {
                    if (inputs[i] instanceof Boolean) {
                        this.buffer.writeShort((Boolean)inputs[i] != false ? 1 : 0);
                        continue block22;
                    }
                    this.buffer.writeShort((int)((Number)inputs[i]).shortValue());
                    continue block22;
                }
                case 13: {
                    this.buffer.writeFloat(((Number)inputs[i]).floatValue());
                    continue block22;
                }
                case 11: {
                    this.buffer.writeDouble(((Number)inputs[i]).doubleValue());
                    continue block22;
                }
                case 15: {
                    this.writeBigDecimal((BigDecimal)inputs[i], protocolTypesAndLengths[i][1] >> 8 & 0xFF, protocolTypesAndLengths[i][1] & 0xFF);
                    continue block22;
                }
                case 33: {
                    if (inputs[i] instanceof LocalDate) {
                        this.writeDate((LocalDate)inputs[i]);
                        continue block22;
                    }
                    if (inputs[i] instanceof Date) {
                        this.writeDate((Date)inputs[i]);
                        continue block22;
                    }
                    throw new UnsupportedOperationException("Unsupported input type for DATE column: " + inputs[i].getClass());
                }
                case 35: {
                    if (inputs[i] instanceof LocalTime) {
                        this.writeTime((LocalTime)inputs[i]);
                        continue block22;
                    }
                    if (inputs[i] instanceof Time) {
                        this.writeTime((Time)inputs[i]);
                        continue block22;
                    }
                    throw new UnsupportedOperationException("Unsupported input type for TIME column: " + inputs[i].getClass());
                }
                case 37: {
                    if (inputs[i] instanceof LocalDateTime) {
                        this.writeTimestamp((LocalDateTime)inputs[i]);
                        continue block22;
                    }
                    if (inputs[i] instanceof Timestamp) {
                        this.writeTimestamp((Timestamp)inputs[i]);
                        continue block22;
                    }
                    throw new UnsupportedOperationException("Unsupported input type for TIMESTAMP column: " + inputs[i].getClass());
                }
                case 23: {
                    this.buffer.writeLong(((Long)inputs[i]).longValue());
                    continue block22;
                }
                case 31: {
                    RowId rowId = (RowId)inputs[i];
                    this.writeLDBytes(rowId.getBytes());
                    continue block22;
                }
                case 41: 
                case 43: {
                    o = this.retrievePromotedParameterIfExists(i);
                    if (o == null) {
                        if (inputs[i] instanceof byte[]) {
                            this.writeLDBytes((byte[])inputs[i]);
                            continue block22;
                        }
                        if (inputs[i] instanceof ByteBuf) {
                            this.writeLDBytes((ByteBuf)inputs[i]);
                            continue block22;
                        }
                        throw new UnsupportedOperationException("Cannot write " + inputs[i].getClass() + " as VARBYTE/LONGVARBYTE");
                    }
                    throw new UnsupportedOperationException("CLOB");
                }
                case 81: {
                    throw new UnsupportedOperationException("DRDA_TYPE_NUDT");
                }
                case 203: 
                case 205: {
                    throw new UnsupportedOperationException("DRDA_TYPE_NLOBCDBCS");
                }
                case 201: {
                    throw new UnsupportedOperationException("DRDA_TYPE_NLOBBYTES");
                }
                case 207: {
                    throw new UnsupportedOperationException("DRDA_TYPE_NLOBCMIXED");
                }
                case 25: {
                    throw new UnsupportedOperationException("DRDA_TYPE_NLOBLOC");
                }
                case 27: {
                    throw new UnsupportedOperationException("DRDA_TYPE_NCLOBLOC");
                }
                default: {
                    throw new IllegalStateException("SQLState.NET_UNRECOGNIZED_JDBC_TYPE " + protocolTypesAndLengths[i][0] + inputs.length + i);
                }
            }
        }
        this.updateLengthBytes();
    }

    private void buildFDODSC(int numColumns, int[][] protocolTypesAndLengths, boolean overrideExists, Hashtable overrideMap, ArrayList overrideArray) {
        this.markLengthBytes(16);
        this.buildSQLDTA(numColumns, protocolTypesAndLengths, overrideExists, overrideMap, overrideArray);
        this.updateLengthBytes();
    }

    private void buildSQLDTA(int numColumns, int[][] lidAndLengthOverrides, boolean overrideExists, Hashtable overrideMap, ArrayList overrideArray) {
        if (overrideExists) {
            this.buildMddOverrides(overrideArray);
            this.buffer.writeBytes(FdocaConstants.MDD_SQLDTAGRP_TOSEND);
        }
        this.buildSQLDTAGRP(numColumns, lidAndLengthOverrides, overrideExists, overrideMap);
        if (overrideExists) {
            this.buffer.writeBytes(FdocaConstants.MDD_SQLDTA_TOSEND);
        }
        this.buffer.writeBytes(FdocaConstants.SQLDTA_RLO_TOSEND);
    }

    private void buildMddOverrides(ArrayList sdaOverrides) {
        for (int i = 0; i < sdaOverrides.size(); ++i) {
            byte[] mddBytes = (byte[])sdaOverrides.get(i);
            this.buffer.writeBytes(mddBytes);
        }
    }

    private void buildSQLDTAGRP(int numVars, int[][] lidAndLengthOverrides, boolean mddRequired, Hashtable overrideMap) {
        int n = 0;
        int offset = 0;
        n = this.calculateColumnsInSQLDTAGRPtriplet(numVars);
        this.buildTripletHeader(3 * n + 3, 118, 208);
        while (true) {
            this.writeLidAndLengths(lidAndLengthOverrides, n, offset, mddRequired, overrideMap);
            if ((numVars -= n) == 0) break;
            offset += n;
            n = this.calculateColumnsInSQLDTAGRPtriplet(numVars);
            this.buildTripletHeader(3 * n + 3, 127, 0);
        }
    }

    private int calculateColumnsInSQLDTAGRPtriplet(int numVars) {
        if (numVars > 84) {
            return 84;
        }
        return numVars;
    }

    private int[][] allocateLidAndLengthsArray(ColumnMetaData parameterMetaData) {
        int numVars = parameterMetaData.columns_;
        int[][] lidAndLengths = parameterMetaData.protocolTypesCache_;
        if (lidAndLengths == null || lidAndLengths.length != numVars) {
            parameterMetaData.protocolTypesCache_ = lidAndLengths = new int[numVars][2];
        }
        return lidAndLengths;
    }

    private Hashtable computeProtocolTypesAndLengths(Object[] inputRow, ColumnMetaData parameterMetaData, int[][] lidAndLengths, Hashtable overrideMap) {
        int numVars = parameterMetaData.columns_;
        String s = null;
        for (int i = 0; i < numVars; ++i) {
            int jdbcType = parameterMetaData.clientParamtertype_[i];
            if (jdbcType == 0) {
                jdbcType = parameterMetaData.types_[i];
            }
            if (jdbcType == 0) {
                throw new IllegalStateException("SQLState.NET_INVALID_JDBC_TYPE_FOR_PARAM " + i);
            }
            switch (jdbcType) {
                case 1: 
                case 12: {
                    if (inputRow[i] == null) {
                        s = null;
                    } else if (inputRow[i] instanceof String) {
                        s = (String)inputRow[i];
                    } else if (inputRow[i] instanceof UUID) {
                        s = ((UUID)inputRow[i]).toString();
                    }
                    if (s == null || s.length() <= 10922) {
                        lidAndLengths[i][0] = 63;
                        lidAndLengths[i][1] = Short.MAX_VALUE;
                        break;
                    }
                    throw new UnsupportedOperationException("CLOB");
                }
                case 4: {
                    lidAndLengths[i][0] = 3;
                    lidAndLengths[i][1] = 4;
                    break;
                }
                case -7: 
                case 16: {
                    lidAndLengths[i][0] = 191;
                    lidAndLengths[i][1] = 1;
                    break;
                }
                case -6: 
                case 5: {
                    lidAndLengths[i][0] = 5;
                    lidAndLengths[i][1] = 2;
                    break;
                }
                case 7: {
                    lidAndLengths[i][0] = 13;
                    lidAndLengths[i][1] = 4;
                    break;
                }
                case 6: 
                case 8: {
                    lidAndLengths[i][0] = 11;
                    lidAndLengths[i][1] = 8;
                    break;
                }
                case 2: 
                case 3: {
                    int precision;
                    int scale;
                    BigDecimal bigDecimal = (BigDecimal)inputRow[i];
                    if (bigDecimal == null) {
                        scale = 0;
                        precision = 1;
                    } else {
                        if (bigDecimal.scale() < 0) {
                            bigDecimal = bigDecimal.setScale(0);
                            inputRow[i] = bigDecimal;
                        }
                        if (bigDecimal.precision() > parameterMetaData.sqlPrecision_[i]) {
                            bigDecimal = bigDecimal.round(new MathContext(parameterMetaData.sqlPrecision_[i]));
                            inputRow[i] = bigDecimal;
                        }
                        if (bigDecimal.scale() > parameterMetaData.sqlScale_[i]) {
                            bigDecimal = bigDecimal.setScale(parameterMetaData.sqlScale_[i], RoundingMode.HALF_UP);
                            inputRow[i] = bigDecimal;
                        }
                        scale = bigDecimal.scale();
                        precision = bigDecimal.precision();
                    }
                    lidAndLengths[i][0] = 15;
                    lidAndLengths[i][1] = (precision << 8) + (scale << 0);
                    break;
                }
                case 91: {
                    lidAndLengths[i][0] = 33;
                    lidAndLengths[i][1] = 10;
                    break;
                }
                case 92: {
                    lidAndLengths[i][0] = 35;
                    lidAndLengths[i][1] = 8;
                    break;
                }
                case 93: {
                    lidAndLengths[i][0] = 37;
                    lidAndLengths[i][1] = 26;
                    break;
                }
                case -5: {
                    lidAndLengths[i][0] = 23;
                    lidAndLengths[i][1] = 8;
                    break;
                }
                case -1: {
                    s = (String)inputRow[i];
                    if (s == null || s.length() <= 10922) {
                        lidAndLengths[i][0] = 65;
                        lidAndLengths[i][1] = Short.MAX_VALUE;
                        break;
                    }
                    throw new UnsupportedOperationException("CLOB");
                }
                case -8: {
                    lidAndLengths[i][0] = 31;
                    lidAndLengths[i][1] = 40;
                    break;
                }
                case -3: 
                case -2: {
                    int length = -1;
                    if (inputRow[i] instanceof byte[]) {
                        length = ((byte[])inputRow[i]).length;
                    } else if (inputRow[i] instanceof ByteBuf) {
                        length = ((ByteBuf)inputRow[i]).readableBytes();
                    }
                    if (inputRow[i] == null) {
                        lidAndLengths[i][0] = 41;
                        lidAndLengths[i][1] = Short.MAX_VALUE;
                        break;
                    }
                    if (length <= Short.MAX_VALUE) {
                        lidAndLengths[i][0] = 41;
                        lidAndLengths[i][1] = Short.MAX_VALUE;
                        break;
                    }
                    throw new UnsupportedOperationException("BLOB");
                }
                case -4: {
                    int length = -1;
                    if (inputRow[i] instanceof byte[]) {
                        length = ((byte[])inputRow[i]).length;
                    } else if (inputRow[i] instanceof ByteBuf) {
                        length = ((ByteBuf)inputRow[i]).readableBytes();
                    }
                    if (inputRow[i] == null) {
                        lidAndLengths[i][0] = 43;
                        lidAndLengths[i][1] = Short.MAX_VALUE;
                        break;
                    }
                    if (length <= Short.MAX_VALUE) {
                        lidAndLengths[i][0] = 43;
                        lidAndLengths[i][1] = Short.MAX_VALUE;
                        break;
                    }
                    throw new UnsupportedOperationException("BLOB");
                }
                case 2000: {
                    lidAndLengths[i][0] = 81;
                    lidAndLengths[i][1] = Short.MAX_VALUE;
                    break;
                }
                case 2004: {
                    throw new UnsupportedOperationException("BLOB");
                }
                case 2005: {
                    throw new UnsupportedOperationException("CLOB");
                }
                default: {
                    throw new IllegalArgumentException("SQLState.UNRECOGNIZED_JAVA_SQL_TYPE: " + jdbcType);
                }
            }
            if (parameterMetaData.nullable_[i]) continue;
            int[] nArray = lidAndLengths[i];
            nArray[0] = nArray[0] - 1;
        }
        return overrideMap;
    }

    private Object retrievePromotedParameterIfExists(int index) {
        if (this.promototedParameters_.isEmpty()) {
            return null;
        }
        return this.promototedParameters_.get(index);
    }

    private void setFDODTALobLength(int[][] protocolTypesAndLengths, int i, long dataLength) {
        if (protocolTypesAndLengths[i][1] == 32770) {
            this.buffer.writeShort((int)((short)dataLength));
        } else if (protocolTypesAndLengths[i][1] == 32772) {
            this.buffer.writeInt((int)dataLength);
        } else if (protocolTypesAndLengths[i][1] == 32774) {
            this.writeLong6Bytes(dataLength);
        } else if (protocolTypesAndLengths[i][1] == 32776) {
            this.buffer.writeLong(dataLength);
        }
        if (dataLength != 0L) {
            if (this.extdtaPositions_ == null) {
                this.extdtaPositions_ = new ArrayList();
            }
            this.extdtaPositions_.add(i);
        }
    }

    private void setFDODTALobLengthUnknown(int i) {
        int v = 1;
        short s = (short)(v << 15);
        v = s;
        this.buffer.writeShort((int)s);
        if (this.extdtaPositions_ == null) {
            this.extdtaPositions_ = new ArrayList();
        }
        this.extdtaPositions_.add(i);
    }

    public void writeOpenQuery(Section section, String dbName, int fetchSize, int resultSetType) {
        fetchSize = this.checkFetchsize(fetchSize, resultSetType);
        this.buildOPNQRY(section, dbName, fetchSize);
    }

    public void writeExecute(Section section, String dbName, ColumnMetaData parameterMetaData, Object[] inputs, boolean outputExpected, boolean chained) {
        this.buildEXCSQLSTT(section, dbName, true, outputExpected, false, null, false, false, 0, false, 0, false, 0, false, 0);
        if (inputs != null && inputs.length > 0) {
            if (this.extdtaPositions_ != null && !this.extdtaPositions_.isEmpty()) {
                this.extdtaPositions_.clear();
            }
            boolean overrideExists = this.buildSQLDTAcommandData(parameterMetaData, inputs);
            this.buildEXTDTA(parameterMetaData, inputs, chained);
        }
    }

    public void writeExecuteImmediate(String sql, Section section, String dbName) {
        this.buildEXCSQLIMM(section, dbName, false, 0L);
        this.buildSQLSTTcommandData(sql);
    }

    private void buildEXCSQLIMM(Section section, String dbName, boolean sendQryinsid, long qryinsid) {
        this.createCommand();
        this.markLengthBytes(8202);
        this.buildPKGNAMCSN(dbName, section);
        this.buildRDBCMTOK();
        if (sendQryinsid) {
            this.buildQRYINSID(qryinsid);
        }
        this.updateLengthBytes();
    }

    private void buildRDBCMTOK() {
        this.writeScalar1Byte(8453, -15);
    }

    public void buildCLSQRY(Section section, String dbName, long queryInstanceIdentifier) {
        this.createCommand();
        this.markLengthBytes(8197);
        this.buildPKGNAMCSN(dbName, section);
        this.buildQRYINSID(queryInstanceIdentifier);
        this.updateLengthBytes();
    }

    void buildQRYINSID(long qryinsid) {
        this.markLengthBytes(8539);
        this.buffer.writeLong(qryinsid);
        this.updateLengthBytes();
    }

    private void buildOPNQRY(Section section, String dbName, int fetchSize) {
        this.createCommand();
        this.markLengthBytes(8204);
        this.buildPKGNAMCSN(dbName, section);
        this.buildQRYBLKSZ();
        if (fetchSize != 0) {
            this.buildQRYROWSET(fetchSize);
        }
        this.buildQRYCLSIMP();
        this.updateLengthBytes();
    }

    private void buildQRYCLSIMP() {
        this.writeScalar1Byte(8541, 1);
    }

    void buildMAXBLKEXT(int maxNumOfExtraBlocks) {
        if (maxNumOfExtraBlocks != 0) {
            this.writeScalar2Bytes(8513, maxNumOfExtraBlocks);
        }
    }

    void buildQRYROWSET(int fetchSize) {
        this.writeScalar4Bytes(8534, fetchSize);
    }

    void buildQRYBLKSZ() {
        this.writeScalar4Bytes(8468, 32767L);
    }

    private int checkFetchsize(int fetchSize, int resultSetType) {
        if (resultSetType != 1003 && fetchSize == 0) {
            fetchSize = 64;
        }
        return fetchSize;
    }

    private boolean checkSendQryrowset(int fetchSize, int resultSetType) {
        boolean sendQryrowset = false;
        if (resultSetType != 1003) {
            sendQryrowset = true;
        }
        return sendQryrowset;
    }

    protected void buildSQLSTTcommandData(String sql) {
        this.createEncryptedCommandData();
        this.markLengthBytes(9236);
        this.buildSQLSTT(sql);
        this.updateLengthBytes();
    }

    protected void buildSQLATTRcommandData(String sql) {
        this.createEncryptedCommandData();
        this.markLengthBytes(9296);
        this.buildSQLSTT(sql);
        this.updateLengthBytes();
    }

    private void buildNOCMorNOCS(String string) {
        if (string == null) {
            this.buffer.writeShort(65535);
        } else if (Typdef.typdef.isCcsidMbcSet()) {
            byte[] sqlBytes = string.getBytes(Typdef.typdef.getCcsidMbcEncoding());
            this.buffer.writeByte(0);
            this.buffer.writeInt(sqlBytes.length);
            this.buffer.writeBytes(sqlBytes);
            this.buffer.writeByte(255);
        } else {
            byte[] sqlBytes = string.getBytes(Typdef.typdef.getCcsidSbcEncoding());
            this.buffer.writeByte(255);
            this.buffer.writeByte(0);
            this.buffer.writeInt(sqlBytes.length);
            this.buffer.writeBytes(sqlBytes);
        }
    }

    private void buildSQLSTTGRP(String string) {
        this.buildNOCMorNOCS(string);
    }

    private void buildSQLSTT(String string) {
        this.buildSQLSTTGRP(string);
    }

    private void buildPRPSQLSTT(Section section, String sql, String dbName, boolean sendRtnsqlda, boolean sendTypsqlda, int typsqlda) {
        this.createCommand();
        this.markLengthBytes(8205);
        this.buildPKGNAMCSN(dbName, section);
        if (sendRtnsqlda) {
            this.buildRTNSQLDA();
        }
        if (sendTypsqlda) {
            this.buildTYPSQLDA(typsqlda);
        }
        this.updateLengthBytes();
    }

    private void buildTYPSQLDA(int typeSqlda) {
        if (typeSqlda != 0) {
            this.writeScalar1Byte(8518, typeSqlda);
        }
    }

    private void buildRTNSQLDA() {
        this.writeScalar1Byte(8470, -15);
    }

    void buildPKGNAMCSN(String dbName, Section section) {
        this.markLengthBytes(8467);
        if (section.pkg.pkgNameConsistencyBytes != null) {
            this.writeStoredPKGNAMCBytes(section);
        } else {
            this.markForCachingPKGNAMCSN();
            this.buildCommonPKGNAMinfo(dbName, section);
            this.writeScalarPaddedBytes(CCSIDConstants.UTF8.encode("SYSLVL01").array(), 8, (byte)0);
            this.storePKGNAMCBytes(section);
        }
        this.buffer.writeShort(section.number);
        this.updateLengthBytes();
    }

    private void storePKGNAMCBytes(Section section) {
        int startPos = this.popMarkForCachingPKGNAMCSN();
        byte[] b = new byte[this.buffer.writerIndex() - startPos];
        this.buffer.getBytes(startPos, b);
        section.pkg.pkgNameConsistencyBytes = b;
    }

    private void writeStoredPKGNAMCBytes(Section section) {
        this.buffer.writeBytes(section.pkg.pkgNameConsistencyBytes);
    }

    private final void mark() {
        this.markStack.push(this.buffer.writerIndex());
    }

    private final int popMark() {
        return (Integer)this.markStack.pop();
    }

    protected final void markForCachingPKGNAMCSN() {
        this.mark();
    }

    protected final int popMarkForCachingPKGNAMCSN() {
        return this.popMark();
    }

    private void buildCommonPKGNAMinfo(String dbName, Section section) {
        String collectionToFlow = COLLECTIONNAME;
        int maxIdentifierLength = 255;
        byte[] dbnameBytes = this.metadata.getCCSID().encode(dbName).array();
        byte[] collectionToFlowBytes = this.metadata.getCCSID().encode(collectionToFlow).array();
        byte[] pkgNameBytes = this.metadata.getCCSID().encode(section.pkg.name).array();
        boolean scldtalenRequired = this.checkPKGNAMlengths(dbName, dbnameBytes.length, 1024, 18);
        if (!scldtalenRequired) {
            scldtalenRequired = this.checkPKGNAMlengths(collectionToFlow, collectionToFlowBytes.length, maxIdentifierLength, 18);
        }
        if (!scldtalenRequired) {
            scldtalenRequired = this.checkPKGNAMlengths(section.pkg.name, pkgNameBytes.length, maxIdentifierLength, 18);
        }
        if (!scldtalenRequired) {
            byte padByte = this.metadata.getCCSID().encode(" ").get();
            this.writeScalarPaddedBytes(dbnameBytes, 18, padByte);
            this.writeScalarPaddedBytes(collectionToFlowBytes, 18, padByte);
            this.writeScalarPaddedBytes(pkgNameBytes, 18, padByte);
        } else {
            this.buildSCLDTA(dbnameBytes, 18);
            this.buildSCLDTA(collectionToFlowBytes, 18);
            this.buildSCLDTA(pkgNameBytes, 18);
        }
    }

    private void buildSCLDTA(byte[] identifier, int minimumLength) {
        int length = Math.max(minimumLength, identifier.length);
        this.buffer.writeShort(length);
        byte padByte = this.metadata.getCCSID().encode(" ").get();
        this.writeScalarPaddedBytes(identifier, length, padByte);
    }

    private boolean checkPKGNAMlengths(String identifier, int length, int maxIdentifierLength, int lengthRequiringScldta) {
        if (length > maxIdentifierLength) {
            throw new IllegalArgumentException("SQLState.LANG_IDENTIFIER_TOO_LONG " + length);
        }
        return length > lengthRequiringScldta;
    }
}

