/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.drda;

import io.vertx.db2client.impl.drda.CCSIDConstants;
import io.vertx.db2client.impl.drda.ConnectionMetaData;
import io.vertx.db2client.impl.drda.Cursor;
import io.vertx.db2client.impl.drda.FdocaSimpleDataArray;
import java.nio.charset.Charset;

public class Typdef
implements Cloneable {
    public static final Typdef typdef = new Typdef(1208, "QTDSQLASC", 1200, 1208);
    public static final Typdef targetTypdef;
    public static final Typdef originalTargetTypdef_;
    private static final short CCSIDDBC = 1;
    private static final short CCSIDMBC = 2;
    private static final short CCSIDSBC = 3;
    private static final short NOCCSID = 0;
    public static final short FIXEDLENGTH = 0;
    public static final short TWOBYTELENGTH = 1;
    public static final short ONEBYTELENGTH = 2;
    public static final short DECIMALLENGTH = 3;
    public static final short LOBLENGTH = 4;
    private static final int OVERRIDE_TABLE_SIZE = 255;
    private static final int[] fdocaTypeToRepresentationMap_;
    private static final FdocaSimpleDataArray[] environmentTables_;
    private static final int[] protocolToJdbcTypes_;
    private String typdefnam_;
    private int ccsidSbc_;
    private boolean ccsidSbcSet_;
    private Charset ccsidSbcEncoding_;
    private int ccsidDbc_;
    private boolean ccsidDbcSet_;
    private Charset ccsidDbcEncoding_;
    private int ccsidMbc_;
    private boolean ccsidMbcSet_;
    private Charset ccsidMbcEncoding_;
    private boolean mddOverride_ = false;
    private FdocaSimpleDataArray[] overrideTable_ = new FdocaSimpleDataArray[255];

    Typdef() {
        this.initialize(0, false, 0, false, 0, false, null);
    }

    Typdef(int ccsidSbc, String typdefnam, int ccsidDbc, int ccsidMbc) {
        this.initialize(ccsidSbc, true, ccsidMbc, true, ccsidDbc, true, typdefnam);
    }

    private void initialize(int ccsidSbc, boolean ccsidSbcSet, int ccsidMbc, boolean ccsidMbcSet, int ccsidDbc, boolean ccsidDbcSet, String typdefnam) {
        this.ccsidSbc_ = ccsidSbc;
        this.ccsidSbcSet_ = ccsidSbcSet;
        this.ccsidSbcEncoding_ = null;
        this.ccsidMbc_ = ccsidMbc;
        this.ccsidMbcSet_ = ccsidMbcSet;
        this.ccsidMbcEncoding_ = null;
        this.ccsidDbc_ = ccsidDbc;
        this.ccsidDbcSet_ = ccsidDbcSet;
        this.ccsidDbcEncoding_ = null;
        this.setTypdefnam(typdefnam);
    }

    String getTypdefnam() {
        return this.typdefnam_;
    }

    void setTypdefnam(String typdefnam) {
        this.typdefnam_ = typdefnam;
        if (this.typdefnam_ == null) {
            return;
        }
    }

    int getCcsidSbc() {
        return this.ccsidSbc_;
    }

    void setCcsidSbc(int ccsid) {
        this.ccsidSbc_ = ccsid;
        this.ccsidSbcSet_ = true;
        this.ccsidSbcEncoding_ = null;
    }

    boolean isCcsidSbcSet() {
        return this.ccsidSbcSet_;
    }

    Charset getCcsidSbcEncoding() {
        if (this.ccsidSbcEncoding_ == null) {
            this.ccsidSbcEncoding_ = CCSIDConstants.UTF8;
        }
        return this.ccsidSbcEncoding_;
    }

    int getCcsidDbc() {
        return this.ccsidDbc_;
    }

    void setCcsidDbc(int ccsid) {
        this.ccsidDbc_ = ccsid;
        this.ccsidDbcSet_ = true;
        this.ccsidDbcEncoding_ = null;
    }

    boolean isCcsidDbcSet() {
        return this.ccsidDbcSet_;
    }

    private Charset getCcsidDbcEncoding() {
        if (this.ccsidDbcEncoding_ == null) {
            this.ccsidDbcEncoding_ = CCSIDConstants.UTF8;
        }
        return this.ccsidDbcEncoding_;
    }

    int getCcsidMbc() {
        return this.ccsidMbc_;
    }

    void setCcsidMbc(int ccsid) {
        this.ccsidMbc_ = ccsid;
        this.ccsidMbcSet_ = true;
        this.ccsidMbcEncoding_ = null;
    }

    boolean isCcsidMbcSet() {
        return this.ccsidMbcSet_;
    }

    Charset getCcsidMbcEncoding() {
        if (this.ccsidMbcEncoding_ == null) {
            this.ccsidMbcEncoding_ = CCSIDConstants.UTF8;
        }
        return this.ccsidMbcEncoding_;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    void updateColumn(Cursor netCursor, ConnectionMetaData metadata, int columnIndex, int protocolLid, int protocolLength) {
        FdocaSimpleDataArray sda = environmentTables_[protocolLid];
        if (this.mddOverride_ && this.overrideTable_[protocolLid] != null) {
            sda = this.overrideTable_[protocolLid];
        }
        if (sda == null) {
            throw new IllegalStateException("SQLState.NET_INVALID_FDOCA_ID");
        }
        netCursor.nullable_[columnIndex] = sda.protocolType_ % 2 == 1;
        switch (sda.ccsid_) {
            case 3: {
                netCursor.charset_[columnIndex] = this.getCcsidSbcEncoding();
                netCursor.ccsid_[columnIndex] = this.ccsidSbc_;
                break;
            }
            case 2: {
                if (this.isCcsidMbcSet() && this.ccsidMbc_ != 0) {
                    netCursor.charset_[columnIndex] = this.getCcsidMbcEncoding();
                    netCursor.ccsid_[columnIndex] = this.ccsidMbc_;
                    break;
                }
                netCursor.charset_[columnIndex] = null;
                netCursor.ccsid_[columnIndex] = 0;
                break;
            }
            case 1: {
                if (this.isCcsidDbcSet() && this.ccsidDbc_ != 0) {
                    netCursor.charset_[columnIndex] = this.getCcsidDbcEncoding();
                    netCursor.ccsid_[columnIndex] = this.ccsidDbc_;
                    break;
                }
                netCursor.charset_[columnIndex] = null;
                netCursor.ccsid_[columnIndex] = 0;
                break;
            }
            default: {
                netCursor.charset_[columnIndex] = metadata.isZos() ? CCSIDConstants.EBCDIC : CCSIDConstants.UTF8;
                netCursor.ccsid_[columnIndex] = sda.ccsid_;
            }
        }
        if (sda.protocolType_ >= 200 && sda.protocolType_ <= 207) {
            netCursor.fdocaLength_[columnIndex] = protocolLength;
            netCursor.hasLobs_ = true;
        } else {
            netCursor.fdocaLength_[columnIndex] = protocolLength;
        }
        netCursor.jdbcTypes_[columnIndex] = protocolToJdbcTypes_[sda.protocolType_];
        if (netCursor.jdbcTypes_[columnIndex] == 0) {
            // empty if block
        }
        netCursor.typeToUseForComputingDataLength_[columnIndex] = sda.typeToUseForComputingDataLength_;
        switch (netCursor.typeToUseForComputingDataLength_[columnIndex]) {
            case 3: {
                netCursor.maximumRowSize_ += 17;
                break;
            }
            case 4: {
                netCursor.maximumRowSize_ += 1 + (netCursor.fdocaLength_[columnIndex] & Short.MAX_VALUE);
                break;
            }
            default: {
                netCursor.maximumRowSize_ += 1 + netCursor.fdocaLength_[columnIndex] + 2;
            }
        }
        if (sda.characterSize_ == 2) {
            netCursor.isGraphic_[columnIndex] = true;
        }
    }

    void clearMddOverrides() {
        if (!this.mddOverride_) {
            return;
        }
        this.mddOverride_ = false;
        for (int i = 0; i < 255; ++i) {
            this.overrideTable_[i] = null;
        }
    }

    void setMddOverride(int protocolType, int fdocaTripletLid, int fdocaFieldType, int ccsid, int characterSize, int mode, int length) {
        this.mddOverride_ = true;
        if (this.overrideTable_[fdocaTripletLid] == null) {
            this.overrideTable_[fdocaTripletLid] = new FdocaSimpleDataArray(protocolType, ccsid, characterSize, this.mapFdocaTypeToTypeToUseForComputingDataLength(fdocaFieldType));
        } else {
            this.overrideTable_[fdocaTripletLid].update(protocolType, ccsid, characterSize, this.mapFdocaTypeToTypeToUseForComputingDataLength(fdocaFieldType));
        }
    }

    private int mapFdocaTypeToTypeToUseForComputingDataLength(int fdocaFieldType) {
        switch (fdocaFieldType & 0x7F) {
            case 2: 
            case 17: {
                return 1;
            }
            case 48: 
            case 50: {
                return 3;
            }
            case 80: 
            case 81: {
                return 4;
            }
            case 7: 
            case 25: {
                return 2;
            }
        }
        return 0;
    }

    static {
        originalTargetTypdef_ = targetTypdef = new Typdef();
        fdocaTypeToRepresentationMap_ = new int[]{0, 4, 2, 7, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 3, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        environmentTables_ = new FdocaSimpleDataArray[]{null, null, new FdocaSimpleDataArray(2, 0, 0, 0), new FdocaSimpleDataArray(3, 0, 0, 0), new FdocaSimpleDataArray(4, 0, 0, 0), new FdocaSimpleDataArray(5, 0, 0, 0), new FdocaSimpleDataArray(6, 0, 0, 0), new FdocaSimpleDataArray(7, 0, 0, 0), new FdocaSimpleDataArray(8, 0, 0, 0), new FdocaSimpleDataArray(9, 0, 0, 0), new FdocaSimpleDataArray(10, 0, 0, 0), new FdocaSimpleDataArray(11, 0, 0, 0), new FdocaSimpleDataArray(12, 0, 0, 0), new FdocaSimpleDataArray(13, 0, 0, 0), new FdocaSimpleDataArray(14, 0, 0, 3), new FdocaSimpleDataArray(15, 0, 0, 3), null, null, null, null, null, null, new FdocaSimpleDataArray(22, 0, 0, 0), new FdocaSimpleDataArray(23, 0, 0, 0), new FdocaSimpleDataArray(24, 0, 0, 0), new FdocaSimpleDataArray(25, 0, 0, 0), null, new FdocaSimpleDataArray(27, 0, 0, 0), new FdocaSimpleDataArray(28, 0, 0, 0), new FdocaSimpleDataArray(29, 0, 0, 0), new FdocaSimpleDataArray(30, 0, 0, 1), new FdocaSimpleDataArray(31, 0, 0, 1), new FdocaSimpleDataArray(32, 3, 1, 0), new FdocaSimpleDataArray(33, 3, 1, 0), new FdocaSimpleDataArray(34, 3, 1, 0), new FdocaSimpleDataArray(35, 3, 1, 0), new FdocaSimpleDataArray(36, 3, 1, 0), new FdocaSimpleDataArray(37, 3, 1, 0), new FdocaSimpleDataArray(38, 0, 0, 0), new FdocaSimpleDataArray(39, 0, 0, 0), new FdocaSimpleDataArray(40, 0, 0, 1), new FdocaSimpleDataArray(41, 0, 0, 1), new FdocaSimpleDataArray(42, 0, 0, 1), new FdocaSimpleDataArray(43, 0, 0, 1), new FdocaSimpleDataArray(44, 0, 0, 0), new FdocaSimpleDataArray(45, 0, 0, 0), new FdocaSimpleDataArray(46, 3, 1, 0), new FdocaSimpleDataArray(47, 3, 1, 0), new FdocaSimpleDataArray(48, 3, 1, 0), new FdocaSimpleDataArray(49, 3, 1, 0), new FdocaSimpleDataArray(50, 3, 1, 1), new FdocaSimpleDataArray(51, 3, 1, 1), new FdocaSimpleDataArray(52, 3, 1, 1), new FdocaSimpleDataArray(53, 3, 1, 1), new FdocaSimpleDataArray(54, 1, 2, 0), new FdocaSimpleDataArray(55, 1, 2, 0), new FdocaSimpleDataArray(56, 1, 2, 1), new FdocaSimpleDataArray(57, 1, 2, 1), new FdocaSimpleDataArray(58, 1, 2, 1), new FdocaSimpleDataArray(59, 1, 2, 1), new FdocaSimpleDataArray(60, 2, 1, 0), new FdocaSimpleDataArray(61, 2, 1, 0), new FdocaSimpleDataArray(62, 2, 1, 1), new FdocaSimpleDataArray(63, 2, 1, 1), new FdocaSimpleDataArray(64, 2, 1, 1), new FdocaSimpleDataArray(65, 2, 1, 1), new FdocaSimpleDataArray(66, 2, 1, 0), new FdocaSimpleDataArray(67, 2, 1, 0), new FdocaSimpleDataArray(68, 0, 0, 2), new FdocaSimpleDataArray(69, 0, 0, 2), new FdocaSimpleDataArray(70, 3, 1, 2), new FdocaSimpleDataArray(71, 3, 1, 2), new FdocaSimpleDataArray(72, 2, 1, 2), new FdocaSimpleDataArray(73, 2, 1, 2), null, null, new FdocaSimpleDataArray(76, 3, 1, 1), new FdocaSimpleDataArray(77, 3, 1, 1), new FdocaSimpleDataArray(78, 2, 1, 1), new FdocaSimpleDataArray(79, 2, 1, 1), new FdocaSimpleDataArray(80, 0, 0, 1), new FdocaSimpleDataArray(81, 0, 0, 1), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new FdocaSimpleDataArray(190, 0, 0, 0), new FdocaSimpleDataArray(191, 0, 0, 0), null, null, null, null, null, null, null, null, new FdocaSimpleDataArray(200, 0, 0, 4), new FdocaSimpleDataArray(201, 0, 0, 4), new FdocaSimpleDataArray(202, 3, 1, 4), new FdocaSimpleDataArray(203, 3, 1, 4), new FdocaSimpleDataArray(204, 1, 2, 4), new FdocaSimpleDataArray(205, 1, 2, 4), new FdocaSimpleDataArray(206, 2, 1, 4), new FdocaSimpleDataArray(207, 2, 1, 4)};
        protocolToJdbcTypes_ = new int[]{0, 0, 4, 4, 5, 5, -6, -6, 3, 3, 8, 8, 7, 7, 3, 3, 3, 3, 3, 3, 0, 0, -5, -5, 0, 0, 0, 0, 0, 0, -8, -8, 91, 91, 92, 92, 93, 93, -2, -2, -3, -3, -4, -4, -3, -3, 1, 1, 1, 1, 12, 12, -1, -1, 0, 0, 0, 0, 0, 0, 1, 1, 12, 12, -1, -1, 1, 1, -3, -3, 12, 12, 12, 12, 0, 0, 12, 12, 12, 12, 2000, 2000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 0, 0, 0, 0, 0, 0, 0, 0, 2004, 2004, 2005, 2005, 0, 0, 2005, 2005};
    }
}

