/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.spi;

import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.DB2Pool;
import io.vertx.db2client.impl.DB2ConnectionFactory;
import io.vertx.db2client.impl.DB2PoolImpl;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.spi.ConnectionFactory;
import io.vertx.sqlclient.spi.Driver;
import java.util.List;

public class DB2Driver
implements Driver {
    public DB2Pool createPool(Vertx vertx, List<? extends SqlConnectOptions> databases, PoolOptions options) {
        return DB2PoolImpl.create((VertxInternal)vertx, false, databases, options);
    }

    public DB2Pool createClient(Vertx vertx, List<? extends SqlConnectOptions> servers, PoolOptions options) {
        return DB2PoolImpl.create((VertxInternal)vertx, true, servers, options);
    }

    public boolean acceptsOptions(SqlConnectOptions options) {
        return options instanceof DB2ConnectOptions || SqlConnectOptions.class.equals(options.getClass());
    }

    public ConnectionFactory createConnectionFactory(Vertx vertx, SqlConnectOptions database) {
        return new DB2ConnectionFactory((VertxInternal)vertx, DB2ConnectOptions.wrap(database));
    }
}

