/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl;

import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.DB2Pool;
import io.vertx.db2client.impl.DB2ConnectionImpl;
import io.vertx.db2client.spi.DB2Driver;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.PoolBase;
import io.vertx.sqlclient.impl.SqlConnectionImpl;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import io.vertx.sqlclient.spi.ConnectionFactory;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class DB2PoolImpl
extends PoolBase<DB2PoolImpl>
implements DB2Pool {
    public static DB2PoolImpl create(VertxInternal vertx, boolean pipelined, List<? extends SqlConnectOptions> servers, PoolOptions poolOptions) {
        VertxInternal vx;
        DB2ConnectOptions baseConnectOptions = DB2ConnectOptions.wrap(servers.get(0));
        if (vertx == null) {
            if (Vertx.currentContext() != null) {
                throw new IllegalStateException("Running in a Vertx context => use DB2Pool#pool(Vertx, DB2ConnectOptions, PoolOptions) instead");
            }
            vx = (VertxInternal)Vertx.vertx();
        } else {
            vx = vertx;
        }
        QueryTracer tracer = vx.tracer() == null ? null : new QueryTracer(vx.tracer(), (SqlConnectOptions)baseConnectOptions);
        VertxMetrics vertxMetrics = vx.metricsSPI();
        int pipeliningLimit = pipelined ? baseConnectOptions.getPipeliningLimit() : 1;
        ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(baseConnectOptions.getSocketAddress(), "sql", baseConnectOptions.getMetricsName()) : null;
        DB2PoolImpl pool = new DB2PoolImpl(vx, pipeliningLimit, poolOptions, baseConnectOptions, null, tracer, metrics);
        pool.init();
        DB2Driver driver = new DB2Driver();
        List lst = servers.stream().map(options -> driver.createConnectionFactory((Vertx)vx, (SqlConnectOptions)options)).collect(Collectors.toList());
        ConnectionFactory factory = ConnectionFactory.roundRobinSelector(lst);
        pool.connectionProvider(arg_0 -> ((ConnectionFactory)factory).connect(arg_0));
        CloseFuture closeFuture = pool.closeFuture();
        closeFuture.add((Closeable)factory);
        if (vertx == null) {
            closeFuture.future().onComplete(ar -> vx.close());
        } else {
            ContextInternal ctx = vx.getContext();
            if (ctx != null) {
                ctx.addCloseHook((Closeable)closeFuture);
            } else {
                vx.addCloseHook((Closeable)closeFuture);
            }
        }
        return pool;
    }

    private DB2PoolImpl(VertxInternal vertx, int pipeliningLimit, PoolOptions poolOptions, DB2ConnectOptions baseConnectOptions, Supplier<Future<SqlConnectOptions>> connectOptionsProvider, QueryTracer tracer, ClientMetrics metrics) {
        super(vertx, (SqlConnectOptions)baseConnectOptions, connectOptionsProvider, tracer, metrics, pipeliningLimit, poolOptions);
    }

    protected SqlConnectionImpl wrap(ContextInternal context, ConnectionFactory factory, Connection conn) {
        return new DB2ConnectionImpl(context, factory, conn, this.tracer, this.metrics);
    }

    @Override
    public DB2Pool connectHandler(Handler<SqlConnection> handler) {
        return (DB2Pool)super.connectHandler(handler);
    }
}

