/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.core.Handler;
import io.vertx.db2client.DB2Exception;
import io.vertx.db2client.impl.codec.AuthenticationCommandBaseCodec;
import io.vertx.db2client.impl.codec.DB2Encoder;
import io.vertx.db2client.impl.command.InitialHandshakeCommand;
import io.vertx.db2client.impl.drda.DRDAConnectRequest;
import io.vertx.db2client.impl.drda.DRDAConnectResponse;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.command.CommandResponse;

class InitialHandshakeCommandCodec
extends AuthenticationCommandBaseCodec<Connection, InitialHandshakeCommand> {
    private static final int TARGET_SECURITY_MEASURE = 3;
    private ConnectionState status = ConnectionState.CONNECTING;

    InitialHandshakeCommandCodec(InitialHandshakeCommand cmd) {
        super(cmd);
    }

    @Override
    void encode(DB2Encoder encoder) {
        super.encode(encoder);
        encoder.socketConnection.connMetadata.databaseName = ((InitialHandshakeCommand)this.cmd).database();
        encoder.socketConnection.closeHandler((Handler<Void>)((Handler)h -> {
            if (this.status == ConnectionState.CONNECTING) {
                ((InitialHandshakeCommand)this.cmd).fail(new DB2Exception("The connection was closed by the database server.", -4499, "08004.C.3"));
            }
        }));
        ByteBuf packet = this.allocateBuffer();
        int packetStartIdx = packet.writerIndex();
        DRDAConnectRequest connectRequest = new DRDAConnectRequest(packet, encoder.socketConnection.connMetadata);
        connectRequest.buildEXCSAT("db2jnt_application  JNT00001300", 10, 7, 12, 10, 0, 0, 0, 0, 0, 1208);
        connectRequest.buildACCSEC(3, ((InitialHandshakeCommand)this.cmd).database(), null);
        encoder.socketConnection.connMetadata.correlationToken = connectRequest.getCorrelationToken(encoder.socketConnection.socket().localAddress().port());
        connectRequest.completeCommand();
        int lenOfPayload = packet.writerIndex() - packetStartIdx;
        this.sendPacket(packet, lenOfPayload);
    }

    @Override
    void decodePayload(ByteBuf payload, int payloadLength) {
        DRDAConnectResponse response = new DRDAConnectResponse(payload, this.encoder.socketConnection.connMetadata);
        switch (this.status) {
            case CONNECTING: {
                response.readExchangeServerAttributes();
                try {
                    response.readAccessSecurity(3);
                }
                catch (DB2Exception de) {
                    this.status = ConnectionState.CONNECT_FAILED;
                    throw de;
                }
                ByteBuf packet = this.allocateBuffer();
                int packetStartIdx = packet.writerIndex();
                DRDAConnectRequest connectRequest = new DRDAConnectRequest(packet, this.encoder.socketConnection.connMetadata);
                connectRequest.buildSECCHK(3, ((InitialHandshakeCommand)this.cmd).database(), ((InitialHandshakeCommand)this.cmd).username(), ((InitialHandshakeCommand)this.cmd).password(), null, null);
                connectRequest.buildACCRDB(((InitialHandshakeCommand)this.cmd).database(), false, this.encoder.socketConnection.connMetadata.correlationToken, "QTDSQLASC");
                connectRequest.completeCommand();
                int lenOfPayload = packet.writerIndex() - packetStartIdx;
                System.out.println("packet length: " + lenOfPayload);
                this.sendPacket(packet, lenOfPayload);
                this.status = ConnectionState.AUTHENTICATING;
                break;
            }
            case AUTHENTICATING: {
                response.readSecurityCheck();
                DRDAConnectResponse.RDBAccessData accData = response.readAccessDatabase();
                if (accData.correlationToken != null) {
                    this.encoder.socketConnection.connMetadata.correlationToken = accData.correlationToken;
                }
                this.status = ConnectionState.CONNECTED;
                this.completionHandler.handle((Object)CommandResponse.success((Object)((InitialHandshakeCommand)this.cmd).connection()));
                break;
            }
            default: {
                ((InitialHandshakeCommand)this.cmd).fail(new DB2Exception("The connection was unable to be established. Invalid connection state.", -4499, "08004.C.3"));
            }
        }
    }

    private static enum ConnectionState {
        CONNECTING,
        AUTHENTICATING,
        CONNECTED,
        CONNECT_FAILED;

    }
}

