/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.codec;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.vertx.db2client.impl.DB2SocketConnection;
import io.vertx.db2client.impl.codec.CommandCodec;
import io.vertx.db2client.impl.codec.DB2Decoder;
import io.vertx.db2client.impl.codec.DB2Encoder;
import java.util.ArrayDeque;

public class DB2Codec
extends CombinedChannelDuplexHandler<DB2Decoder, DB2Encoder> {
    static final int PACKET_PAYLOAD_LENGTH_LIMIT = 0xFFFFFF;
    private final ArrayDeque<CommandCodec<?, ?>> inflight = new ArrayDeque();

    public DB2Codec(DB2SocketConnection db2SocketConnection) {
        DB2Encoder encoder = new DB2Encoder(this.inflight, db2SocketConnection);
        DB2Decoder decoder = new DB2Decoder(this.inflight);
        this.init((ChannelInboundHandler)decoder, (ChannelOutboundHandler)encoder);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.clearInflightCommands("Failed to read any response from the server, the underlying connection may have been lost unexpectedly.");
        super.channelInactive(ctx);
    }

    private void clearInflightCommands(String failureMsg) {
        for (CommandCodec<?, ?> commandCodec : this.inflight) {
            commandCodec.cmd.fail(failureMsg);
        }
    }
}

