/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.impl.codec.DB2Codec;
import io.vertx.db2client.impl.command.InitialHandshakeCommand;
import io.vertx.db2client.impl.drda.ConnectionMetaData;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.QueryResultHandler;
import io.vertx.sqlclient.impl.SocketConnectionBase;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.CommandResponse;
import io.vertx.sqlclient.impl.command.QueryCommandBase;
import io.vertx.sqlclient.impl.command.SimpleQueryCommand;
import io.vertx.sqlclient.impl.command.TxCommand;
import io.vertx.sqlclient.spi.DatabaseMetadata;
import java.util.Map;
import java.util.function.Predicate;

public class DB2SocketConnection
extends SocketConnectionBase {
    private final DB2ConnectOptions connectOptions;
    private DB2Codec codec;
    private Handler<Void> closeHandler;
    public final ConnectionMetaData connMetadata = new ConnectionMetaData();

    public DB2SocketConnection(NetSocketInternal socket, ClientMetrics clientMetrics, DB2ConnectOptions connectOptions, boolean cachePreparedStatements, int preparedStatementCacheSize, Predicate<String> preparedStatementCacheSqlFilter, int pipeliningLimit, EventLoopContext context) {
        super(socket, clientMetrics, cachePreparedStatements, preparedStatementCacheSize, preparedStatementCacheSqlFilter, pipeliningLimit, context);
        this.connectOptions = connectOptions;
    }

    void sendStartupMessage(String username, String password, String database, Map<String, String> properties, Promise<Connection> completionHandler) {
        InitialHandshakeCommand cmd = new InitialHandshakeCommand(this, username, password, database, properties);
        this.schedule((ContextInternal)this.context, cmd).onComplete(completionHandler);
    }

    protected SqlConnectOptions connectOptions() {
        return this.connectOptions;
    }

    public void init() {
        this.codec = new DB2Codec(this);
        ChannelPipeline pipeline = this.socket.channelHandlerContext().pipeline();
        pipeline.addBefore("handler", "codec", (ChannelHandler)this.codec);
        super.init();
    }

    protected <R> void doSchedule(CommandBase<R> cmd, Handler<AsyncResult<R>> handler) {
        if (cmd instanceof TxCommand) {
            TxCommand txCmd = (TxCommand)cmd;
            if (txCmd.kind == TxCommand.Kind.BEGIN) {
                cmd.handler = handler;
                cmd.complete(CommandResponse.success((Object)txCmd.result).toAsyncResult());
            } else {
                SimpleQueryCommand cmd2 = new SimpleQueryCommand(txCmd.kind.sql, false, false, QueryCommandBase.NULL_COLLECTOR, QueryResultHandler.NOOP_HANDLER);
                super.doSchedule((CommandBase)cmd2, ar -> handler.handle((Object)ar.map(txCmd.result)));
            }
        } else {
            super.doSchedule(cmd, handler);
        }
    }

    public void handleClose(Throwable t) {
        super.handleClose(t);
        this.context().runOnContext(this.closeHandler);
    }

    public DatabaseMetadata getDatabaseMetaData() {
        return this.connMetadata.getDbMetadata();
    }

    public DB2SocketConnection closeHandler(Handler<Void> handler) {
        this.closeHandler = handler;
        return this;
    }
}

